/*
    SDL_archive
    Copyright (C) 2004  Kazunori Itoyanagi

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Kazunori Itoyanagi
    itkz@users.sourceforge.jp
*/

#include <stdio.h>
#include <stdlib.h>
#include "SDL.h"
#include "SDL_error.h"
#include "SDL_archive.h"
#include "SDL_rwops.h"


static int SDL_Archive2RWseek(SDL_RWops *context, int offset, int whence)
{
	int check;
	
	check = Archive_Seek((SDL_Archive*)context->hidden.unknown.data1, offset, whence);
	if (check != ARCHIVE_SUCCESS) {
		SDL_SetError("SDL_RWops on SDL_Archive : Error seeking in datastream");
		return -1;
	} else {
		return Archive_Tell((SDL_Archive*)context->hidden.unknown.data1);
	}
}


static int SDL_Archive2RWread(SDL_RWops *context, void *ptr, int size, int maxnum)
{
	size_t nread;
	
	nread = Archive_Read((SDL_Archive*)context->hidden.unknown.data1, ptr, size, maxnum);
	if (size * maxnum != 0 && nread == 0) {
		SDL_SetError("SDL_RWops on SDL_Archive : Error reading from datastream");
	}
	
	return nread;
}


static int SDL_Archive2RWwrite(SDL_RWops *context, const void *ptr, int size, int num)
{
	SDL_SetError("SDL_RWops on SDL_Archive : Writing is not support ");
	return 0;
}


static int SDL_Archive2RWclose(SDL_RWops *context)
{
	Archive_Close((SDL_Archive*)context->hidden.unknown.data1);
	return 0;
}


SDL_RWops *SDL_RWFromArchive(SDL_Archive *arc, const char *file)
{
	int check;
	SDL_RWops *rwops;
	
	check = Archive_Open(arc, file);
	if (check != ARCHIVE_SUCCESS) {
		return NULL;
	}
	
	rwops = SDL_AllocRW();
	if (rwops != NULL) {
		rwops->seek = SDL_Archive2RWseek;
		rwops->read = SDL_Archive2RWread;
		rwops->write = SDL_Archive2RWwrite;
		rwops->close = SDL_Archive2RWclose;
		rwops->hidden.unknown.data1 = (void*)arc;
	}
	return rwops;
}

SDL_RWops *SDL_RWFromArchiveWithClone(SDL_Archive *arc, const char *file)
{
	int check;
	SDL_RWops *rwops;
	SDL_Archive *clone;
	
	clone = Archive_Clone(arc);
	if (clone == NULL) {
		return NULL;
	}
	
	check = Archive_Open(clone, file);
	if (check != ARCHIVE_SUCCESS) {
		Archive_Finish(clone);
		return NULL;
	}
	
	rwops = SDL_AllocRW();
	if (rwops != NULL) {
		rwops->seek = SDL_Archive2RWseek;
		rwops->read = SDL_Archive2RWread;
		rwops->write = SDL_Archive2RWwrite;
		rwops->close = SDL_Archive2RWclose;
		rwops->hidden.unknown.data1 = (void*)clone;
	}
	return rwops;
}


