
# setting include path for SDL headers

SDL_INCLUDE = D:\bcc\Include\sdl

# setting library path for "SDL.lib" and "SDLmain.lib"

SDL_LIB = D:\bcc\Lib\sdl




SOURCE = ..\..\test
LIB_SOURCE = ..\..\src

OBJECTS = $(SOURCE)\list.obj
LIBRARYS = SDL.lib SDLmain.lib SDL_archive.lib
TARGET = list.exe

LIB_FILES = $(LIB_SOURCE)\SDL_archive.c $(LIB_SOURCE)\SDL_archive.h $(LIB_SOURCE)\archive2rw.c $(LIB_SOURCE)\dir.c $(LIB_SOURCE)\tar.c $(LIB_SOURCE)\pkzip.c $(LIB_SOURCE)\gzfilter.c

CC = bcc32
LINKER = ilink32

DEFINES = -DWIN32 -DSDL_Swap16 -DSDL_Swap32 -D_BCC32 -DENABLE_WIN32
CFLAGS = -O2 -c -n$(SOURCE) -I$(LIB_SOURCE) -I$(SDL_INCLUDE)
LFLAGS = -tW  -L. -L$(SDL_LIB)

.SUFFIXES: .c .obj


#-----------------------------------------

$(SOURCE)\$(TARGET): $(OBJECTS) $(SOURCE)\SDL_archive.dll
	$(CC) $(LFLAGS) -e$(TARGET) $(OBJECTS) $(LIBRARYS)
	move $(TARGET) $(SOURCE)
	IF EXIST *.tds del *.tds

$(SOURCE)\SDL_archive.dll: SDL_archive.dll
	copy SDL_archive.dll $(SOURCE)

SDL_archive.dll: $(LIB_FILES)
	call make

$(SOURCE)\list.obj: $(SOURCE)\list.c $(LIB_SOURCE)\SDL_archive.h

.c.obj:
	$(CC) $(CFLAGS) $(DEFINES) $<

clean:
	IF EXIST $(SOURCE)\$(TARGET) del $(SOURCE)\$(TARGET)
	IF EXIST $(SOURCE)\SDL_archive.dll del $(SOURCE)\SDL_archive.dll
	FOR %A IN ($(OBJECTS)) DO IF EXIST %A del %A


