package jp.gr.java_conf.matoba.io;

import java.util.Vector;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.StringWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileFilter;
import java.io.Reader;
import java.io.Writer;
import java.io.IOException;

/**
 * @version 1.0
 *
 */

public final class FileUtil {
    /**
     * ftHgRXgN^B<br>
     * FileUtilstatic\bĥ݂ō\邽߁ACX^X̐h߂
     * privateɂB
     */
    private FileUtil(){
        super();
    }

    /**
     * JgfBNg̕ύXsB
     * @param dir ύX̃fBNg
     */
    public static final void changeCurrentDirectory(String dir) {
        //VXevpeB"user.dir"ςB
        java.util.Properties prop = System.getProperties();
        prop.put( "user.dir", dir );
    }
    /**
     * JgfBNg̎擾sB
     * @return JgfBNg
     */
    public static final String getCurrentDirectory() {
        //VXevpeB"user.dir"擾B
        java.util.Properties prop = System.getProperties();
        return (String)prop.get( "user.dir");
    }
    /**
     * @param in Rs[̓Xg[
     * @param out Rs[o̓Xg[
     * @throws IOException o̓G[ꍇ
     */
    public static void copy(InputStream in, OutputStream out) throws IOException{
        byte [] buffer = new byte[4096];
        int readbyte ;
        while ((readbyte = in.read(buffer)) != -1 ){
            out.write(buffer, 0, readbyte);
        }
    }
    /**
     * @param in Rs[̓Xg[
     * @param out Rs[o̓t@C
     * @throws IOException o̓G[ꍇ
     */
    public static void copy(InputStream in, File out) throws IOException{
        FileOutputStream fout = new FileOutputStream(out);
        copy(in, fout);
        fout.close();
        fout = null;
    }
    /**
     * @param in Rs[̓t@C
     * @param out Rs[o̓t@C
     * @throws IOException o̓G[ꍇ
     */
    public static void copy(File in, File out) throws IOException{
        FileInputStream fin = new FileInputStream(in);
        FileOutputStream fout = new FileOutputStream(out);
        copy(new FileInputStream(in), new FileOutputStream(out));
        fin.close();
        fout.close();
        fin = null;
        fout = null;
    }
    /**
     * @param in Rs[̓[_[
     * @param out Rs[o̓C^[
     * @throws IOException o̓G[ꍇ
     */
    public static void copy(Reader in, Writer out) throws IOException{
        BufferedReader bin = new BufferedReader(in);
        BufferedWriter bout = new BufferedWriter(out);

        String line;
        while((line = bin.readLine()) != null) {
            bout.write(line, 0, line.length());
            bout.newLine();
        }
        bout.flush();
        bin = null;
        bout = null;
    }
    /**
     * @param in Rs[̓[_[
     * @param out Rs[敶obt@[
     * @throws IOException o̓G[ꍇ
     */
    public static void copy(Reader in, StringBuffer out) throws IOException{
        StringWriter sw = new StringWriter();
        copy(in,sw);
        out.append(sw.toString());
        sw.close();
        sw = null;
    }

    /**
     * t@C̊gq(.̕)擾B
     * @param file FileIuWFNg
     * @return t@C̊gq(fBNg̏ꍇ͋)
     */
    public static String getSuffix(File file){
        if(file.isDirectory()) return "";

        String name = file.getName();
        String ext = name.substring(
                        name.indexOf(".") + 1,
                        name.length()
                    );
        return ext;
    }

    /**
     * fBNg쐬B
     * @param directory FileIuWFNg
     */
    public static void createDirectory(File directory){
        if(!directory.exists()){
            FileUtil.createDirectory(directory.getParentFile());
            directory.mkdir();
        }
    }

    /**
     * fileȉfilterɍvFileIuWFNg擾B
     * filternull̏ꍇAfileȉ̑SĂFileIuWFNg擾B
     * @param file FileIuWFNg
     * @param filter FileFilter
     * @return FileIuWFNgz
     */
    public static File[] getAllListFiles(File file, FileFilter filter){
        Vector filelist = new Vector();
        nestedSearchFiles(file, filter,filelist);

        File[] files = new File[filelist.size()];
        for(int i=0;i<files.length;i++){
            files[i] = (File)filelist.get(i);
        }
        return files;
    }

    /**
     * fileȉFileIuWFNg擾AFileIuWFNgzɓB
     * @param file FileIuWFNg
     * @param filter FileFilter
     * @param filelist FileIuWFNgz
     */
    private static void nestedSearchFiles(File file, FileFilter filter,
         Vector filelist){
        if(filter ==null || filter.accept(file)){
            filelist.add(file);
        }
        if(file.isDirectory()){
            File[] files = file.listFiles();
            for(int i=0;i < files.length;i++){
                nestedSearchFiles(files[i], filter, filelist);
            }
        }
    }
}
