package jp.gr.java_conf.matoba.tools.ant;

import java.util.Vector;
import java.util.Enumeration;
import java.io.File;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Parameter;

/**
 * Relaxer̎ssB<BR>
 *
 * 
 * <ul>
 * <li>srcdir</li>
 * <li>destdir</li>
 * <li>includes</li>
 * <li>excludes</li>
 * <li>jdbc</li>
 * <li>dtd</li>
 * <li>java</li>
 * <li>meta</li>
 * <li>html</li>
 * <li>xsl</li>
 * <li>cdl</li>
 * <li>rxm</li>
 * <li>rng</li>
 * <li>xsd</li>
 * <li>properties</li>
 * <li>verbose</li>
 * <li>package</li>
 * <li>options</li>
 * </ul>
 *
 * lXg^O:option<br>
 * 
 * <ul>
 * <li>name</li>
 * <li>value</li>
 * </ul>
 *
 * @see jp.gr.java_conf.jaba2.Relaxer.Relaxer
 * @author T.Matoba
 * @version 0.1
 */

public class RelaxerTask extends MatchingTask {
    private Commandline cmd = new Commandline();
    private Vector options = new Vector();

    /** RpCs̃G[bZ[W */
    private static final String FAIL_MSG
        = "Compile failed, messages should have been provided.";
    protected boolean failOnError = true;

    private File destdir;

    /**
     * ^XN̎ssB
     * @throws BuildException sɎsꍇ
     */
    public void execute() throws BuildException {
        for (Enumeration e = options.elements(); e.hasMoreElements();) {
            Parameter param = (Parameter)e.nextElement();
            if(param.getName() != null){
                if(param.getValue() != null){
                    cmd.createArgument().setValue(
                        "-" + param.getName() + ":" + param.getValue());
                }
                else{
                    cmd.createArgument().setValue("-" + param.getName());
                }
            }
        }
        log("options: " + cmd, Project.MSG_DEBUG);

        // \[XfBNgXLARpCׂt@CT
        DirectoryScanner ds = super.fileset.getDirectoryScanner(project);
        ds.scan();
        String[] compileList = ds.getIncludedFiles();

        if (compileList.length > 0) {
            try{
                for(int i=0;i < compileList.length;i++){
                    String srcfile =
                        super.fileset.getDir(project).getPath()
                        + File.separator + compileList[i];

                    jp.gr.java_conf.jaba2.Relaxer.Relaxer app
                        = new jp.gr.java_conf.jaba2.Relaxer.Relaxer(
                            cmd + " " + srcfile);
                    app.showPrologue();
                    app.setup();
                    app.importSource();
                    app.execute();
                }
            }
            catch(Exception e){
                // RpCs
                e.printStackTrace();
                throw new BuildException(FAIL_MSG);
            }
        }
    }
    /**
     * \[XfBNgݒ肷B
     * @param srcDir \[XfBNg
     */
    public void setSrcdir(File srcDir) {
        super.fileset.setDir(srcDir);
    }
    /**
     * o̓fBNgݒ肷B
     * @param destdir o̓fBNg
     */
    public void setDestdir(File src) {
        cmd.createArgument().setValue("-dir:" + src.getAbsolutePath());
    }

    /**
     * JDBCANZXNX̐
     * @param value ftHg - false
     */
    public void setJdbc(boolean value){
        if(value){
            cmd.createArgument().setValue("-jdbc");
        }
    }

    /**
     * DTD̐
     * @param value ftHg - false
     */
    public void setDtd(boolean value){
        if(value){
            cmd.createArgument().setValue("-dtd");
        }
    }

    /**
     * JavaNX̐
     * @param value ftHg - true
     */
    public void setJava(boolean value){
        if(value){
            cmd.createArgument().setValue("-java");
        }
    }

    /**
     * Relaxerf̐܂B
     * @param value ftHg - false
     */
    public void setMeta(boolean value){
        if(value){
            cmd.createArgument().setValue("-meta");
        }
    }

    /**
     * HTMLt@C̃ev[g𐶐܂B
     * @param value
     */
    public void setHtml(boolean value) {
        if (value){
            cmd.createArgument().setValue("-html");
        }
    }

    /**
     *
     * @param value
     */
    public void setXslt(boolean value) {
        if (value){
            cmd.createArgument().setValue("-xslt");
        }
    }

    /**
     *
     * @param value
     */
    public void setCdl(boolean value) {
        if (value){
            cmd.createArgument().setValue("-cdl");
        }
    }

    /**
     *
     * @param value
     */
    public void setRxm(boolean value) {
        if (value){
            cmd.createArgument().setValue("-rxm");
        }
    }

    /**
     * RELAX NG̃XL[}𐶐܂B
     * @param value
     */
    public void setRng(boolean value) {
        if (value){
            cmd.createArgument().setValue("-rng");
        }
    }

    /**
     * XML SchemãXL[}𐶐܂B
     * @param value
     */
    public void setXsd(boolean value) {
        if (value) {
            cmd.createArgument().setValue("-xsd");
        }
    }

    /**
     * gpvpeBt@Cݒ肵܂B
     * @param value ftHg -
     */
    public void setProperties(File value) {
        cmd.createArgument().setValue("-properties:" + value.getAbsolutePath());
    }

    /**
     * s̏ڍ׏̕\s܂B
     * @param value ftHg - false
     */
    public void setVerbose(boolean value) {
        if(value){
            cmd.createArgument().setValue("-verbose");
        }
    }

    /**
     * NX̃pbP[Wݒ肵܂B
     * @param value ftHg -
     */
    public void setPackage(String value) {
        cmd.createArgument().setValue("-package:"+value);
    }

    public void setOptions(String value) {
        java.util.StringTokenizer st = new java.util.StringTokenizer(value);
        while(st.hasMoreTokens()){
            cmd.createArgument().setValue(st.nextToken());
        }
    }

    public Parameter createOption() {
        Parameter param = new Parameter();
        options.add(param);
        return param;
    }
}
