/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.jni.io;

import java.nio.ByteBuffer;
import org.maachang.jni.io.AbstractNativeBuffer;
import org.maachang.jni.io.Unsafe;

public class MemoryByteBuffer
extends AbstractNativeBuffer {
    private ByteBuffer buf = null;

    public MemoryByteBuffer() {
    }

    public MemoryByteBuffer(ByteBuffer buf) throws Exception {
        this.create(buf);
    }

    public MemoryByteBuffer(ByteBuffer buf, int offset, int length) throws Exception {
        this.create(buf, offset, length);
    }

    protected void finalize() throws Exception {
        this.clear();
    }

    public void create(ByteBuffer buf) throws Exception {
        this.clear();
        this.address = Unsafe.getDirectByteBufferNativeAddress(buf);
        this.length = buf.capacity();
        this.buf = buf;
    }

    public void create(ByteBuffer buf, int offset, int length) throws Exception {
        this.clear();
        this.address = Unsafe.getDirectByteBufferNativeAddress(buf) + (long)offset;
        this.length = length;
        this.buf = buf;
    }

    @Override
    public void clear() {
        this.buf = null;
        this.address = 0L;
        this.length = 0;
    }

    public ByteBuffer getByteBuffer() {
        return this.buf;
    }

    public int position() {
        return this.buf.position();
    }

    public void position(int pos) {
        this.buf.position(pos);
    }

    public int limit() {
        return this.buf.limit();
    }

    public void limit(int lim) {
        this.buf.limit(lim);
    }
}

