/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.jni.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.maachang.jni.io.IsOs;
import org.maachang.jni.io._atomicBOOL;

class NativeIO {
    private static final _atomicBOOL initFlag = new _atomicBOOL(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String targetDynamincLib(boolean mode, String lib) {
        String sp = System.getProperty("file.separator");
        File targetDir = null;
        targetDir = new File(System.getProperty("user.home") + sp + ".lib_work");
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        File outFile = new File(targetDir, lib);
        if (mode) {
            BufferedInputStream is;
            String ntvDir = "org/maachang/jni/io/native/";
            if (!(ntvDir = ntvDir.trim()).endsWith("/")) {
                ntvDir = ntvDir + "/";
            }
            if (ntvDir.startsWith("/")) {
                ntvDir = ntvDir.substring(1);
            }
            if (NativeIO.isLibFile(outFile, is = new BufferedInputStream(Thread.currentThread().getContextClassLoader().getResourceAsStream(ntvDir + lib)))) {
                try {
                    BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(outFile));
                    try {
                        try {
                            int n;
                            byte[] b = new byte[512];
                            while ((n = ((InputStream)is).read(b)) > 0) {
                                ((OutputStream)os).write(b, 0, n);
                            }
                            ((OutputStream)os).flush();
                            ((OutputStream)os).close();
                            os = null;
                            ((InputStream)is).close();
                            is = null;
                        }
                        finally {
                            if (is != null) {
                                ((InputStream)is).close();
                                is = null;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw e;
                    }
                    finally {
                        if (os != null) {
                            ((OutputStream)os).close();
                            os = null;
                        }
                    }
                }
                catch (Exception e) {
                    outFile = null;
                }
            }
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                is = null;
            }
        }
        if (outFile != null) {
            return outFile.getAbsolutePath();
        }
        return null;
    }

    private static final boolean isLibFile(File f, InputStream in) {
        boolean ret = false;
        try {
            int len;
            ret = !f.exists() ? true : (len = (int)f.length()) <= 0 || len != in.available();
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    protected static final boolean useInit() {
        return initFlag.get();
    }

    protected NativeIO() {
    }

    private static native int init();

    protected static native long malloc(int var0);

    protected static native long realloc(long var0, int var2);

    protected static native void free(long var0);

    protected static native void memset(long var0, byte var2, int var3);

    protected static native void memcpy(long var0, long var2, int var4);

    protected static native byte getByte(long var0);

    protected static native void putByte(long var0, byte var2);

    protected static native void getBinary(long var0, byte[] var2, int var3, int var4);

    protected static native void putBinary(long var0, byte[] var2, int var3, int var4);

    protected static native void putChar(long var0, char var2);

    protected static native char getChar(long var0);

    protected static native void putShort(long var0, short var2);

    protected static native short getShort(long var0);

    protected static native void putInt(long var0, int var2);

    protected static native int getInt(long var0);

    protected static native void putLong(long var0, long var2);

    protected static native long getLong(long var0);

    protected static native int equalsBinary(long var0, long var2, int var4);

    protected static native long fnv64(long var0, int var2);

    protected static native int indexOf(long var0, int var2, byte[] var3, int var4);

    protected static native int lastIndexOf(long var0, int var2, int var3, byte[] var4, int var5);

    protected static native long open(int var0, int var1, byte[] var2);

    protected static native void close(long var0);

    protected static native int fsync(long var0);

    protected static native int read(long var0, long var2, long var4, int var6, int var7);

    protected static native int write(long var0, long var2, long var4, int var6, int var7);

    protected static native long getLength(long var0);

    protected static native int setLength(long var0, long var2);

    protected static native long getSeek(long var0);

    protected static native int createMmap(long[] var0, long var1, int var3, long var4, int var6);

    protected static native int closeMmap(long var0, long var2, int var4);

    protected static native int flushMmap(long var0, int var2);

    protected static native int pageFileLength();

    protected static native int pageFileShift();

    protected static native int mmapLength(int var0);

    static {
        int bit = IsOs.getInstance().getBit();
        if (bit == -1) {
            System.err.println("JavaVM\u6761\u4ef6\u306e\u53d6\u5f97\u306b\u5931\u6557");
            System.exit(-9);
        }
        String name = "io";
        StringBuilder libBuf = new StringBuilder().append(name).append("-");
        if (bit == 32) {
            libBuf.append("32-");
        } else if (bit == 64) {
            libBuf.append("64-");
        }
        String lib = libBuf.append("1.0.1").toString();
        libBuf = null;
        switch (IsOs.getInstance().getOS()) {
            case 33: {
                lib = lib + ".dll";
                System.load(NativeIO.targetDynamincLib(true, lib));
                if (NativeIO.init() != 0) {
                    System.err.println("NativeIO\u521d\u671f\u5316\u51e6\u7406\u5931\u6557");
                    System.exit(-1);
                }
                initFlag.set(true);
                break;
            }
            case 1: {
                lib = lib + ".so";
                System.load(NativeIO.targetDynamincLib(true, lib));
                initFlag.set(true);
                if (NativeIO.init() == 0) break;
                System.err.println("NativeIO\u521d\u671f\u5316\u51e6\u7406\u5931\u6557");
                System.exit(-1);
                break;
            }
            default: {
                initFlag.set(false);
            }
        }
    }
}

