/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.jni.io;

import java.io.IOException;
import org.maachang.jni.io.AbstractFastNativeBuffer;
import org.maachang.jni.io.AbstractNativeBuffer;
import org.maachang.jni.io.DirectMemoryIO;
import org.maachang.jni.io.FastMemoryBuffer;
import org.maachang.jni.io.NativeBuffer;
import org.maachang.jni.io.NativeIO;
import org.maachang.jni.io.NormalBuffer;

public final class CompressMemoryLzo {
    protected static final byte[] MAGIC = new byte[]{76, 90, 79};
    protected static final int MAGIC_LENGTH = MAGIC.length;
    protected static final int HEAD_LENGTH = MAGIC_LENGTH + 8;
    protected static final int CHUNKED_HEAD = 2;
    protected static final int DEFAULT_WRK_BUFFER_LENGTH = 65536;
    protected static final int DEFAULT_BUFFER_LENGTH = 524288;
    protected static final int DEFAULT_TMP_BUFFER_LENGTH = Short.MAX_VALUE;
    private NormalBuffer outBuffer = null;
    private long tmpAddress = 0L;
    private long wrkBuffer = 0L;
    private int wrkBufferLength = 0;
    private int adler32Code = 0;
    private long _pos = 0L;
    private int _bufLen = 0;
    private int _srcLen = 0;
    private long _addr = 0L;
    private int[] _wrk = new int[1];

    public CompressMemoryLzo() throws Exception {
        this._create(-1, null, -1);
    }

    public CompressMemoryLzo(int len) throws Exception {
        this._create(len, null, -1);
    }

    public CompressMemoryLzo(NormalBuffer buf) throws Exception {
        this._create(-1, buf, -1);
    }

    protected void finalize() throws Exception {
        this.close();
    }

    private void _create(int len, NormalBuffer buf, int wrkBufferLen) throws Exception {
        if (len < 524288) {
            len = 524288;
        }
        if (buf == null) {
            buf = new FastMemoryBuffer(len);
        } else if (buf.getLength() < 524288) {
            len = 524288;
            CompressMemoryLzo._defaultBuffer(buf);
        }
        if (wrkBufferLen < 65536) {
            wrkBufferLen = 65536;
        }
        this.wrkBuffer = DirectMemoryIO.malloc(wrkBufferLen);
        DirectMemoryIO.memset(this.wrkBuffer, (byte)0, wrkBufferLen);
        this.wrkBufferLength = wrkBufferLen;
        this.outBuffer = buf;
        this.tmpAddress = 0L;
        this.adler32Code = 0;
        this._pos = HEAD_LENGTH;
        this._bufLen = buf.getLength();
        this._srcLen = 0;
        this._addr = buf.getAddress();
        this._wrk[0] = 0;
        CompressMemoryLzo._putHeader(buf);
    }

    public void close() {
        if (this.wrkBuffer != 0L) {
            DirectMemoryIO.free(this.wrkBuffer);
            this.wrkBuffer = 0L;
        }
        if (this.tmpAddress != 0L) {
            DirectMemoryIO.free(this.tmpAddress);
            this.tmpAddress = 0L;
        }
        this.wrkBufferLength = 0;
        this.outBuffer = null;
        this.adler32Code = 0;
        this._pos = 0L;
        this._bufLen = 0;
        this._srcLen = 0;
        this._addr = 0L;
        this._wrk[0] = 0;
    }

    public boolean isClose() {
        return this.wrkBuffer == 0L;
    }

    public void reset() throws Exception {
        if (this.wrkBuffer == 0L) {
            throw new IOException("\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (this.tmpAddress != 0L) {
            DirectMemoryIO.free(this.tmpAddress);
            this.tmpAddress = 0L;
        }
        this.adler32Code = 0;
        DirectMemoryIO.memset(this.wrkBuffer, (byte)0, this.wrkBufferLength);
        this._pos = HEAD_LENGTH;
        this._srcLen = 0;
        this._wrk[0] = 0;
        if (this.outBuffer.getLength() > 524288) {
            CompressMemoryLzo._defaultBuffer(this.outBuffer);
            this._bufLen = 524288;
            this._addr = this.outBuffer.getAddress();
        }
        CompressMemoryLzo._putHeader(this.outBuffer);
    }

    public NormalBuffer finish() throws Exception {
        if (this.wrkBuffer == 0L) {
            throw new IOException("\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        this.outBuffer.putInt(MAGIC_LENGTH, this.adler32Code);
        this.outBuffer.putInt(MAGIC_LENGTH + 4, this._srcLen);
        return this.outBuffer;
    }

    public int getSize() throws Exception {
        if (this.wrkBuffer == 0L) {
            throw new IOException("\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        return (int)this._pos;
    }

    public int getSrcSize() throws Exception {
        if (this.wrkBuffer == 0L) {
            throw new IOException("\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        return this._srcLen;
    }

    public int getAdler32() throws Exception {
        if (this.wrkBuffer == 0L) {
            throw new IOException("\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        return this.adler32Code;
    }

    public void compress(NativeBuffer buf, int offset, int length) throws Exception {
        if (this.wrkBuffer == 0L) {
            throw new IOException("\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (buf == null || offset < 0 || length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        if (buf.getLength() < offset + length) {
            throw new IllegalArgumentException("\u6307\u5b9a\u5f15\u6570\u306e\u30aa\u30d5\u30bb\u30c3\u30c8\uff0b\u9577\u3055\u304c\u7b2c\u4e00\u5f15\u6570\u30d0\u30c3\u30d5\u30a1\u9577\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        int tmpLen = 0;
        int tmpPos = offset;
        long addr = buf.getAddress();
        while (length > tmpLen) {
            int res;
            int oneLen = length - tmpLen >= Short.MAX_VALUE ? Short.MAX_VALUE : length - tmpLen;
            if ((long)this._bufLen < this._pos + (long)oneLen + 2L) {
                this.addBuffer();
            }
            if ((res = NativeIO.lzo1xCompress(addr + (long)tmpPos, oneLen, this._addr + (this._pos + 2L), this._wrk, this.wrkBuffer)) != 0) {
                throw new IOException("\u5727\u7e2e\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + res);
            }
            this.adler32Code = NativeIO.adler32(this.adler32Code, addr + (long)tmpPos, oneLen);
            DirectMemoryIO.putShort(this._addr, (int)this._pos, (short)(this._wrk[0] & 0xFFFF));
            this._pos += (long)(this._wrk[0] + 2);
            tmpLen += oneLen;
            tmpPos += oneLen;
        }
        this._srcLen += length;
    }

    public void compress(byte[] buf, int offset, int length) throws Exception {
        if (this.wrkBuffer == 0L) {
            throw new IOException("\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (buf == null || offset < 0 || length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        if (buf.length < offset + length) {
            throw new IllegalArgumentException("\u6307\u5b9a\u5f15\u6570\u306e\u30aa\u30d5\u30bb\u30c3\u30c8\uff0b\u9577\u3055\u304c\u7b2c\u4e00\u5f15\u6570\u30d0\u30c3\u30d5\u30a1\u9577\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        if (this.tmpAddress == 0L) {
            this.tmpAddress = DirectMemoryIO.malloc(Short.MAX_VALUE);
        }
        int tmpLen = 0;
        int tmpPos = offset;
        while (length > tmpLen) {
            int oneLen = length - tmpLen >= Short.MAX_VALUE ? Short.MAX_VALUE : length - tmpLen;
            if ((long)this._bufLen < this._pos + (long)oneLen + 2L) {
                this.addBuffer();
            }
            DirectMemoryIO.putBinary(this.tmpAddress, 0, buf, tmpPos, oneLen);
            int res = NativeIO.lzo1xCompress(this.tmpAddress, oneLen, this._addr + (this._pos + 2L), this._wrk, this.wrkBuffer);
            if (res != 0) {
                throw new IOException("\u5727\u7e2e\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + res);
            }
            this.adler32Code = NativeIO.adler32(this.adler32Code, this.tmpAddress, oneLen);
            DirectMemoryIO.putShort(this._addr, (int)this._pos, (short)(this._wrk[0] & 0xFFFF));
            this._pos += (long)(this._wrk[0] + 2);
            tmpLen += oneLen;
            tmpPos += oneLen;
        }
        this._srcLen += length;
    }

    private static final void _putHeader(NormalBuffer buf) {
        buf.putBinary(0, MAGIC, 0, MAGIC_LENGTH);
        buf.putInt(MAGIC_LENGTH, 0);
    }

    private static final void _defaultBuffer(NormalBuffer buf) {
        if (buf instanceof AbstractFastNativeBuffer) {
            DirectMemoryIO.free(((AbstractFastNativeBuffer)((Object)buf)).address);
            ((AbstractFastNativeBuffer)((Object)buf)).address = DirectMemoryIO.malloc(524288);
            ((AbstractFastNativeBuffer)((Object)buf)).length = 524288;
        } else {
            DirectMemoryIO.free(((AbstractNativeBuffer)((Object)buf)).address);
            ((AbstractNativeBuffer)((Object)buf)).address = DirectMemoryIO.malloc(524288);
            ((AbstractNativeBuffer)((Object)buf)).length = 524288;
        }
    }

    private void addBuffer() {
        if (this.outBuffer instanceof AbstractFastNativeBuffer) {
            this._addr = DirectMemoryIO.realloc(this._addr, this._bufLen, this._bufLen + 524288 + 2);
            this._bufLen = this._bufLen + 524288 + 2;
            ((AbstractFastNativeBuffer)((Object)this.outBuffer)).address = this._addr;
            ((AbstractFastNativeBuffer)((Object)this.outBuffer)).length = this._bufLen;
        } else {
            this._addr = DirectMemoryIO.realloc(this._addr, this._bufLen, this._bufLen + 524288 + 2);
            this._bufLen = this._bufLen + 524288 + 2;
            ((AbstractNativeBuffer)((Object)this.outBuffer)).address = this._addr;
            ((AbstractNativeBuffer)((Object)this.outBuffer)).length = this._bufLen;
        }
    }
}

