/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.jni.io;

import java.io.IOException;
import org.maachang.jni.io.MmapBuffer;
import org.maachang.jni.io.NativeBuffer;
import org.maachang.jni.io.NativeIO;
import org.maachang.jni.io.NativeIODefine;
import org.maachang.jni.io.NativeRandomIO;

public class FastNativeRandomIO
extends NativeRandomIO {
    public FastNativeRandomIO(int opt, String name) throws Exception {
        long handle;
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (opt != 0) {
            opt = 2;
        }
        if ((handle = NativeIO.open(0, 0, opt, NativeIODefine.nativeString(name = NativeIODefine.fullPath(name)))) <= -1L) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u30aa\u30fc\u30d7\u30f3\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        this.handle = handle;
        this.name = name;
        this.opt = opt;
    }

    @Override
    protected void finalize() throws Exception {
        this.close();
    }

    @Override
    public void close() {
        if (this.handle != -1L) {
            for (Long key : this._mmapManager.keySet()) {
                ((MmapBuffer)this._mmapManager.get(key)).clear();
            }
            NativeIO.fsync(this.handle);
            NativeIO.close(this.handle);
        }
        this.handle = -1L;
        this.name = null;
    }

    @Override
    public void fsync() throws Exception {
        if (this.handle != -1L) {
            for (Long key : this._mmapManager.keySet()) {
                ((MmapBuffer)this._mmapManager.get(key)).flush();
            }
            if (NativeIO.fsync(this.handle) != 0) {
                throw new IOException("fsync\u51e6\u7406\u306b\u5931\u6557");
            }
        }
    }

    @Override
    public int read(NativeBuffer buffer, int offset, int length) throws Exception {
        return this.read(buffer, -1L, offset, length);
    }

    @Override
    public int read(NativeBuffer buffer, long seek, int offset, int length) throws Exception {
        return NativeIO.read(this.handle, seek, buffer.getAddress(), offset, length);
    }

    @Override
    public void write(NativeBuffer buffer, int offset, int length) throws Exception {
        this.write(buffer, -1L, offset, length);
    }

    @Override
    public void write(NativeBuffer buffer, long seek, int offset, int length) throws Exception {
        if (NativeIO.write(this.handle, seek, buffer.getAddress(), offset, length) <= -1) {
            throw new IOException("\u66f8\u8fbc\u307f\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
    }

    @Override
    public long getSeek() throws Exception {
        return NativeIO.getSeek(this.handle);
    }

    @Override
    public long length() throws Exception {
        return NativeIO.getLength(this.handle);
    }

    @Override
    public void length(long length) throws Exception {
        NativeIO.setLength(this.handle, length);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getOption() {
        return this.opt;
    }

    @Override
    public boolean isOpen() {
        return this.handle != -1L;
    }
}

