/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.jni.io;

import java.io.IOException;
import java.io.InputStream;
import org.maachang.jni.io.DirectMemoryIO;
import org.maachang.jni.io.LzoOutputStream;
import org.maachang.jni.io.NativeIO;

public class LzoInputStream
extends InputStream {
    protected static final byte[] MAGIC = LzoOutputStream.MAGIC;
    protected static final int MAGIC_LENGTH = LzoOutputStream.MAGIC_LENGTH;
    protected static final int WRK_BUFFER_LENGTH = 65536;
    private static final int NBUFFER_LENGTH = 262144;
    private static final int SRC_BUFFER_LENGTH = 131070;
    private static final int TMP_BUFFER_LENGTH = Short.MAX_VALUE;
    private InputStream parent = null;
    private boolean firstFlag = true;
    private boolean endFlag = false;
    private long _addr = 0L;
    private int _len = 0;
    private int _pos = 0;
    private long _srcAddr = 0L;
    private int _srcPos = 0;
    private int _srcLen = 0;
    private byte[] _tmp = null;
    private long _workMem = 0L;
    private int[] _wrk = new int[1];
    private int _adler32 = 0;
    private static final int STATE_NOT = 0;
    private static final int STATE_SUCCESS = 1;
    private static final int STATE_END = 9;

    private LzoInputStream() {
    }

    public LzoInputStream(InputStream parent) {
        if (parent == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.parent = parent;
        this._addr = DirectMemoryIO.malloc(262144);
        this._srcAddr = DirectMemoryIO.malloc(131070);
        this._workMem = DirectMemoryIO.malloc(65536);
        this._tmp = new byte[Short.MAX_VALUE];
    }

    protected void finalize() throws Exception {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        DirectMemoryIO.free(this._addr);
        this._addr = 0L;
        DirectMemoryIO.free(this._srcAddr);
        this._srcAddr = 0L;
        DirectMemoryIO.free(this._workMem);
        this._workMem = 0L;
        this._tmp = null;
    }

    @Override
    public int available() throws IOException {
        return -1;
    }

    @Override
    public int read() throws IOException {
        if (this._workMem == 0L) {
            throw new IOException("\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        if (this.endFlag) {
            return -1;
        }
        if (this._len <= this._pos) {
            this._readLzo();
            if (this._len <= this._pos && this.endFlag) {
                return -1;
            }
        }
        int ret = DirectMemoryIO.get(this._addr, this._pos) & 0xFF;
        ++this._pos;
        return ret;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException("\u30d0\u30a4\u30ca\u30ea\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this._workMem == 0L) {
            throw new IOException("\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        if (this.endFlag) {
            return -1;
        }
        if (b == null) {
            throw new NullPointerException("\u30d0\u30a4\u30ca\u30ea\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (off < 0 || len < 0 || len + off > b.length) {
            throw new IndexOutOfBoundsException("\u6307\u5b9a\u7bc4\u56f2\u304c\u4e0d\u6b63\u3067\u3059");
        }
        int cnt = 0;
        while (len > 0) {
            int plen;
            if (this._len <= this._pos) {
                this._readLzo();
                if (this._len <= this._pos && this.endFlag) {
                    if (cnt == 0) {
                        return -1;
                    }
                    return cnt;
                }
                plen = len > this._len ? this._len : len;
            } else {
                plen = this._len - this._pos;
                if (len < plen) {
                    plen = len;
                }
            }
            DirectMemoryIO.getBinary(this._addr, this._pos, b, off, plen);
            this._pos += plen;
            off += plen;
            len -= plen;
            cnt += plen;
        }
        return cnt;
    }

    private void _readLzo() throws IOException {
        if (this.endFlag) {
            return;
        }
        if (this._srcLen > this._srcPos && this._decompress() != 0) {
            return;
        }
        do {
            int len;
            if ((len = this.parent.read(this._tmp, 0, Short.MAX_VALUE)) <= -1) {
                if (this._decompress() == 0) {
                    throw new IOException("LZO\u89e3\u51cd\u51e6\u7406\u306b\u5931\u6557:\u7d42\u7aef\u307e\u3067\u8aad\u307f\u8fbc\u3093\u3060\u304c\u3001\u89e3\u51cd\u5bfe\u8c61\u306e\u584a\u9577\u3088\u308a\u30c7\u30fc\u30bf\u9577\u304c\u77ed\u3044");
                }
                return;
            }
            if (this._srcLen + len > 131070) {
                this._srcLen -= this._srcPos;
                DirectMemoryIO.compact(this._srcAddr, this._srcPos, 131070, this._srcLen);
                this._srcPos = 0;
                if (this._srcLen + len > 131070) {
                    throw new IOException("LZO\u89e3\u51cd\u51e6\u7406\u306b\u5931\u6557:\u584a\u9577\u304c64K\u3092\u8d8a\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308b");
                }
            }
            DirectMemoryIO.putBinary(this._srcAddr, this._srcLen, this._tmp, 0, len);
            this._srcLen += len;
        } while (this._decompress() == 0);
    }

    private int _decompress() throws IOException {
        int chunkedLen;
        if (this.firstFlag) {
            if (this._srcLen < MAGIC_LENGTH) {
                return 0;
            }
            for (int i = 0; i < MAGIC_LENGTH; ++i) {
                if (DirectMemoryIO.get(this._srcAddr, i) == MAGIC[i]) continue;
                throw new IOException("LZO\u5f62\u5f0f\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
            }
            this._srcPos += MAGIC_LENGTH;
            this.firstFlag = false;
        }
        if ((chunkedLen = DirectMemoryIO.getShort(this._srcAddr, this._srcPos) & 0xFFFF) == 0) {
            if (this._srcPos + 6 <= this._srcLen) {
                int srcAdler32 = DirectMemoryIO.getInt(this._srcAddr, this._srcPos + 2);
                if (this._adler32 != srcAdler32) {
                    throw new IOException("\u89e3\u51cd\u7d50\u679c\u306e\u30c1\u30a7\u30c3\u30af\u30b5\u30e0\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093");
                }
                this._srcPos += 6;
                this.endFlag = true;
                return 9;
            }
            return 0;
        }
        if (chunkedLen + this._srcPos + 2 <= this._srcLen) {
            int res = NativeIO.lzo1xDecompress(this._srcAddr + (long)(this._srcPos + 2), chunkedLen, this._addr, this._wrk, this._workMem);
            if (res != 0) {
                throw new IOException("\u89e3\u51cd\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + res);
            }
            this._srcPos = this._srcPos + 2 + chunkedLen;
            this._adler32 = NativeIO.adler32(this._adler32, this._addr, this._wrk[0]);
            this._len = this._wrk[0];
            this._pos = 0;
            return 1;
        }
        return 0;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public boolean isClose() {
        return this._workMem == 0L;
    }
}

