/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.jni.io;

import java.io.IOException;
import java.io.OutputStream;
import org.maachang.jni.io.DirectMemoryIO;
import org.maachang.jni.io.NativeIO;

public class LzoOutputStream
extends OutputStream {
    protected static final byte[] MAGIC = new byte[]{64, 76, 90, 79, 70};
    protected static final int MAGIC_LENGTH = MAGIC.length;
    protected static final int WRK_BUFFER_LENGTH = 65536;
    private static final int NBUFFER_LENGTH = 65535;
    private static final int SRC_BUFFER_LENGTH = Short.MAX_VALUE;
    private OutputStream parent = null;
    private boolean finishFlag = false;
    private boolean firstFlag = true;
    private long _addr = 0L;
    private long _srcAddr = 0L;
    private int _srcPos = 0;
    private byte[] _tmp = null;
    private long _workMem = 0L;
    private int[] _wrk = new int[1];
    private int _adler32 = 0;

    private LzoOutputStream() {
    }

    public LzoOutputStream(OutputStream parent) {
        if (parent == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.parent = parent;
        this._addr = DirectMemoryIO.malloc(65535);
        this._srcAddr = DirectMemoryIO.malloc(Short.MAX_VALUE);
        this._workMem = DirectMemoryIO.malloc(65536);
        this._tmp = new byte[65535];
    }

    protected void finalize() throws Exception {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void close() throws IOException {
        if (this._workMem == 0L) {
            return;
        }
        this.finish();
        DirectMemoryIO.free(this._addr);
        this._addr = 0L;
        DirectMemoryIO.free(this._srcAddr);
        this._srcAddr = 0L;
        DirectMemoryIO.free(this._workMem);
        this._workMem = 0L;
        this._tmp = null;
        this.parent.close();
    }

    public void finish() throws IOException {
        if (this.finishFlag) {
            return;
        }
        this.flush();
        DirectMemoryIO.putShort(this._addr, 0, (short)0);
        DirectMemoryIO.putInt(this._addr + 2L, 0, this._adler32);
        DirectMemoryIO.getBinary(this._addr, 0, this._tmp, 0, 6);
        this.parent.write(this._tmp, 0, 6);
        this.parent.flush();
        this.finishFlag = true;
    }

    @Override
    public void flush() throws IOException {
        if (this._workMem == 0L) {
            throw new IOException("\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        if (this._srcPos <= 0 || this.finishFlag) {
            return;
        }
        int res = NativeIO.lzo1xCompress(this._srcAddr, this._srcPos, this._addr + 2L, this._wrk, this._workMem);
        if (res != 0) {
            throw new IOException("LZO\u5727\u7e2e\u51e6\u7406\u306b\u5931\u6557:" + res);
        }
        this._adler32 = NativeIO.adler32(this._adler32, this._srcAddr, this._srcPos);
        DirectMemoryIO.putShort(this._addr, 0, (short)this._wrk[0]);
        DirectMemoryIO.getBinary(this._addr, 0, this._tmp, 0, this._wrk[0] + 2);
        if (this.firstFlag) {
            this.parent.write(MAGIC, 0, MAGIC_LENGTH);
            this.firstFlag = false;
        }
        this.parent.write(this._tmp, 0, this._wrk[0] + 2);
        this._srcPos = 0;
    }

    @Override
    public void write(int b) throws IOException {
        if (this._workMem == 0L || this.finishFlag) {
            if (this._workMem == 0L) {
                throw new IOException("\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
            }
            throw new IOException("\u65e2\u306b\u7d42\u4e86\u3057\u3066\u3044\u307e\u3059");
        }
        if (this._srcPos >= Short.MAX_VALUE) {
            this.flush();
        }
        DirectMemoryIO.put(this._srcAddr, this._srcPos, (byte)b);
        ++this._srcPos;
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this._workMem == 0L || this.finishFlag) {
            if (this._workMem == 0L) {
                throw new IOException("\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
            }
            throw new IOException("\u65e2\u306b\u7d42\u4e86\u3057\u3066\u3044\u307e\u3059");
        }
        if (b == null) {
            throw new NullPointerException("\u30d0\u30a4\u30ca\u30ea\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        block9: {
            if (this._workMem == 0L || this.finishFlag) {
                if (this._workMem == 0L) {
                    throw new IOException("\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
                }
                throw new IOException("\u65e2\u306b\u7d42\u4e86\u3057\u3066\u3044\u307e\u3059");
            }
            if (b == null) {
                throw new NullPointerException("\u30d0\u30a4\u30ca\u30ea\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException("\u6307\u5b9a\u7bc4\u56f2\u304c\u4e0d\u6b63\u3067\u3059");
            }
            if (len == 0) {
                return;
            }
            if (len > Short.MAX_VALUE - this._srcPos) {
                int plen = Short.MAX_VALUE - this._srcPos;
                while (true) {
                    DirectMemoryIO.putBinary(this._srcAddr, this._srcPos, b, off, plen);
                    this._srcPos += plen;
                    if (this._srcPos != Short.MAX_VALUE) {
                        this._srcPos = plen;
                        break block9;
                    }
                    this.flush();
                    off += plen;
                    if ((len -= plen) < Short.MAX_VALUE) {
                        plen = len;
                        continue;
                    }
                    plen = Short.MAX_VALUE;
                }
            }
            DirectMemoryIO.putBinary(this._srcAddr, this._srcPos, b, off, len);
            this._srcPos += len;
        }
    }

    public boolean isFinish() {
        return this.finishFlag;
    }

    public boolean isClose() {
        return this._workMem == 0L;
    }
}

