/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.jni.io;

import java.io.File;
import java.io.IOException;

abstract class NativeIODefine {
    public static final String VERSION = "1.0.2";
    protected static final String LIB_NAME = "io";
    protected static final String LIB_BIT_32 = "32-";
    protected static final String LIB_BIT_64 = "64-";
    protected static final String WINDOWS_LIB_PLUS = ".dll";
    protected static final String LINUX_LIB_PLUS = ".so";
    protected static final String NATIVE_PACKAGE = "org/maachang/jni/io/native/";
    protected static final String DEFAULT_DIR = ".lib_work";
    protected static final int MODE_RAND = 0;
    protected static final int MODE_SEQ = 1;
    protected static final int OPT_READ = 0;
    protected static final int OPT_WRITE = 1;
    protected static final int OPT_RW = 2;
    protected static final int MMAP_OPT_READ = 1;
    protected static final int MMAP_OPT_WRITE = 2;
    protected static final int OPEN_ALWAYS = 0;
    protected static final int OPEN_TRUNCATE = 1;

    NativeIODefine() {
    }

    protected static final boolean useFile(String name) {
        boolean ret;
        if (name == null || name.length() <= 0) {
            return false;
        }
        try {
            File file = new File(name);
            ret = file.exists() ? (!file.isDirectory() ? file.canRead() : false) : false;
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    protected static final String fullPath(String path) throws IOException {
        return new File(path).getCanonicalPath();
    }

    protected static final byte[] nativeString(String s) {
        if (s == null || (s = s.trim()).length() <= 0) {
            return new byte[1];
        }
        byte[] b = s.getBytes();
        int len = b.length;
        byte[] ret = new byte[len + 1];
        System.arraycopy(b, 0, ret, 0, len);
        ret[len] = 0;
        return ret;
    }
}

