/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.jni.io;

import java.io.IOException;
import java.io.InputStream;
import org.maachang.jni.io.DirectMemoryIO;
import org.maachang.jni.io.NativeBuffer;
import org.maachang.jni.io.NativeIO;
import org.maachang.jni.io.NativeIODefine;
import org.maachang.jni.io.NotFileException;

public class NativeInputStream
extends InputStream {
    private static final int ACCESS_MODE = 1;
    private static final int IO_OPT = 0;
    private static final int TEMP_LEN = 4096;
    private long address = 0L;
    private int position = 0;
    private int length = 0;
    private long handle = -1L;
    private long fileSize = 0L;
    private long allPos = 0L;

    private NativeInputStream() {
    }

    public NativeInputStream(String name) throws Exception {
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!NativeIODefine.useFile(name)) {
            throw new NotFileException("\u6307\u5b9a\u30d5\u30a1\u30a4\u30eb[" + name + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        name = NativeIODefine.fullPath(name);
        this.handle = NativeIO.open(1, 0, 0, NativeIODefine.nativeString(name));
        if (this.handle == -1L) {
            throw new IOException("\u6307\u5b9a\u30d5\u30a1\u30a4\u30eb[" + name + "]\u306e\u30aa\u30fc\u30d7\u30f3\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        this.fileSize = NativeIO.getLength(this.handle);
        this.address = DirectMemoryIO.malloc(4096);
    }

    protected void finalize() throws Exception {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        if (this.handle > -1L) {
            NativeIO.close(this.handle);
            this.handle = -1L;
            this.position = 0;
            this.length = -1;
            this.fileSize = -1L;
            this.allPos = -1L;
            if (this.address != 0L) {
                DirectMemoryIO.free(this.address);
                this.address = 0L;
            }
        }
    }

    @Override
    public int available() throws IOException {
        if (this.handle <= -1L) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        return (int)(this.fileSize - this.allPos & Integer.MAX_VALUE);
    }

    @Override
    public int read() throws IOException {
        if (this.handle <= -1L) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        if (this.length <= -1) {
            return -1;
        }
        if (this.position >= this.length) {
            this.length = NativeIO.sRead(this.handle, this.address, 4096);
            this.position = 0;
            if (this.length <= 0) {
                this.length = -1;
                return -1;
            }
        }
        int ret = DirectMemoryIO.get(this.address, this.position) & 0xFF;
        ++this.position;
        ++this.allPos;
        return ret;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException("\u30d0\u30a4\u30ca\u30ea\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.handle <= -1L) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        if (this.length <= -1) {
            return -1;
        }
        if (b == null) {
            throw new NullPointerException("\u30d0\u30a4\u30ca\u30ea\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (off < 0 || len < 0 || len + off > b.length) {
            throw new IndexOutOfBoundsException("\u6307\u5b9a\u7bc4\u56f2\u304c\u4e0d\u6b63\u3067\u3059");
        }
        int cnt = 0;
        while (len > 0) {
            int plen;
            if (this.position >= this.length) {
                this.position = 0;
                this.length = NativeIO.sRead(this.handle, this.address, 4096);
                if (this.length <= 0) {
                    this.length = -1;
                    return cnt;
                }
                plen = len > this.length ? this.length : len;
            } else {
                plen = this.length - this.position;
                if (len < plen) {
                    plen = len;
                }
            }
            DirectMemoryIO.getBinary(this.address, this.position, b, off, plen);
            this.position += plen;
            off += plen;
            len -= plen;
            cnt += plen;
        }
        return cnt;
    }

    public int readBuffer(NativeBuffer buf) throws IOException {
        if (buf == null || buf.isClear()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.handle <= -1L) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        return NativeIO.sRead(this.handle, buf.getAddress(), buf.getLength());
    }

    public int readBuffer(NativeBuffer buf, int off, int len) throws IOException {
        int bufLen;
        if (buf == null || buf.isClear() || (bufLen = buf.getLength()) <= 0 || off < 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int n = len = len <= 0 ? bufLen - off : len;
        if (len <= 0 || len > bufLen) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.handle == -1L) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        return NativeIO.sRead(this.handle, buf.getAddress() + (long)off, len);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public long length() throws Exception {
        if (this.handle == -1L) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        return NativeIO.getLength(this.handle);
    }
}

