package org.maachang.jni.io ;

/**
 * LZO圧縮／解凍.
 * 
 * @version 2011/01/03
 * @author  masahito suzuki
 * @since   SeabassNativeIO-1.0.0
 */
public abstract class Lzo {
    private Lzo() {}
    
    /**
     * adler32.
     * @param n 最初の数値を設定します.
     * @param addr 対象のメモリポインタを設定します.
     * @param len サイズを設定します.
     * @return int チェックサムが返されます.
     */
    public static int adler32( int n,long addr,int len ) {
        return NativeIO.adler32( n,addr,len ) ;
    }
    
    /**
     * 圧縮処理.
     * @param dst_len 圧縮結果のサイズが返されます.
     * @param src 圧縮対象のメモリポインタを設定します.
     * @param src_len 圧縮対象の長さを設定します.
     * @param dst 圧縮結果が格納されるメモリポインタを設定します.
     * @param wrkmem ワークメモリポインタを設定します.
     *               ワークメモリサイズは、大体64KByte程度を設定します.
     * @return int 処理結果が返されます.
     *             [0]以外の場合は、エラーとなります.
     */
    public static int compress( int[] dst_len,long src,int src_len,long dst,long wrkmem ) {
        return NativeIO.lzo1xCompress( src,src_len,dst,dst_len,wrkmem ) ;
    }
    
    /**
     * 解凍処理.
     * @param dst_len 解凍結果のサイズが返されます.
     * @param src 解凍対象のメモリポインタを設定します.
     * @param src_len 解凍対象の長さを設定します.
     * @param dst 解凍結果が格納されるメモリポインタを設定します.
     * @param wrkmem ワークメモリポインタを設定します.
     *               ワークメモリサイズは、大体64KByte程度を設定します.
     * @return int 処理結果が返されます.
     *             [0]以外の場合は、エラーとなります.
     */
    public static int decompress( int[] dst_len,long src,int src_len,long dst,long wrkmem ) {
        return NativeIO.lzo1xDecompress( src,src_len,dst,dst_len,wrkmem ) ;
    }
}
