package org.maachang.jni.io ;

/**
 * NativeBuffer.
 * 
 * @version 2010/06/04
 * @author  masahito suzuki
 * @since   SeabassNativeIO-1.0.0
 */
public interface NativeBuffer {
    /**
     * メモリクリア.
     */
    public void clear() ;
    
    /**
     * メモリ先頭アドレスを取得.
     * @return long メモリの先頭アドレスが返されます.
     */
    public long getAddress() ;
    
    /**
     * メモリサイズを取得.
     * @return int メモリサイズが返されます.
     */
    public int getLength() ;
    
    /**
     * メモリクリアチェック.
     * @return boolean [true]の場合、メモリはクリアされています.
     */
    public boolean isClear() ;
    
    /**
     * byte情報を設定.
     * @param index 対象のインデックス位置を設定します.
     * @param value 設定対象の情報を設定します.
     */
    public void putByte( int index,byte value ) ;
    
    /**
     * byte情報を取得.
     * @param index 対象のインデックス位置を設定します.
     * @return byte 情報が返されます.
     */
    public byte getByte( int index ) ;
    
    /**
     * binary情報を設定.
     * @param index 対象のインデックス位置を設定します.
     * @param value 設定対象の情報を設定します.
     * @param offset 対象のオフセット値を設定します.
     * @param length 対象のデータ長を設定します.
     * @return int 設定された長さが返されます.
     */
    public int putBinary( int index,byte[] value,int offset,int length ) ;
    
    /**
     * binary情報を取得.
     * @param index 対象のインデックス位置を設定します.
     * @param value 取得対象の情報を設定します.
     * @param offset 対象のオフセット値を設定します.
     * @param length 対象のデータ長を設定します.
     * @return int 設定された長さが返されます.
     */
    public int getBinary( int index,byte[] value,int offset,int length ) ;
    
    /**
     * boolean設定.
     * @param index 対象のインデックス位置を設定します.
     * @param value 設定対象の情報を設定します.
     */
    public void putBoolean( int index,boolean value ) ;
    
    /**
     * boolean取得.
     * @param index 対象のインデックス位置を設定します.
     * @return boolean 情報が返されます.
     */
    public boolean getBoolean( int index ) ;
    
    /**
     * char設定.
     * @param index 対象のインデックス位置を設定します.
     * @param value 設定対象の情報を設定します.
     */
    public void putChar( int index,char value ) ;
    
    /**
     * char取得.
     * @param index 対象のインデックス位置を設定します.
     * @return char 情報が返されます.
     */
    public char getChar( int index ) ;
    
    /**
     * short設定.
     * @param index 対象のインデックス位置を設定します.
     * @param value 設定対象の情報を設定します.
     */
    public void putShort( int index,short value ) ;
    
    /**
     * short取得.
     * @param index 対象のインデックス位置を設定します.
     * @return short 情報が返されます.
     */
    public short getShort( int index ) ;
    
    /**
     * int設定.
     * @param index 対象のインデックス位置を設定します.
     * @param value 設定対象の情報を設定します.
     */
    public void putInt( int index,int value ) ;
    
    /**
     * int取得.
     * @param index 対象のインデックス位置を設定します.
     * @return int 情報が返されます.
     */
    public int getInt( int index ) ;
    
    /**
     * long設定.
     * @param index 対象のインデックス位置を設定します.
     * @param value 設定対象の情報を設定します.
     */
    public void putLong( int index,long value ) ;
    
    /**
     * long取得.
     * @param index 対象のインデックス位置を設定します.
     * @return long 情報が返されます.
     */
    public long getLong( int index ) ;
    
    /**
     * float設定.
     * @param index 対象のインデックス位置を設定します.
     * @param value 設定対象の情報を設定します.
     */
    public void putFloat( int index,float value ) ;
    
    /**
     * float取得.
     * @param index 対象のインデックス位置を設定します.
     * @return float 情報が返されます.
     */
    public float getFloat( int index ) ;
    
    /**
     * double設定.
     * @param index 対象のインデックス位置を設定します.
     * @param value 設定対象の情報を設定します.
     */
    public void putDouble( int index,double value ) ;
    
    /**
     * double取得.
     * @param index 対象のインデックス位置を設定します.
     * @return double 情報が返されます.
     */
    public double getDouble( int index ) ;
    
    /**
     * IndexOf.
     * @param binary 検索対象バイナリを設定します.
     * @return int 操作位置が返されます.
     */
    public int indexOf( byte[] binary ) ;
    
    /**
     * IndexOf.
     * @param binary 検索対象バイナリを設定します.
     * @param index 対象の開始位置を設定します.
     * @return int 操作位置が返されます.
     */
    public int indexOf( byte[] binary,int index ) ;
    
    /**
     * IndexOf.
     * @param binary 検索対象バイナリを設定します.
     * @param index 対象の開始位置を設定します.
     * @param length 対象の長さを設定します.
     * @return int 操作位置が返されます.
     */
    public int indexOf( byte[] binary,int index,int length ) ;
    
    /**
     * lastIndexOf.
     * @param binary 検索対象バイナリを設定します.
     * @return int 操作位置が返されます.
     */
    public int lastIndexOf( byte[] binary ) ;
    
    /**
     * lastIndexOf.
     * @param binary 検索対象バイナリを設定します.
     * @param index 対象の開始位置を設定します.
     * @return int 操作位置が返されます.
     */
    public int lastIndexOf( byte[] binary,int index ) ;
    
    /**
     * 指定位置から長さまでのメモリを先頭アドレスに移動.
     * @param index 対象のインデックス値を設定します.
     * @param length 対象の長さを設定します.
     * @return boolean [true]の場合、成功しました.
     */
    public boolean compact( int index,int length ) ;
    
    /**
     * Javaバイナリ変換.
     * @return byte[] 変換されたJavaバイナリ情報が返されます.
     */
    public byte[] toBinary() ;
    
    /**
     * Javaバイナリ変換.
     * @param len 変換先のデータ長を設定します.
     * @return byte[] 変換されたJavaバイナリ情報が返されます.
     */
    public byte[] toBinary( int len ) ;
}

