package org.maachang.jni.io;

import java.io.File;
import java.io.IOException;

/**
 * NativeI/O定義.
 * 
 * @version 2008/11/29
 * @author  masahito suzuki
 * @since   SeabassNativeIO-1.0.0
 */
abstract class NativeIODefine {
    
    /**
     * バージョン.
     */
    public static final String VERSION = "1.0.2" ;
    
    /**
     * ライブラリ名
     */
    protected static final String LIB_NAME = "io" ;
    
    /**
     * 32Bitバージョン.
     */
    protected static final String LIB_BIT_32 = "32-" ;
    
    /**
     * 64Bitバージョン.
     */
    protected static final String LIB_BIT_64 = "64-" ;
    
    /**
     * Windowsライブラリ拡張子.
     */
    protected static final String WINDOWS_LIB_PLUS = ".dll" ;
    
    /**
     * Linuxライブラリ拡張子.
     */
    protected static final String LINUX_LIB_PLUS = ".so" ;
    
    /**
     * Nativeライブラリパス.
     */
    protected static final String NATIVE_PACKAGE = "org/maachang/jni/io/native/" ;
    
    /**
     * デフォルトライブラリ格納ディレクトリ名.
     */
    protected static final String DEFAULT_DIR = ".lib_work" ;
    
    /** ファイル存在チェック. **/
    protected static final boolean useFile( String name ) {
        boolean ret;
        if (name == null || name.length() <= 0) {
            return false;
        }
        try {
            File file = new File(name);
            ret = (file.exists() == true) ? ((file.isDirectory() == false) ? file
                    .canRead()
                    : false)
                    : false;
        } catch (Exception e) {
            ret = false;
        }
        return ret;
    }
    
    /** 指定ファイル名をフルパス変換 **/
    protected static final String fullPath( String path ) throws IOException {
        return new File(path).getCanonicalPath();
    }
    
    /** 文字列をNative変換. **/
    protected static final byte[] nativeString( String s ) {
        if( s == null || ( s = s.trim() ).length() <= 0 ) {
            return new byte[ 1 ] ;
        }
        byte[] b = s.getBytes() ;
        int len = b.length ;
        byte[] ret = new byte[ len+1 ] ;
        System.arraycopy( b,0,ret,0,len ) ;
        ret[ len ] = 0 ;
        return ret ;
    }
    
    /** ファイルアクセスモード : ランダム. **/
    protected static final int MODE_RAND = 0 ;
    
    /** ファイルアクセスモード : シーケンス. **/
    protected static final int MODE_SEQ = 1 ;
    
    /** ファイルI/Oモード : 読み込み. **/
    protected static final int OPT_READ = 0 ;
    
    /** ファイルI/Oモード : 書き込み. **/
    protected static final int OPT_WRITE = 1 ;
    
    /** ファイルI/Oモード : 読み込み＋書き込み. **/
    protected static final int OPT_RW = 2 ;
    
    /** MMAPモード : 読み込み. **/
    protected static final int MMAP_OPT_READ = 1 ;
    
    /** MMAPモード : 読み込み+書き込み. **/
    protected static final int MMAP_OPT_WRITE = 2 ;
    
    /** ファイルオープンモード :
        ファイルが存在しない場合は作成、ファイルが存在する場合は、上書き. **/
    protected static final int OPEN_ALWAYS = 0 ;
    
    /** ファイルオープンモード :
        ファイルが存在しない場合は無視、ファイルが存在する場合は、初期化(0byte). **/
    protected static final int OPEN_TRUNCATE = 1 ;
}
