/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.crypto;

import org.maachang.crypto.CryptoRsaException;

class CryptoAse {
    private static final int[] SBOX = new int[]{99, 124, 119, 123, 242, 107, 111, 197, 48, 1, 103, 43, 254, 215, 171, 118, 202, 130, 201, 125, 250, 89, 71, 240, 173, 212, 162, 175, 156, 164, 114, 192, 183, 253, 147, 38, 54, 63, 247, 204, 52, 165, 229, 241, 113, 216, 49, 21, 4, 199, 35, 195, 24, 150, 5, 154, 7, 18, 128, 226, 235, 39, 178, 117, 9, 131, 44, 26, 27, 110, 90, 160, 82, 59, 214, 179, 41, 227, 47, 132, 83, 209, 0, 237, 32, 252, 177, 91, 106, 203, 190, 57, 74, 76, 88, 207, 208, 239, 170, 251, 67, 77, 51, 133, 69, 249, 2, 127, 80, 60, 159, 168, 81, 163, 64, 143, 146, 157, 56, 245, 188, 182, 218, 33, 16, 255, 243, 210, 205, 12, 19, 236, 95, 151, 68, 23, 196, 167, 126, 61, 100, 93, 25, 115, 96, 129, 79, 220, 34, 42, 144, 136, 70, 238, 184, 20, 222, 94, 11, 219, 224, 50, 58, 10, 73, 6, 36, 92, 194, 211, 172, 98, 145, 149, 228, 121, 231, 200, 55, 109, 141, 213, 78, 169, 108, 86, 244, 234, 101, 122, 174, 8, 186, 120, 37, 46, 28, 166, 180, 198, 232, 221, 116, 31, 75, 189, 139, 138, 112, 62, 181, 102, 72, 3, 246, 14, 97, 53, 87, 185, 134, 193, 29, 158, 225, 248, 152, 17, 105, 217, 142, 148, 155, 30, 135, 233, 206, 85, 40, 223, 140, 161, 137, 13, 191, 230, 66, 104, 65, 153, 45, 15, 176, 84, 187, 22};
    private static final int[] SHIFT_ROW_TAB = new int[]{0, 5, 10, 15, 4, 9, 14, 3, 8, 13, 2, 7, 12, 1, 6, 11};
    private int[] sboxInv = null;
    private int[] shiftRowTabInv = null;
    private int[] xtime = null;

    public CryptoAse() {
        this.create();
    }

    public void create() {
        int i;
        this.sboxInv = new int[256];
        this.shiftRowTabInv = new int[16];
        this.xtime = new int[256];
        for (i = 0; i < 256; ++i) {
            this.sboxInv[CryptoAse.SBOX[i]] = i;
        }
        for (i = 0; i < 16; ++i) {
            this.shiftRowTabInv[CryptoAse.SHIFT_ROW_TAB[i]] = i;
        }
        for (i = 0; i < 128; ++i) {
            this.xtime[i] = i << 1;
            this.xtime[128 + i] = i << 1 ^ 0x1B;
        }
    }

    public void clear() {
        this.sboxInv = null;
        this.shiftRowTabInv = null;
        this.xtime = null;
    }

    public byte[] expandKey(byte[] key) {
        int ks;
        int len = key.length;
        switch (len) {
            case 16: {
                ks = 176;
                break;
            }
            case 24: {
                ks = 208;
                break;
            }
            case 32: {
                ks = 240;
                break;
            }
            default: {
                throw new CryptoRsaException("Only key lengths of 16, 24 or 32 bytes allowed!:" + len);
            }
        }
        int rcon = 1;
        int[] tmp = new int[4];
        byte[] ret = new byte[ks];
        System.arraycopy(key, 0, ret, 0, key.length);
        for (int i = len; i < ks; i += 4) {
            int p = i - 4;
            tmp[0] = ret[p] & 0xFF;
            tmp[1] = ret[p + 1] & 0xFF;
            tmp[2] = ret[p + 2] & 0xFF;
            tmp[3] = ret[p + 3] & 0xFF;
            if (i % len == 0) {
                int wk0 = SBOX[tmp[1]] ^ rcon;
                int wk1 = SBOX[tmp[2]];
                int wk2 = SBOX[tmp[3]];
                int wk3 = SBOX[tmp[0]];
                if ((rcon <<= 1) >= 256) {
                    rcon ^= 0x11B;
                }
                tmp[0] = wk0;
                tmp[1] = wk1;
                tmp[2] = wk2;
                tmp[3] = wk3;
            } else if (len > 24 && i % len == 16) {
                tmp[0] = SBOX[tmp[0]];
                tmp[1] = SBOX[tmp[1]];
                tmp[2] = SBOX[tmp[2]];
                tmp[3] = SBOX[tmp[3]];
            }
            for (int j = 0; j < 4; ++j) {
                ret[i + j] = (byte)((ret[i + j - len] & 0xFF ^ tmp[j]) & 0xFF);
            }
        }
        return ret;
    }

    private static final void subBytes(byte[] state, int[] sbox) {
        for (int i = 0; i < 16; ++i) {
            state[i] = (byte)sbox[state[i] & 0xFF];
        }
    }

    private static final void addRoundKey(byte[] state, byte[] rkey, int pos) {
        int len = rkey.length;
        len = pos + 16 > len ? len - pos : 16;
        for (int i = 0; i < len; ++i) {
            state[i] = (byte)(state[i] & 0xFF ^ rkey[pos + i] & 0xFF);
        }
    }

    private static final void shiftRows(byte[] state, int[] shiftTab) {
        byte[] h = state.length > 16 ? new byte[16] : new byte[state.length];
        System.arraycopy(state, 0, h, 0, h.length);
        for (int i = 0; i < 16; ++i) {
            state[i] = h[shiftTab[i]];
        }
    }

    private void mixColumns(byte[] state) {
        for (int i = 0; i < 16; i += 4) {
            byte s0 = state[i];
            byte s1 = state[i + 1];
            byte s2 = state[i + 2];
            byte s3 = state[i + 3];
            int h = (s0 ^ s1 ^ s2 ^ s3) & 0xFF;
            state[i] = (byte)(state[i] & 0xFF ^ h ^ this.xtime[(s0 ^ s1) & 0xFF]);
            state[i + 1] = (byte)(state[i + 1] & 0xFF ^ h ^ this.xtime[(s1 ^ s2) & 0xFF]);
            state[i + 2] = (byte)(state[i + 2] & 0xFF ^ h ^ this.xtime[(s2 ^ s3) & 0xFF]);
            state[i + 3] = (byte)(state[i + 3] & 0xFF ^ h ^ this.xtime[(s3 ^ s0) & 0xFF]);
        }
    }

    private void mixColumnsInv(byte[] state) {
        for (int i = 0; i < 16; i += 4) {
            byte s0 = state[i];
            byte s1 = state[i + 1];
            byte s2 = state[i + 2];
            byte s3 = state[i + 3];
            int h = (s0 ^ s1 ^ s2 ^ s3) & 0xFF;
            int xh = this.xtime[h];
            int h1 = this.xtime[this.xtime[xh ^ s0 & 0xFF ^ s2 & 0xFF]] ^ h;
            int h2 = this.xtime[this.xtime[xh ^ s1 & 0xFF ^ s3 & 0xFF]] ^ h;
            state[i] = (byte)(state[i] & 0xFF ^ h1 ^ this.xtime[(s0 ^ s1) & 0xFF]);
            state[i + 1] = (byte)(state[i + 1] & 0xFF ^ h2 ^ this.xtime[(s1 ^ s2) & 0xFF]);
            state[i + 2] = (byte)(state[i + 2] & 0xFF ^ h1 ^ this.xtime[(s2 ^ s3) & 0xFF]);
            state[i + 3] = (byte)(state[i + 3] & 0xFF ^ h2 ^ this.xtime[(s3 ^ s0) & 0xFF]);
        }
    }

    public void encrypt(byte[] block, byte[] key) throws Exception {
        int i;
        int len = key.length;
        CryptoAse.addRoundKey(block, key, 0);
        int loopLen = len - 16;
        for (i = 16; i < loopLen; i += 16) {
            CryptoAse.subBytes(block, SBOX);
            CryptoAse.shiftRows(block, SHIFT_ROW_TAB);
            this.mixColumns(block);
            CryptoAse.addRoundKey(block, key, i);
        }
        CryptoAse.subBytes(block, SBOX);
        CryptoAse.shiftRows(block, SHIFT_ROW_TAB);
        CryptoAse.addRoundKey(block, key, i);
    }

    public void decrypt(byte[] block, byte[] key) throws Exception {
        int len = key.length;
        CryptoAse.addRoundKey(block, key, len - 16);
        CryptoAse.shiftRows(block, this.shiftRowTabInv);
        CryptoAse.subBytes(block, this.sboxInv);
        for (int i = len - 32; i >= 16; i -= 16) {
            CryptoAse.addRoundKey(block, key, i);
            this.mixColumnsInv(block);
            CryptoAse.shiftRows(block, this.shiftRowTabInv);
            CryptoAse.subBytes(block, this.sboxInv);
        }
        CryptoAse.addRoundKey(block, key, 0);
    }
}

