/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.maachang.mimdb.MimdbException;

public class MimdbMaintenanceClient {
    private static final int MAX_READ = 4096;
    private static final String CHARSET = "UTF8";
    private static final int BASE_PORT = 3444;
    private byte[] buf = new byte[4096];
    private boolean closeFlag = true;
    private Socket socket;
    private String addr;
    private String bindAddr;
    private int port;
    private int bindPort;
    private int timeout;

    private MimdbMaintenanceClient() {
    }

    public MimdbMaintenanceClient(String addr, int port) throws Exception {
        this(addr, port, null, -1, -1);
    }

    public MimdbMaintenanceClient(String addr, int port, int timeout) throws Exception {
        this(addr, port, null, -1, timeout);
    }

    public MimdbMaintenanceClient(String addr, int port, String bindAddr, int bindPort, int timeout) throws Exception {
        if (addr == null || (addr = addr.trim()).length() <= 0 || "null".equals(addr)) {
            addr = "127.0.0.1";
        }
        if (port > 65535 || port < 0) {
            port = 3444;
        }
        if (timeout <= -1) {
            timeout = 30000;
        }
        if (bindPort > 65535 || bindPort < 0) {
            bindPort = -1;
            bindAddr = null;
        }
        this.addr = addr;
        this.port = port;
        this.bindAddr = bindAddr;
        this.bindPort = bindPort;
        this.timeout = timeout;
        this.reConnection();
    }

    private final void reConnection() throws Exception {
        Socket s;
        this.close();
        System.setProperty("networkaddress.cache.ttl", "300");
        System.setProperty("networkaddress.cache.negative.ttl", "0");
        if (this.bindPort != -1) {
            s = new Socket();
            if (this.bindAddr != null) {
                s.bind(new InetSocketAddress(InetAddress.getByName(this.bindAddr), this.bindPort));
            } else {
                s.bind(new InetSocketAddress(this.bindPort));
            }
            s.connect(new InetSocketAddress(InetAddress.getByName(this.addr), this.port));
        } else {
            s = new Socket();
            s.connect(new InetSocketAddress(InetAddress.getByName(this.addr), this.port));
        }
        s.setReuseAddress(true);
        s.setSoLinger(true, 5);
        s.setSendBufferSize(32768);
        s.setReceiveBufferSize(32768);
        s.setKeepAlive(false);
        s.setTcpNoDelay(true);
        s.setOOBInline(true);
        s.setSoTimeout(this.timeout);
        this.socket = s;
        this.closeFlag = false;
    }

    public void close() {
        this.closeFlag = true;
        try {
            this.socket.getInputStream().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.socket.getOutputStream().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isClose() {
        return this.closeFlag;
    }

    public String getAddress() {
        return this.addr;
    }

    public int getPort() {
        return this.port;
    }

    public String getBindAddress() {
        return this.bindAddr;
    }

    public int getBindPort() {
        return this.bindPort;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String execution(String cmd) throws Exception {
        if (cmd == null || (cmd = cmd.trim()).length() <= 0) {
            return "";
        }
        StringBuilder sBuf = null;
        try {
            byte[] b = cmd.getBytes(CHARSET);
            if (b.length + 2 > 4096) {
                throw new MimdbException("\u30b3\u30de\u30f3\u30c9\u9577\u304c\u9577\u3059\u304e\u307e\u3059[" + b.length + "]");
            }
            int len = b.length;
            this.buf[0] = (byte)(len & 0xFF);
            this.buf[1] = (byte)((len & 0xFF00) >> 8);
            System.arraycopy(b, 0, this.buf, 2, len);
            this.socket.getOutputStream().write(this.buf, 0, len + 2);
            this.socket.getOutputStream().flush();
            InputStream in = this.socket.getInputStream();
            sBuf = new StringBuilder();
            int bOff = 0;
            int bLen = 0;
            while (true) {
                if ((len = in.read(this.buf, bOff, 4096 - bOff)) <= 0) {
                    if (len <= -1) {
                        this.close();
                        break;
                    }
                    if (bOff < 2) continue;
                }
                if (bOff == 0) {
                    bLen = this.buf[0] & 0xFF | (this.buf[1] & 0xFF) << 8;
                    if (bLen <= -1 || bLen + 2 >= 4096) {
                        throw new MimdbException("\u4e0d\u6b63\u306a\u53d7\u4fe1\u30b5\u30a4\u30ba\u3092\u53d7\u4fe1\u3057\u307e\u3057\u305f[" + bLen + "]");
                    }
                    if (bLen == 0) break;
                }
                bOff += len;
                while (bOff >= bLen + 2) {
                    sBuf.append(new String(this.buf, 2, bLen, CHARSET));
                    if (bOff == bLen + 2) {
                        bOff = 0;
                        continue;
                    }
                    MimdbMaintenanceClient.topBinary(this.buf, bLen + 2, bOff - (bLen + 2));
                    bOff -= bLen + 2;
                    bLen = this.buf[0] & 0xFF | (this.buf[1] & 0xFF) << 8;
                    if (bLen <= -1 || bLen + 2 >= 4096) {
                        throw new MimdbException("\u4e0d\u6b63\u306a\u53d7\u4fe1\u30b5\u30a4\u30ba\u3092\u53d7\u4fe1\u3057\u307e\u3057\u305f[" + bLen + "]");
                    }
                    if (bLen != 0) continue;
                    break;
                }
                if (bLen == 0) break;
            }
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
        return sBuf.toString();
    }

    private static final void topBinary(byte[] b, int off, int len) {
        int i = 0;
        while (i < len) {
            b[i] = b[i + off];
            ++i;
        }
    }

    private static final void errorCommand(String msg) {
        System.out.println("-ip [ipAddress or domain] -port [port] -bip [bindIpAddress] -bport [bindPort]");
        System.out.println(" -time [timeout] [command]");
        if (msg != null) {
            System.out.println(msg);
        }
        System.exit(-1);
    }

    public static final void main(String[] args) throws Exception {
        String addr = null;
        int port = -1;
        String bindAddr = null;
        int bindPort = -1;
        int timeout = -1;
        String cmd = null;
        if (args != null && args.length > 0) {
            int len = args.length;
            int type = -1;
            int i = 0;
            while (i < len) {
                String n = args[i].toLowerCase();
                if ("-help".equals(n)) {
                    MimdbMaintenanceClient.errorCommand(null);
                } else if ("-?".equals(n)) {
                    MimdbMaintenanceClient.errorCommand(null);
                } else if ("-ip".equals(n)) {
                    type = 1;
                } else if ("-addr".equals(n)) {
                    type = 1;
                } else if ("-port".equals(n)) {
                    type = 2;
                } else if ("-bip".equals(n)) {
                    type = 3;
                } else if ("-baddr".equals(n)) {
                    type = 3;
                } else if ("-bport".equals(n)) {
                    type = 4;
                } else if ("-time".equals(n)) {
                    type = 5;
                } else if ("-timeout".equals(n)) {
                    type = 5;
                } else {
                    switch (type) {
                        case 1: {
                            if (addr != null) {
                                MimdbMaintenanceClient.errorCommand("\u63a5\u7d9a\u5148IP\u30a2\u30c9\u30ec\u30b9\u304c\u591a\u91cd\u5b9a\u7fa9");
                            }
                            addr = args[i];
                            break;
                        }
                        case 2: {
                            if (port != -1) {
                                MimdbMaintenanceClient.errorCommand("\u63a5\u7d9a\u5148Port\u304c\u591a\u91cd\u5b9a\u7fa9");
                            }
                            port = Integer.parseInt(args[i]);
                            break;
                        }
                        case 3: {
                            if (bindAddr != null) {
                                MimdbMaintenanceClient.errorCommand("\u30d0\u30a4\u30f3\u30c9IP\u30a2\u30c9\u30ec\u30b9\u304c\u591a\u91cd\u5b9a\u7fa9");
                            }
                            bindAddr = args[i];
                            break;
                        }
                        case 4: {
                            if (bindPort != -1) {
                                MimdbMaintenanceClient.errorCommand("\u30d0\u30a4\u30f3\u30c9\u30dd\u30fc\u30c8\u304c\u591a\u91cd\u5b9a\u7fa9");
                            }
                            bindPort = Integer.parseInt(args[i]);
                            break;
                        }
                        case 5: {
                            if (timeout != -1) {
                                MimdbMaintenanceClient.errorCommand("\u53d7\u4fe1\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u304c\u591a\u91cd\u5b9a\u7fa9");
                            }
                            timeout = Integer.parseInt(args[i]);
                            break;
                        }
                        default: {
                            if (i + 1 == len) {
                                cmd = args[i];
                                if (!cmd.startsWith("\"") || !cmd.endsWith("\"")) break;
                                cmd = cmd.substring(1, cmd.length() - 1).trim();
                                break;
                            }
                            MimdbMaintenanceClient.errorCommand("\u30b3\u30de\u30f3\u30c9\u306e\u69cb\u6210\u304c\u4e0d\u6b63");
                        }
                    }
                    type = -1;
                }
                ++i;
            }
        }
        MimdbMaintenanceClient cl = new MimdbMaintenanceClient(addr, port, bindAddr, bindPort, timeout);
        if (cmd != null) {
            String res = cl.execution(cmd);
            System.out.println(res);
            System.exit(0);
        }
        BufferedReader bw = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.print(">");
            cmd = bw.readLine();
            if (cmd == null || cmd.length() <= 0) continue;
            if ("exit".equals(cmd)) {
                System.exit(0);
            }
            try {
                String res = cl.execution(cmd);
                System.out.println(res);
                continue;
            }
            catch (Exception e) {
                cl.reConnection();
                String res = cl.execution(cmd);
                System.out.println(res);
                continue;
            }
            break;
        }
    }
}

