/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core;

import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.MimdbBase;
import org.maachang.mimdb.core.MimdbPreparedStatement;
import org.maachang.mimdb.core.MimdbResult;
import org.maachang.mimdb.core.MimdbSearchElement;
import org.maachang.mimdb.core.MimdbTable;
import org.maachang.mimdb.core.MimdbTableManager;
import org.maachang.mimdb.core.SortElement;
import org.maachang.mimdb.core.impl.EqualsNoList;
import org.maachang.mimdb.core.impl.MimdbUtils;
import org.maachang.mimdb.core.impl.SqlAnalyzer;
import org.maachang.mimdb.core.impl.WhereBlock;
import org.maachang.mimdb.core.util.ObjectList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MimdbStatement
implements MimdbBase {
    protected long dbId = -1L;
    private String tableName = null;
    private final ObjectList<String> columns = new ObjectList();
    private boolean allColumn = true;
    private boolean countFlag = false;
    private final ObjectList<MimdbSearchElement> where = new ObjectList();
    private final ObjectList<String> sortList = new ObjectList();
    private final ObjectList<Boolean> descList = new ObjectList();
    private MimdbPreparedStatement compile = null;
    private int offset = -1;
    private int limit = -1;

    public MimdbStatement() {
    }

    public MimdbStatement(String table) throws Exception {
        this.setTable(table);
    }

    public static final MimdbStatement createStatement(String sql) throws Exception {
        MimdbStatement ret = new MimdbStatement();
        SqlAnalyzer.analysis(ret, sql);
        return ret;
    }

    public static final void createStatement(MimdbStatement out, String sql) throws Exception {
        SqlAnalyzer.analysis(out, sql);
    }

    public static final MimdbPreparedStatement createPrepared(String sql) throws Exception {
        MimdbStatement stmt = new MimdbStatement();
        SqlAnalyzer.analysis(stmt, sql);
        return stmt.compile();
    }

    public static final void createPrepared(MimdbPreparedStatement out, String sql) throws Exception {
        MimdbStatement stmt = new MimdbStatement();
        SqlAnalyzer.analysis(stmt, sql);
        stmt.compile(out);
    }

    public void clear() {
        this.dbId = -1L;
        this.tableName = null;
        this.columns.clear();
        this.allColumn = true;
        this.countFlag = false;
        this.where.clear();
        this.sortList.clear();
        this.descList.clear();
        this.compile = null;
        this.offset = -1;
        this.limit = -1;
    }

    public void setTable(String table) throws Exception {
        if (table == null || (table = table.trim().toLowerCase()).length() <= 0) {
            throw new MimdbException("\u30c6\u30fc\u30d6\u30eb\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        this.tableName = table;
    }

    @Override
    public long getDbId() {
        return this.dbId;
    }

    public String getName() {
        return this.tableName;
    }

    public void setViewColumn(String name) {
        if (name == null || (name = name.trim().toLowerCase()).length() <= 0) {
            throw new MimdbException("\u6307\u5b9a\u30ab\u30e9\u30e0\u540d\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if ("*".equals(name)) {
            this.allColumn = true;
            this.countFlag = false;
        } else {
            this.columns.add(name);
            this.allColumn = false;
            this.countFlag = false;
        }
    }

    public void setViewCount() {
        this.countFlag = true;
    }

    public ObjectList<String> getViewColumn() {
        return this.columns;
    }

    public boolean isAllView() {
        return this.allColumn;
    }

    public boolean isCountView() {
        return this.countFlag;
    }

    public void addWhere(MimdbSearchElement search) throws Exception {
        if (search == null) {
            throw new MimdbException("\u691c\u7d22\u6761\u4ef6\u306f\u7121\u52b9\u3067\u3059");
        }
        this.where.add(search);
    }

    public ObjectList<MimdbSearchElement> getWhere() {
        return this.where;
    }

    public void addSortColumn(String name, boolean desc) throws Exception {
        if (name == null || (name = name.trim().toLowerCase()).length() <= 0) {
            throw new MimdbException("\u6307\u5b9a\u30ab\u30e9\u30e0\u540d\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        this.sortList.add(name);
        this.descList.add(desc);
    }

    public ObjectList<String> getSortColumn() {
        return this.sortList;
    }

    public ObjectList<Boolean> getDesc() {
        return this.descList;
    }

    public String getSql() throws Exception {
        int i;
        int len;
        if (this.tableName == null) {
            throw new MimdbException("\u30c6\u30fc\u30d6\u30eb\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        StringBuilder buf = new StringBuilder(1024);
        buf.append("SELECT ");
        if (this.countFlag) {
            buf.append("COUNT(*) ");
        } else if (this.allColumn) {
            buf.append("* ");
        } else {
            len = this.columns.size();
            i = 0;
            while (i < len) {
                if (i != 0) {
                    buf.append(", ");
                }
                buf.append(this.columns.get(i)).append(" ");
                ++i;
            }
        }
        buf.append("FROM ").append(this.tableName).append(" ");
        if (this.where.size() > 0) {
            buf.append("WHERE ");
            len = this.where.size();
            i = 0;
            while (i < len) {
                buf.append(this.where.get(i)).append(" ");
                ++i;
            }
        }
        if (this.sortList.size() > 0) {
            buf.append("ORDER BY ");
            len = this.sortList.size();
            i = 0;
            while (i < len) {
                buf.append(this.sortList.get(i)).append(" ");
                if (this.descList.get(i).booleanValue()) {
                    buf.append("DESC ");
                } else {
                    buf.append("ASC ");
                }
                ++i;
            }
        }
        return buf.append(";").toString();
    }

    public MimdbPreparedStatement compile() throws Exception {
        MimdbPreparedStatement ret = new MimdbPreparedStatement();
        this.compile(ret);
        return ret;
    }

    public void compile(MimdbPreparedStatement out) throws Exception {
        out.clear();
        this.checkCompile();
        MimdbTable table = MimdbTableManager.getInstance().get(this.tableName);
        if (table == null) {
            throw new MimdbException("\u6307\u5b9a\u30c6\u30fc\u30d6\u30eb\u540d[" + this.tableName + "]\u306e\u30c6\u30fc\u30d6\u30eb\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (!table.isFix()) {
            throw new MimdbException("\u6307\u5b9a\u30c6\u30fc\u30d6\u30eb\u540d[" + this.tableName + "]\u306e\u30c6\u30fc\u30d6\u30eb\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306fFIX\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (!this.allColumn && !this.countFlag) {
            MimdbStatement.setViewColumns(out, table, this.columns);
        } else if (this.countFlag) {
            out.columns = null;
            out.countFlag = true;
        } else if (this.allColumn) {
            out.columns = null;
            out.countFlag = false;
        }
        if (this.sortList.size() > 0) {
            MimdbStatement.setSortColumns(out, table, this.sortList, this.descList);
        } else {
            out.sort = null;
        }
        if (this.where.size() > 0) {
            MimdbStatement.setWhere(out, table, this.where);
        } else {
            out.block = null;
            out.preparendParams = null;
        }
        out.name = table.getName();
        out.dbId = table.getDbId();
        out.src = this;
        this.dbId = out.dbId;
    }

    public MimdbResult executeQuery() throws Exception {
        if (this.compile == null) {
            MimdbPreparedStatement c = new MimdbPreparedStatement();
            this.compile(c);
            if (c.preparendParamsSize > 0) {
                throw new MimdbException("\u30d1\u30e9\u30e1\u30fc\u30bf\u304c\u5fc5\u8981\u306a\u6761\u4ef6\u306a\u306e\u3067\u3001\u3053\u306e\u51e6\u7406\u306f\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093");
            }
            this.compile = c;
        }
        this.compile.setOffset(this.offset);
        this.compile.setLimit(this.limit);
        this.offset = -1;
        this.limit = -1;
        return this.compile.executeQuery(false);
    }

    public void clearOffset() {
        this.offset = -1;
        this.limit = -1;
    }

    public MimdbStatement setOffset(int off) {
        this.offset = off;
        return this;
    }

    public MimdbStatement setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    private final void checkCompile() throws Exception {
        if (this.tableName == null || this.tableName.length() <= 0) {
            throw new MimdbException("\u30c6\u30fc\u30d6\u30eb\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (!this.allColumn && !this.countFlag && this.columns.size() <= 0) {
            throw new MimdbException("\u8868\u793a\u6761\u4ef6\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
    }

    private static final void setViewColumns(MimdbPreparedStatement out, MimdbTable table, ObjectList<String> columns) throws Exception {
        int len = columns.size();
        int[] columnArray = new int[len];
        int i = 0;
        while (i < len) {
            String s = columns.get(i);
            if (s == null || s.length() <= 0) {
                throw new MimdbException("\u30ab\u30e9\u30e0\u540d\u304cNULL\u3067\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            int p = table.getColumnNameByNo(s);
            if (p == -1) {
                throw new MimdbException("\u30c6\u30fc\u30d6\u30eb[" + table.getName() + "]\u306b\u3001\u30ab\u30e9\u30e0\u540d[" + s + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            columnArray[i] = p;
            ++i;
        }
        out.columns = new EqualsNoList(columnArray);
        out.countFlag = false;
    }

    private static final void setSortColumns(MimdbPreparedStatement out, MimdbTable table, ObjectList<String> sortList, ObjectList<Boolean> descList) throws Exception {
        int len = sortList.size();
        int[] sort = new int[len];
        boolean[] desc = new boolean[len];
        int i = 0;
        while (i < len) {
            String s = sortList.get(i);
            if (s == null || s.length() <= 0) {
                throw new MimdbException("\u30ab\u30e9\u30e0\u540d\u304cNULL\u3067\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            int p = table.getColumnNameByNo(s);
            if (p == -1) {
                throw new MimdbException("\u30c6\u30fc\u30d6\u30eb[" + table.getName() + "]\u306b\u3001\u30ab\u30e9\u30e0\u540d[" + s + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            sort[i] = p;
            desc[i] = descList.get(i);
            ++i;
        }
        out.sort = new SortElement();
        out.sort.sortNoList = sort;
        out.sort.desc = desc;
    }

    private static final void setWhere(MimdbPreparedStatement out, MimdbTable table, ObjectList<MimdbSearchElement> list) throws Exception {
        WhereBlock block;
        int len = list.size();
        int par = 0;
        int andor = -1;
        WhereBlock top = block = new WhereBlock();
        ObjectList<MimdbSearchElement> params = new ObjectList<MimdbSearchElement>();
        int i = 0;
        while (i < len) {
            MimdbSearchElement n = list.get(i);
            switch (n.getType()) {
                case 10: {
                    ++par;
                    block = block.add(new WhereBlock());
                    break;
                }
                case 11: {
                    block = block.getTop();
                    if (block == null) {
                        throw new MimdbException("\u62ec\u5f27\u306e\u69cb\u6210\u304c\u4e0d\u6b63\u3067\u3059");
                    }
                    --par;
                    break;
                }
                case 20: {
                    if (andor != -1) {
                        throw new MimdbException("and\u6761\u4ef6\u306f\u4e0d\u6b63\u3067\u3059");
                    }
                    andor = 0;
                    block.add(n);
                    break;
                }
                case 21: {
                    if (andor != -1) {
                        throw new MimdbException("or\u6761\u4ef6\u306f\u4e0d\u6b63\u3067\u3059");
                    }
                    andor = 1;
                    block.add(n);
                    break;
                }
                case 30: {
                    if (n.isPreparend()) {
                        params.add(n);
                        break;
                    }
                    if ("offset".equals(n.getColumn())) {
                        out.defOffset = MimdbUtils.convertInt(n.getValue());
                        break;
                    }
                    out.defLimit = MimdbUtils.convertInt(n.getValue());
                    break;
                }
                default: {
                    andor = -1;
                    int p = n.columnNameByNo(table);
                    if (!table.isIndex(p)) {
                        throw new MimdbException("\u30c6\u30fc\u30d6\u30eb[" + table.getName() + "]\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u3067\u306a\u3044\u30ab\u30e9\u30e0[" + n.getColumn() + "]\u306f\u3001where\u6761\u4ef6\u306b\u5b9a\u7fa9\u3067\u304d\u307e\u305b\u3093");
                    }
                    if (n.isPreparend()) {
                        params.add(n);
                    }
                    block.add(n);
                }
            }
            ++i;
        }
        if (par != 0) {
            throw new MimdbException("\u62ec\u5f27\u306e\u6574\u5408\u6027\u304c\u53d6\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (andor != -1) {
            throw new MimdbException("And,Or\u306e\u6761\u4ef6\u304c\u4e0d\u6b63\u3067\u3059");
        }
        out.block = top;
        if (params.size() > 0) {
            len = params.size();
            MimdbSearchElement[] pms = new MimdbSearchElement[len];
            int i2 = 0;
            while (i2 < len) {
                pms[i2] = (MimdbSearchElement)params.get(i2);
                ++i2;
            }
            out.preparendParams = pms;
            out.preparendParamsSize = len;
        } else {
            out.preparendParams = null;
            out.preparendParamsSize = 0;
        }
    }
}

