/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.impl;

import org.maachang.mimdb.core.ResultArray;

public abstract class Flags {
    protected static final int BLOCK_SIZE = 1024;
    protected static final int BLOCK_INNER_SIZE = 32;
    protected static final int MIN_DEF = Integer.MAX_VALUE;
    protected int max;
    protected int[][] flags;
    protected int minPos = Integer.MAX_VALUE;
    protected int maxPos = -1;

    public void destroy() {
        this.flags = null;
        this.max = 0;
        this.clearMinMax();
    }

    public final void clear() {
        this.flags = new int[this.flags.length][];
        this.clearMinMax();
    }

    protected final void clearMinMax() {
        this.minPos = Integer.MAX_VALUE;
        this.maxPos = -1;
    }

    protected final void minMax(int n) {
        if (n < this.minPos) {
            this.minPos = n;
        }
        if (n > this.maxPos) {
            this.maxPos = n;
        }
    }

    public abstract boolean isAnd();

    public abstract void add(int var1);

    public abstract void addArray(int[] var1);

    public abstract void set(int var1, int var2);

    public abstract void setArray(int[] var1, int var2);

    public abstract void all();

    public abstract void marge(Flags var1);

    public final int get(int no) {
        if (this.minPos == Integer.MAX_VALUE) {
            return 0;
        }
        int[] ff = this.flags[no >> 10];
        if (ff != null) {
            int n = no & 0x3FF;
            return (ff[n >> 5] & 1 << (n & 0x1F)) >> (n & 0x1F);
        }
        return 0;
    }

    public final int max() {
        return this.max;
    }

    public final int size() {
        if (this.minPos == Integer.MAX_VALUE) {
            return 0;
        }
        int ret = 0;
        int[][] f = this.flags;
        int len = this.maxPos + 1;
        if (len << 10 >= this.max) {
            int mx = this.max - 32;
            int i = this.minPos;
            while (i < len) {
                int[] ff = f[i];
                if (ff != null) {
                    int j = 0;
                    while (j < 32) {
                        int n = ff[j];
                        if (n != 0) {
                            if ((i << 10 | j << 5) >= mx) {
                                int c = i << 10 | j << 5;
                                int k = 0;
                                while (k < 32) {
                                    if ((c | k) >= this.max) {
                                        return ret;
                                    }
                                    if ((n & 1 << k) != 0) {
                                        ++ret;
                                    }
                                    ++k;
                                }
                            } else {
                                n = (n & 0x55555555) + (n >> 1 & 0x55555555);
                                n = (n & 0x33333333) + (n >> 2 & 0x33333333);
                                n = (n & 0xF0F0F0F) + (n >> 4 & 0xF0F0F0F);
                                n = (n & 0xFF00FF) + (n >> 8 & 0xFF00FF);
                                ret += (n & 0xFFFF) + (n >> 16 & 0xFFFF);
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        } else {
            int i = this.minPos;
            while (i < len) {
                int[] ff = f[i];
                if (ff != null) {
                    int j = 0;
                    while (j < 32) {
                        int n = ff[j];
                        if (n != 0) {
                            n = (n & 0x55555555) + (n >> 1 & 0x55555555);
                            n = (n & 0x33333333) + (n >> 2 & 0x33333333);
                            n = (n & 0xF0F0F0F) + (n >> 4 & 0xF0F0F0F);
                            n = (n & 0xFF00FF) + (n >> 8 & 0xFF00FF);
                            ret += (n & 0xFFFF) + (n >> 16 & 0xFFFF);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return ret;
    }

    public final int getResultArray(ResultArray[] out) {
        if (this.minPos == Integer.MAX_VALUE || out.length == 0) {
            return 0;
        }
        int cnt = 0;
        int[][] f = this.flags;
        int len = this.maxPos + 1;
        int oLen = out.length;
        if (len << 10 >= this.max) {
            int mx = this.max - 32;
            int i = this.minPos;
            while (i < len) {
                int[] ff = f[i];
                if (ff != null) {
                    int j = 0;
                    while (j < 32) {
                        int n = ff[j];
                        if (n != 0) {
                            int k;
                            int c = i << 10 | j << 5;
                            if (c >= mx) {
                                k = 0;
                                while (k < 32) {
                                    if ((c | k) >= this.max) {
                                        return cnt;
                                    }
                                    if ((n & 1 << k) != 0) {
                                        out[cnt++].no = c | k;
                                        if (cnt == oLen) {
                                            return cnt;
                                        }
                                    }
                                    ++k;
                                }
                            } else if (n == -1) {
                                if (cnt + 32 > oLen) {
                                    k = 0;
                                    while (k < 32) {
                                        out[cnt++].no = c | k;
                                        if (cnt == oLen) {
                                            return cnt;
                                        }
                                        ++k;
                                    }
                                } else {
                                    k = 0;
                                    while (k < 32) {
                                        out[cnt++].no = c | k;
                                        ++k;
                                    }
                                }
                            } else if (cnt + 32 > oLen) {
                                k = 0;
                                while (k < 32) {
                                    if ((n & 1 << k) != 0) {
                                        out[cnt++].no = c | k;
                                        if (cnt == oLen) {
                                            return cnt;
                                        }
                                    }
                                    ++k;
                                }
                            } else {
                                k = 0;
                                while (k < 32) {
                                    if ((n & 1 << k) != 0) {
                                        out[cnt++].no = c | k;
                                    }
                                    ++k;
                                }
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        } else {
            int i = this.minPos;
            while (i < len) {
                int[] ff = f[i];
                if (ff != null) {
                    int j = 0;
                    while (j < 32) {
                        int n = ff[j];
                        if (n != 0) {
                            int k;
                            int c = i << 10 | j << 5;
                            if (n == -1) {
                                if (cnt + 32 > oLen) {
                                    k = 0;
                                    while (k < 32) {
                                        out[cnt++].no = c | k;
                                        if (cnt == oLen) {
                                            return cnt;
                                        }
                                        ++k;
                                    }
                                } else {
                                    k = 0;
                                    while (k < 32) {
                                        out[cnt++].no = c | k;
                                        ++k;
                                    }
                                }
                            } else if (cnt + 32 > oLen) {
                                k = 0;
                                while (k < 32) {
                                    if ((n & 1 << k) != 0) {
                                        out[cnt++].no = c | k;
                                        if (cnt == oLen) {
                                            return cnt;
                                        }
                                    }
                                    ++k;
                                }
                            } else {
                                k = 0;
                                while (k < 32) {
                                    if ((n & 1 << k) != 0) {
                                        out[cnt++].no = c | k;
                                    }
                                    ++k;
                                }
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return cnt;
    }

    public final int getResultArray(ResultArray[] out, int off) {
        if (this.minPos == Integer.MAX_VALUE || out.length == 0) {
            return 0;
        }
        int cnt = 0;
        int[][] f = this.flags;
        int len = this.maxPos + 1;
        int oLen = out.length;
        if (len << 10 >= this.max) {
            int cursor = 0;
            int mx = this.max - 32;
            int i = this.minPos;
            while (i < len) {
                int[] ff = f[i];
                if (ff != null) {
                    int j = 0;
                    while (j < 32) {
                        int n = ff[j];
                        if (n != 0) {
                            int k;
                            int c = i << 10 | j << 5;
                            if (c >= mx) {
                                k = 0;
                                while (k < 32) {
                                    if ((c | k) >= this.max) {
                                        return cnt;
                                    }
                                    if ((n & 1 << k) != 0 && cursor++ >= off) {
                                        out[cnt++].no = c | k;
                                        if (cnt == oLen) {
                                            return cnt;
                                        }
                                    }
                                    ++k;
                                }
                            } else if (n == -1) {
                                if (cursor >= off) {
                                    k = 0;
                                    while (k < 32) {
                                        out[cnt++].no = c | k;
                                        if (cnt == oLen) {
                                            return cnt;
                                        }
                                        ++k;
                                    }
                                } else if (cursor + 32 >= off) {
                                    k = 0;
                                    while (k < 32) {
                                        if (cursor++ >= off) {
                                            out[cnt++].no = c | k;
                                            if (cnt == oLen) {
                                                return cnt;
                                            }
                                        }
                                        ++k;
                                    }
                                } else {
                                    cursor += 32;
                                }
                            } else if (cursor >= off) {
                                k = 0;
                                while (k < 32) {
                                    if ((n & 1 << k) != 0) {
                                        out[cnt++].no = c | k;
                                        if (cnt == oLen) {
                                            return cnt;
                                        }
                                    }
                                    ++k;
                                }
                            } else {
                                k = 0;
                                while (k < 32) {
                                    if ((n & 1 << k) != 0 && cursor++ >= off) {
                                        out[cnt++].no = c | k;
                                        if (cnt == oLen) {
                                            return cnt;
                                        }
                                    }
                                    ++k;
                                }
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        } else {
            int cursor = 0;
            int i = this.minPos;
            while (i < len) {
                int[] ff = f[i];
                if (ff != null) {
                    int j = 0;
                    while (j < 32) {
                        int n = ff[j];
                        if (n != 0) {
                            int k;
                            int c = i << 10 | j << 5;
                            if (n == -1) {
                                if (cursor >= off) {
                                    k = 0;
                                    while (k < 32) {
                                        out[cnt++].no = c | k;
                                        if (cnt == oLen) {
                                            return cnt;
                                        }
                                        ++k;
                                    }
                                } else if (cursor + 32 >= off) {
                                    k = 0;
                                    while (k < 32) {
                                        if (cursor++ >= off) {
                                            out[cnt++].no = c | k;
                                            if (cnt == oLen) {
                                                return cnt;
                                            }
                                        }
                                        ++k;
                                    }
                                } else {
                                    cursor += 32;
                                }
                            } else if (cursor >= off) {
                                k = 0;
                                while (k < 32) {
                                    if ((n & 1 << k) != 0) {
                                        out[cnt++].no = c | k;
                                        if (cnt == oLen) {
                                            return cnt;
                                        }
                                    }
                                    ++k;
                                }
                            } else {
                                k = 0;
                                while (k < 32) {
                                    if ((n & 1 << k) != 0 && cursor++ >= off) {
                                        out[cnt++].no = c | k;
                                        if (cnt == oLen) {
                                            return cnt;
                                        }
                                    }
                                    ++k;
                                }
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return cnt;
    }
}

