/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core;

import java.lang.ref.SoftReference;
import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.BaseTable;
import org.maachang.mimdb.core.EmbeddedPreparedStatement;
import org.maachang.mimdb.core.EmbeddedStatement;
import org.maachang.mimdb.core.MimdbConnection;
import org.maachang.mimdb.core.MimdbPreparedStatement;
import org.maachang.mimdb.core.MimdbQuery;
import org.maachang.mimdb.core.MimdbStatement;
import org.maachang.mimdb.core.MimdbTableManager;
import org.maachang.mimdb.core.QueryCompileInfo;
import org.maachang.mimdb.core.util.ObjectKeyValue;

final class EmbeddedConnection
extends MimdbConnection {
    protected ObjectKeyValue<String, SoftReference<QueryCompileInfo>> preparedList = new ObjectKeyValue();
    protected EmbeddedStatement statement = new EmbeddedStatement(this);
    private boolean closeFlag = false;

    protected EmbeddedConnection() {
    }

    protected final void finalize() throws Exception {
        this.close();
    }

    public final void close() {
        this.closeFlag = true;
        if (this.preparedList != null) {
            this.preparedList.clear();
            this.preparedList = null;
        }
        this.statement = null;
    }

    public final boolean isClose() {
        return this.closeFlag;
    }

    protected final void check() {
        if (this.closeFlag) {
            throw new MimdbException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
    }

    public final BaseTable getTable(String name) throws Exception {
        BaseTable ret = MimdbTableManager.getInstance().get(name);
        if (ret == null) {
            throw new MimdbException("\u30c6\u30fc\u30d6\u30eb\u540d[" + name + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        return ret;
    }

    public final MimdbStatement getStatement() throws Exception {
        this.check();
        this.statement.clearOffLimit();
        return this.statement;
    }

    public final MimdbPreparedStatement getPreparedStatement(String sql) throws Exception {
        QueryCompileInfo info;
        this.check();
        SoftReference<QueryCompileInfo> o = this.preparedList.get(sql);
        if (o == null || (info = o.get()) == null) {
            this.preparedList.remove(sql);
            info = MimdbQuery.createCompile(sql);
            this.preparedList.put(sql, new SoftReference<QueryCompileInfo>(info));
        }
        return new EmbeddedPreparedStatement(this, info);
    }
}

