/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core;

import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.EmbeddedConnection;
import org.maachang.mimdb.core.MimdbPreparedStatement;
import org.maachang.mimdb.core.MimdbQueryPrepared;
import org.maachang.mimdb.core.MimdbResult;
import org.maachang.mimdb.core.QueryCompileInfo;

final class EmbeddedPreparedStatement
implements MimdbPreparedStatement {
    private EmbeddedConnection connection = null;
    private final MimdbQueryPrepared prepared = new MimdbQueryPrepared();

    private EmbeddedPreparedStatement() {
    }

    protected EmbeddedPreparedStatement(EmbeddedConnection conn, QueryCompileInfo p) {
        this.connection = conn;
        this.prepared.create(p);
    }

    public void close() {
        this.connection = null;
        this.prepared.clear();
    }

    public boolean isClose() {
        return this.connection == null || this.connection.isClose();
    }

    protected void check() {
        if (this.isClose()) {
            throw new MimdbException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
    }

    protected QueryCompileInfo getInfo() {
        this.check();
        return this.prepared.getInfo();
    }

    public long getDbId() {
        this.check();
        return this.prepared.getDbId();
    }

    public String getName() {
        this.check();
        return this.prepared.getName();
    }

    public int length() {
        this.check();
        return this.prepared.paramsLength();
    }

    public MimdbPreparedStatement clearParams() {
        this.check();
        this.prepared.clearParams();
        return this;
    }

    public MimdbPreparedStatement setParams(int index, Object value) {
        this.check();
        this.prepared.setParams(index, value);
        return this;
    }

    public String getColumnName(int index) {
        this.check();
        return this.prepared.paramNoByColumnName(index);
    }

    public int getType(int index) {
        this.check();
        return this.prepared.paramNoByColumnType(index);
    }

    public MimdbPreparedStatement setOffset(int off) {
        this.check();
        this.prepared.setOffset(off);
        return this;
    }

    public MimdbPreparedStatement setLimit(int limit) {
        this.check();
        this.prepared.setLimit(limit);
        return this;
    }

    protected void clearOffLimit() {
        this.prepared.setOffset(-1);
        this.prepared.setLimit(-1);
    }

    public MimdbPreparedStatement setFetchSize(int size) {
        this.check();
        return this;
    }

    public int getFetchSize() {
        this.check();
        return -1;
    }

    public MimdbResult executeQuery() throws Exception {
        this.check();
        return this.prepared.executeQuery();
    }
}

