/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core;

import java.lang.ref.SoftReference;
import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.BaseTable;
import org.maachang.mimdb.core.MimdbConnection;
import org.maachang.mimdb.core.MimdbPreparedStatement;
import org.maachang.mimdb.core.MimdbStatement;
import org.maachang.mimdb.core.QueryCompile;
import org.maachang.mimdb.core.QueryCompileInfo;
import org.maachang.mimdb.core.QueryInfo;
import org.maachang.mimdb.core.RemotePreparedStatement;
import org.maachang.mimdb.core.RemoteResultImpl;
import org.maachang.mimdb.core.RemoteStatement;
import org.maachang.mimdb.core.RemoteTable;
import org.maachang.mimdb.core.RemoteTableManager;
import org.maachang.mimdb.core.impl.SqlAnalyzer;
import org.maachang.mimdb.core.util.ObjectKeyValue;
import org.maachang.mimdb.server.MimdbClient;

final class RemoteConnection
extends MimdbConnection {
    protected static final int DEF_FETCH_SIZE = 10;
    protected MimdbClient client = null;
    protected ObjectKeyValue<String, SoftReference<QueryCompileInfo>> preparedList = new ObjectKeyValue();
    protected RemoteStatement statement = null;
    protected boolean closeFlag = false;
    protected final RemoteResultImpl result = new RemoteResultImpl();

    protected RemoteConnection(String addr, int port, int timeout) throws Exception {
        this.client = new MimdbClient(addr, port, timeout);
        this.statement = new RemoteStatement(this);
    }

    protected void finalize() throws Exception {
        this.close();
    }

    public void close() {
        this.closeFlag = true;
        if (this.client != null) {
            try {
                this.client.sendClose(1, -1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.client.close();
            this.client = null;
        }
        if (this.preparedList != null) {
            this.preparedList.clear();
            this.preparedList = null;
        }
        this.statement = null;
    }

    public boolean isClose() {
        return this.closeFlag;
    }

    protected void check() {
        if (this.closeFlag) {
            throw new MimdbException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
    }

    public final BaseTable getTable(String name) throws Exception {
        this.check();
        try {
            RemoteTable ret = this.client.getTable(name);
            if (ret == null) {
                throw new MimdbException("\u30c6\u30fc\u30d6\u30eb\u540d[" + name + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            return ret;
        }
        catch (RuntimeException r) {
            throw r;
        }
        catch (Exception e) {
            throw new MimdbException(e);
        }
    }

    public MimdbStatement getStatement() throws Exception {
        this.check();
        this.statement.clearOffLimit();
        return this.statement;
    }

    public MimdbPreparedStatement getPreparedStatement(String sql) throws Exception {
        this.check();
        return new RemotePreparedStatement(this, sql);
    }

    public void setTimeout(int timeout) {
        this.check();
        this.client.setTimeout(timeout);
    }

    public int getTimeout() {
        this.check();
        return this.client.getTimeout();
    }

    protected static final QueryCompileInfo compile(RemoteConnection conn, String sql) throws Exception {
        QueryInfo info = new QueryInfo();
        SqlAnalyzer.analysis(info, sql);
        if (conn.client.getTable(info.getName()) == null) {
            throw new MimdbException("\u30c6\u30fc\u30d6\u30eb\u540d[" + info.getName() + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        QueryCompileInfo ret = new QueryCompileInfo();
        QueryCompile.compile(ret, info, RemoteTableManager.getInstance());
        return ret;
    }

    protected static final void checkTable(RemoteConnection conn, String name) throws Exception {
        if (conn.client.getTable(name) == null) {
            throw new MimdbException("\u30c6\u30fc\u30d6\u30eb\u540d[" + name + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
    }
}

