/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core;

import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.BaseTable;
import org.maachang.mimdb.core.MimdbMetaData;
import org.maachang.mimdb.core.MimdbResult;
import org.maachang.mimdb.core.MimdbResultRow;
import org.maachang.mimdb.core.QueryCompileInfo;
import org.maachang.mimdb.core.RemoteConnection;
import org.maachang.mimdb.core.RemoteMetaDataImpl;
import org.maachang.mimdb.core.RemoteResultRow;

final class RemoteResultImpl
implements MimdbResult {
    protected RemoteConnection connection = null;
    protected QueryCompileInfo compile = null;
    protected int position = -1;
    protected int fetchSize = -1;
    protected int resultId = -1;
    protected int length = -1;
    protected int maxLength = -1;
    protected int nowRow = -1;
    protected Object[][] values = null;
    protected int valueLength = 0;
    protected final RemoteResultRow row = new RemoteResultRow();
    protected RemoteMetaDataImpl meta = null;
    protected final int[] out = new int[1];

    protected RemoteResultImpl() {
    }

    public RemoteResultImpl(RemoteConnection conn, QueryCompileInfo cmp, RemoteMetaDataImpl mt, int fetch, int resId, int len, int max) {
        this.create(conn, cmp, mt, fetch, resId, len, max);
    }

    protected void finalize() throws Exception {
        this.clear();
    }

    public void create(RemoteConnection conn, QueryCompileInfo cmp, RemoteMetaDataImpl mt, int fetch, int resId, int len, int max) {
        this.resultId = resId;
        this.connection = conn;
        this.compile = cmp;
        this.position = -1;
        this.length = len;
        this.maxLength = max;
        this.fetchSize = fetch;
        this.values = null;
        this.nowRow = -1;
        if (mt == null) {
            mt = new RemoteMetaDataImpl(conn, cmp, true);
        }
        this.meta = mt;
        this.row.create(this);
    }

    public void clear() {
        if (this.connection != null) {
            try {
                this.connection.client.sendClose(2, this.resultId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.connection = null;
        }
        this.resultId = -1;
        this.compile = null;
        this.values = null;
        if (this.meta != null && this.meta.isClearFlag) {
            this.meta.clear();
        }
        this.meta = null;
        this.row.clear();
    }

    protected final boolean isClearData() {
        return this.connection == null;
    }

    protected final void check() {
        if (this.connection == null || this.connection.isClose()) {
            throw new MimdbException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u307e\u3059");
        }
    }

    public long getDbId() {
        this.check();
        return this.compile.getDbId();
    }

    public MimdbMetaData getMetaData() {
        this.check();
        return this.meta;
    }

    public BaseTable getTable() {
        this.check();
        try {
            return this.connection.client.getTable(this.compile.name);
        }
        catch (RuntimeException r) {
            throw r;
        }
        catch (Exception e) {
            throw new MimdbException(e);
        }
    }

    public int length() {
        this.check();
        return this.length;
    }

    public int maxLength() {
        this.check();
        return this.maxLength;
    }

    public boolean first() throws Exception {
        this.nowRow = -1;
        return this.length > 0;
    }

    public boolean last() throws Exception {
        this.nowRow = this.length;
        return this.length > 0;
    }

    public boolean next() {
        ++this.nowRow;
        return this.nowRow >= 0 && this.length > this.nowRow;
    }

    public boolean absolute(int no) throws Exception {
        this.nowRow = no;
        return this.nowRow >= 0 && this.length > this.nowRow;
    }

    public int getRow() {
        this.check();
        return this.nowRow;
    }

    public MimdbResult setFetchSize(int size) {
        this.check();
        if (size <= 0) {
            size = 1;
        }
        this.fetchSize = size;
        return this;
    }

    public int getFetchSize() {
        this.check();
        return this.fetchSize;
    }

    public MimdbResultRow get() throws Exception {
        if (this.readBuffer()) {
            return this.row;
        }
        throw new MimdbException("\u53d6\u5f97\u7bc4\u56f2\u3092\u8d85\u3048\u3066\u3044\u307e\u3059");
    }

    public MimdbResultRow get(int no) throws Exception {
        this.nowRow = no;
        return this.get();
    }

    protected final boolean readBuffer() throws Exception {
        if (this.nowRow < 0) {
            return false;
        }
        int end = this.position + this.valueLength;
        if (this.values == null || this.nowRow < this.position || this.nowRow >= end) {
            Object[][] o = this.connection.client.resultSet(this.out, this.resultId, this.nowRow, this.fetchSize);
            if (o == null) {
                return false;
            }
            this.valueLength = this.out[0];
            this.position = this.nowRow;
            this.values = o;
        }
        return true;
    }
}

