/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core;

import org.maachang.mimdb.core.BaseTable;
import org.maachang.mimdb.core.util.NNObjectKeyValue;
import org.maachang.mimdb.core.util.NumberKeySet;
import org.maachang.mimdb.core.util.ObjectBinary;

public class RemoteTable
implements BaseTable {
    protected long dbId = -1L;
    protected String name = null;
    protected String[] columns = null;
    protected int[] types = null;
    protected int columnLength = 0;
    protected NNObjectKeyValue<String, Integer> columnsMap = null;
    protected NumberKeySet indexs = null;
    protected long lastUpdateTime = System.currentTimeMillis();

    public RemoteTable() {
    }

    public RemoteTable(long dbId, String name, String[] columns, int[] types, int[] indexs) {
        this.create(dbId, name, columns, types, indexs);
    }

    public void create(long dbId, String name, String[] columns, int[] types, int[] indexs) {
        NNObjectKeyValue<String, Integer> map = new NNObjectKeyValue<String, Integer>();
        NumberKeySet idx = new NumberKeySet();
        int len = columns.length;
        int i = 0;
        while (i < len) {
            map.put(columns[i], i);
            ++i;
        }
        len = indexs.length;
        i = 0;
        while (i < len) {
            idx.add(indexs[i]);
            ++i;
        }
        this.dbId = dbId;
        this.name = name;
        this.columns = columns;
        this.types = types;
        this.columnLength = columns.length;
        this.columnsMap = map;
        this.indexs = idx;
    }

    public void clear() {
        this.dbId = -1L;
        this.name = null;
        this.columns = null;
        this.types = null;
        this.columnLength = 0;
        this.columnsMap = null;
        this.indexs = null;
    }

    public static final int toObject(RemoteTable out, byte[] b, int off, int len) throws Exception {
        out.clear();
        int[] p = new int[]{off};
        String name = (String)ObjectBinary.decodeBinary(p, b, len);
        long dbId = (Long)ObjectBinary.decodeBinary(p, b, len);
        String[] columns = (String[])ObjectBinary.decodeBinary(p, b, len);
        int[] types = (int[])ObjectBinary.decodeBinary(p, b, len);
        int[] indexs = (int[])ObjectBinary.decodeBinary(p, b, len);
        out.create(dbId, name, columns, types, indexs);
        out.update();
        return p[0];
    }

    public long getDbId() {
        return this.dbId;
    }

    public String getName() {
        return this.name;
    }

    public int getColumnSize() {
        return this.columnLength;
    }

    public String getColumnName(int no) {
        if (no < 0 || no >= this.columnLength) {
            return null;
        }
        return this.columns[no];
    }

    public int getColumnNameByNo(String name) {
        if (this.columnsMap.containsKey(name)) {
            return this.columnsMap.get(name);
        }
        return -1;
    }

    public int getColumnType(int no) {
        if (no < 0 || no >= this.columnLength) {
            return -1;
        }
        return this.types[no];
    }

    public int getColumnType(String name) {
        if (this.columnsMap.containsKey(name)) {
            return this.types[this.columnsMap.get(name)];
        }
        return -1;
    }

    public boolean isIndex(int no) {
        return this.indexs.contains(no);
    }

    public boolean isIndex(String name) {
        if (this.columnsMap.containsKey(name)) {
            return this.indexs.contains(this.columnsMap.get(name));
        }
        return false;
    }

    public String[] getColumns() {
        return this.columns;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void update() {
        this.lastUpdateTime = System.currentTimeMillis();
    }
}

