/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core;

import java.util.Arrays;
import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.MimdbMiddleSearch;
import org.maachang.mimdb.core.MimdbRow;
import org.maachang.mimdb.core.ResultArray;
import org.maachang.mimdb.core.SortElement;
import org.maachang.mimdb.core.util.ObjectLinkedList;

class ResultPointer {
    private static final int MAX_BACKET_SORT_LENGTH = 65535;
    protected MimdbRow[] src;
    protected SortElement sort;
    protected MimdbMiddleSearch msearch;
    protected int cursor = -1;
    protected int offset = -1;
    protected int limit = -1;
    protected boolean zeroFlag = false;
    protected PointerElement[] result;

    public void create(MimdbRow[] src, SortElement sort, int off, int limit) {
        this.create(null, src, sort, off, limit);
    }

    public void create(MimdbMiddleSearch msearch, MimdbRow[] src, SortElement sort, int off, int limit) {
        if (sort == null || sort.sortNoList == null) {
            sort = null;
        }
        this.msearch = msearch;
        this.src = src;
        this.sort = sort;
        this.offset = off;
        this.limit = limit;
        this.result = null;
        this.cursor = -1;
    }

    public void createZero(MimdbRow[] src, SortElement sort, int off, int limit) {
        this.create(null, src, sort, off, limit);
        this.zeroFlag = true;
    }

    public void clear() {
        this.msearch = null;
        this.src = null;
        this.sort = null;
        this.offset = -1;
        this.limit = -1;
        this.result = null;
        this.cursor = -1;
        this.zeroFlag = false;
    }

    public void execute() throws Exception {
        this.cursor = -1;
        if (this.zeroFlag) {
            this.result = null;
            return;
        }
        this.result = this.msearch != null ? this.searchToResult() : this.allToResult();
        if (this.result != null) {
            this.cursor = 0;
        }
    }

    public int resultLength() {
        return this.result == null ? 0 : this.result.length;
    }

    public int get(int no) {
        if (this.result == null || no < 0 || this.result.length <= no) {
            throw new MimdbException("\u7bc4\u56f2\u3092\u8d85\u3048\u3066\u3044\u307e\u3059:" + no);
        }
        return this.result[no].no;
    }

    private final PointerElement[] createElement(int len) {
        PointerElement[] ret = new PointerElement[len];
        int i = 0;
        while (i < len) {
            ret[i] = new PointerElement();
            ++i;
        }
        return ret;
    }

    private final PointerElement[] searchToResult() throws Exception {
        int length = this.msearch.size();
        if (length == 0) {
            return null;
        }
        if (this.offset >= 0 && this.limit > 0) {
            int off = this.offset;
            int lmt = this.limit;
            if ((off & 0x3FFFFFFF) + lmt >= length) {
                lmt = length;
            }
            if (lmt <= 0) {
                return null;
            }
            if (this.sort == null || this.sort.sortNoList == null) {
                ResultArray[] ret = this.createElement(lmt);
                this.msearch.getResultArray(ret, off);
                return ret;
            }
            ResultArray[] list = this.createElement(length);
            this.msearch.getResultArray(list);
            this.resultSort((PointerElement[])list);
            int cnt = 0;
            int len = off + lmt;
            PointerElement[] ret = new PointerElement[lmt];
            int i = off;
            while (i < len) {
                ret[cnt++] = list[i];
                ++i;
            }
            return ret;
        }
        ResultArray[] ret = this.createElement(length);
        this.msearch.getResultArray(ret);
        if (this.sort != null && this.sort.sortNoList != null) {
            this.resultSort((PointerElement[])ret);
        }
        return ret;
    }

    private final PointerElement[] allToResult() throws Exception {
        int len = this.src.length;
        if (this.offset >= 0 && this.limit > 0) {
            int off = this.offset;
            int lmt = this.limit;
            if ((off & 0x3FFFFFFF) + lmt >= len) {
                lmt = len;
            }
            if (lmt <= 0) {
                return null;
            }
            if (this.sort == null || this.sort.sortNoList == null) {
                int cnt = 0;
                PointerElement[] ret = new PointerElement[lmt];
                int olLen = off + lmt;
                int i = off;
                while (i < olLen) {
                    ret[cnt++] = new PointerElement(i);
                    ++i;
                }
                return ret;
            }
            PointerElement[] list = new PointerElement[len];
            int i = 0;
            while (i < len) {
                list[i] = new PointerElement(i);
                ++i;
            }
            this.resultSort(list);
            int cnt = 0;
            int olLen = off + lmt;
            PointerElement[] ret = new PointerElement[lmt];
            int i2 = off;
            while (i2 < olLen) {
                ret[cnt++] = list[i2];
                ++i2;
            }
            return ret;
        }
        PointerElement[] ret = new PointerElement[len];
        int i = 0;
        while (i < len) {
            ret[i] = new PointerElement(i);
            ++i;
        }
        if (this.sort != null && this.sort.sortNoList != null) {
            this.resultSort(ret);
        }
        return ret;
    }

    private final void resultSort(PointerElement[] list) {
        if (this.sort.indexList.length == 1 && this.sort.indexList[0] != null && list.length <= 65535 && this.sort.indexLength <= 65535) {
            this.backetSort(list);
        } else {
            Arrays.sort(list);
        }
    }

    private final void backetSort(PointerElement[] list) {
        ObjectLinkedList o;
        int[] idx = this.sort.indexList[0];
        ObjectLinkedList[] array = new ObjectLinkedList[this.sort.indexLength + 1];
        int len = list.length;
        int i = 0;
        while (i < len) {
            PointerElement em = list[i];
            int n = idx[em.no] + 1;
            o = array[n];
            if (o == null) {
                array[n] = o = new ObjectLinkedList();
            }
            o.offer(em);
            ++i;
        }
        if (this.sort.desc[0]) {
            int cnt = 0;
            i = array.length - 1;
            while (i >= 0) {
                o = array[i];
                if (o != null) {
                    cnt = o.poll(list, cnt);
                }
                --i;
            }
        } else {
            int cnt = 0;
            len = array.length;
            i = 0;
            while (i < len) {
                o = array[i];
                if (o != null) {
                    cnt = o.poll(list, cnt);
                }
                ++i;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class PointerElement
    extends ResultArray
    implements Comparable<PointerElement> {
        public PointerElement() {
        }

        public PointerElement(int no) {
            this.no = no;
        }

        @Override
        public final int compareTo(PointerElement n) {
            int[][] idxList = ResultPointer.this.sort.indexList;
            boolean[] desc = ResultPointer.this.sort.desc;
            int i = idxList.length - 1;
            while (i >= 0) {
                Object cc;
                Object c;
                int p;
                int[] idx;
                if (desc[i]) {
                    idx = idxList[i];
                    if (idx != null) {
                        p = idx[n.no] - idx[this.no];
                        if (p != 0) {
                            return p;
                        }
                    } else {
                        c = ResultPointer.this.src[this.no].getValue(ResultPointer.this.sort.sortNoList[i]);
                        if (c != (cc = ResultPointer.this.src[n.no].getValue(ResultPointer.this.sort.sortNoList[i]))) {
                            if (c == null || cc == null) {
                                if (c == null) {
                                    return 1;
                                }
                                return -1;
                            }
                            p = ((Comparable)cc).compareTo(c);
                            if (p != 0) {
                                return p;
                            }
                        }
                    }
                } else {
                    idx = idxList[i];
                    if (idx != null) {
                        p = idx[this.no] - idx[n.no];
                        if (p != 0) {
                            return p;
                        }
                    } else {
                        c = ResultPointer.this.src[this.no].getValue(ResultPointer.this.sort.sortNoList[i]);
                        if (c != (cc = ResultPointer.this.src[n.no].getValue(ResultPointer.this.sort.sortNoList[i]))) {
                            if (c == null || cc == null) {
                                if (c == null) {
                                    return -1;
                                }
                                return 1;
                            }
                            p = ((Comparable)c).compareTo(cc);
                            if (p != 0) {
                                return p;
                            }
                        }
                    }
                }
                --i;
            }
            return 0;
        }
    }
}

