/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.maachang.mimdb.core.BaseTable;
import org.maachang.mimdb.core.MetaDataImpl;
import org.maachang.mimdb.core.MimdbResultRow;
import org.maachang.mimdb.core.MimdbRow;
import org.maachang.mimdb.core.ResultImpl;
import org.maachang.mimdb.core.impl.EqualsNoList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResultRowImpl
extends MimdbResultRow {
    ResultImpl parent;

    public ResultRowImpl() {
    }

    public ResultRowImpl(ResultImpl parent) {
        this.create(parent);
    }

    public void create(ResultImpl parent) {
        this.parent = parent;
    }

    @Override
    public void clear() {
        this.parent = null;
    }

    @Override
    public long getDbId() {
        return this.parent.dbId;
    }

    @Override
    public String getName() {
        return this.parent.table.name;
    }

    public BaseTable getTable() {
        return this.parent.table;
    }

    @Override
    public int getLineNo() {
        return this.parent.pointer.cursor;
    }

    private final EqualsNoList viewColumnList() {
        return ((MetaDataImpl)this.parent.meta).viewColumnList;
    }

    private final MimdbRow src() {
        return this.parent.pointer.src[this.parent.pointer.get(this.parent.pointer.cursor)];
    }

    @Override
    public Object getValue(int n) {
        EqualsNoList viewColumnList = this.viewColumnList();
        if (viewColumnList != null) {
            n = viewColumnList.src(n);
        }
        return this.src().getValue(n);
    }

    private final int getColumnNameByNo(String name) {
        EqualsNoList viewColumnList = this.viewColumnList();
        if (viewColumnList != null) {
            int ret = this.parent.table.getColumnNameByNo(name);
            if (!viewColumnList.equals(ret)) {
                return -1;
            }
            return ret;
        }
        return this.parent.table.getColumnNameByNo(name);
    }

    @Override
    public void putAll(Map toMerge) {
    }

    @Override
    public boolean containsValue(Object value) {
        EqualsNoList viewColumnList = this.viewColumnList();
        if (viewColumnList != null) {
            int[] vc = viewColumnList.arrays();
            int len = viewColumnList.size();
            Object[] values = this.src().getValues();
            if (value == null) {
                int i = 0;
                while (i < len) {
                    if (values[vc[i]] == null) {
                        return true;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < len) {
                    if (value.equals(values[vc[i]])) {
                        return true;
                    }
                    ++i;
                }
            }
        } else {
            int len = this.parent.table.columnLength;
            Object[] values = this.src().getValues();
            if (value == null) {
                int i = 0;
                while (i < len) {
                    if (values[i] == null) {
                        return true;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < len) {
                    if (value.equals(values[i])) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    @Override
    public Set entrySet() {
        return null;
    }

    @Override
    public Collection values() {
        EqualsNoList viewColumnList = this.viewColumnList();
        if (viewColumnList != null) {
            int[] vc = viewColumnList.arrays();
            int len = viewColumnList.size();
            ArrayList<Object> ret = new ArrayList<Object>(len);
            Object[] values = this.src().getValues();
            int i = 0;
            while (i < len) {
                ret.add(values[vc[i]]);
                ++i;
            }
            return ret;
        }
        int len = this.parent.table.columnLength;
        ArrayList<Object> ret = new ArrayList<Object>(len);
        Object[] values = this.src().getValues();
        int i = 0;
        while (i < len) {
            ret.add(values[i]);
            ++i;
        }
        return ret;
    }

    @Override
    public Object put(Object name, Object value) {
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        EqualsNoList viewColumnList = this.viewColumnList();
        if (viewColumnList != null) {
            if (key instanceof String) {
                return this.getColumnNameByNo((String)key) != -1;
            }
            if (key instanceof Number) {
                int n = ((Number)key).intValue();
                return n >= 0 && n < viewColumnList.size();
            }
        } else {
            if (key instanceof String) {
                return this.parent.table.columnsMap.containsKey(((String)key).trim().toLowerCase());
            }
            if (key instanceof Number) {
                int n = ((Number)key).intValue();
                return n >= 0 && n < this.parent.table.columnLength;
            }
        }
        return false;
    }

    @Override
    public Object get(Object key) {
        EqualsNoList viewColumnList = this.viewColumnList();
        if (viewColumnList != null) {
            if (key instanceof String) {
                int n = this.getColumnNameByNo((String)key);
                if (n != -1) {
                    return this.src().getValue(n);
                }
                return null;
            }
            if (key instanceof Number) {
                int n = ((Number)key).intValue();
                if (n >= 0 && n < viewColumnList.size()) {
                    return this.src().getValue(viewColumnList.src(n));
                }
                return null;
            }
        } else {
            if (key instanceof String) {
                Integer n = this.parent.table.columnsMap.get(((String)key).trim().toLowerCase());
                if (n == null) {
                    return null;
                }
                return this.src().getValue(n);
            }
            if (key instanceof Number) {
                int n = ((Number)key).intValue();
                if (n >= 0 && n < this.parent.table.columnLength) {
                    return this.src().getValue(n);
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public Object remove(Object key) {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Set keySet() {
        HashSet<Object> ret = new HashSet<Object>();
        this.getAllKey(ret);
        return ret;
    }

    @Override
    public int size() {
        EqualsNoList viewColumnList = this.viewColumnList();
        if (viewColumnList != null) {
            return viewColumnList.size();
        }
        return this.parent.table.columnLength;
    }

    public void getAllKey(Set<Object> set) {
        EqualsNoList viewColumnList = this.viewColumnList();
        if (viewColumnList != null) {
            int[] vc = viewColumnList.arrays();
            int len = viewColumnList.size();
            String[] key = this.parent.table.columns;
            int i = 0;
            while (i < len) {
                set.add(key[vc[i]]);
                ++i;
            }
        } else {
            int len = this.parent.table.columnLength;
            String[] key = this.parent.table.columns;
            int i = 0;
            while (i < len) {
                set.add(key[i]);
                ++i;
            }
        }
    }

    public void getAllValues(Set<Object> set) {
        EqualsNoList viewColumnList = this.viewColumnList();
        if (viewColumnList != null) {
            int[] vc = viewColumnList.arrays();
            int len = viewColumnList.size();
            Object[] values = this.src().getValues();
            int i = 0;
            while (i < len) {
                set.add(values[vc[i]]);
                ++i;
            }
        } else {
            int len = this.parent.table.columnLength;
            Object[] values = this.src().getValues();
            int i = 0;
            while (i < len) {
                set.add(values[i]);
                ++i;
            }
        }
    }

    public String toString() {
        EqualsNoList viewColumnList = this.viewColumnList();
        if (viewColumnList != null) {
            int[] vc = viewColumnList.arrays();
            int len = viewColumnList.size();
            StringBuilder buf = new StringBuilder();
            String[] key = this.parent.table.columns;
            Object[] values = this.src().getValues();
            buf.append("{");
            int i = 0;
            while (i < len) {
                if (i != 0) {
                    buf.append(",");
                }
                if (values[vc[i]] instanceof String) {
                    buf.append(key[vc[i]]).append(":\"").append(values[vc[i]]).append("\"");
                } else {
                    buf.append(key[vc[i]]).append(":").append(values[vc[i]]);
                }
                ++i;
            }
            return buf.append("}").toString();
        }
        int len = this.parent.table.columnLength;
        StringBuilder buf = new StringBuilder();
        String[] key = this.parent.table.columns;
        Object[] values = this.src().getValues();
        buf.append("{");
        int i = 0;
        while (i < len) {
            if (i != 0) {
                buf.append(",");
            }
            if (values[i] instanceof String) {
                buf.append(key[i]).append(":\"").append(values[i]).append("\"");
            } else {
                buf.append(key[i]).append(":").append(values[i]);
            }
            ++i;
        }
        return buf.append("}").toString();
    }
}

