/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.impl;

import java.io.OutputStream;
import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.BaseTable;
import org.maachang.mimdb.core.MimdbSearchElement;
import org.maachang.mimdb.core.impl.MSearchElement;
import org.maachang.mimdb.core.util.ObjectBinary;

final class SqlSearchElement
implements MimdbSearchElement {
    protected int type;
    protected String column;
    protected Object value;
    protected int columnNo;
    protected boolean preparedType;

    public SqlSearchElement(int type) throws Exception {
        this.column = null;
        this.type = type;
        this.value = null;
        this.columnNo = -1;
        this.preparedType = false;
    }

    public SqlSearchElement(String column, int type) throws Exception {
        this.column = column;
        this.type = type;
        this.value = null;
        this.columnNo = -1;
        this.preparedType = true;
    }

    public SqlSearchElement(String column, int type, Object value) throws Exception {
        this.column = column;
        this.type = type;
        this.value = value;
        this.columnNo = -1;
        this.preparedType = false;
    }

    public String getColumn() {
        return this.column;
    }

    public int getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object v) {
        this.value = v;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean isPrepared() {
        return this.preparedType;
    }

    public boolean isWhere() {
        switch (this.type) {
            case 10: 
            case 11: 
            case 20: 
            case 21: {
                return false;
            }
        }
        return true;
    }

    public boolean isAndOr() {
        switch (this.type) {
            case 20: 
            case 21: {
                return true;
            }
        }
        return true;
    }

    public boolean isOffLimit() {
        return this.type == 30;
    }

    public int columnNameByNo(BaseTable table) throws Exception {
        if (this.column != null) {
            this.columnNo = table.getColumnNameByNo(this.column);
            if (this.columnNo == -1) {
                throw new MimdbException("\u30c6\u30fc\u30d6\u30eb[" + table.getName() + "]\u306b\u3001\u30ab\u30e9\u30e0\u540d[" + this.column + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            return this.columnNo;
        }
        throw new MimdbException("\u30ab\u30e9\u30e0\u540d\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
    }

    public int getColumnNo() {
        return this.columnNo;
    }

    public String toString() {
        return MSearchElement.toStringStatic(this.type, this.column, this.value, this.preparedType);
    }

    public void getOutput(OutputStream out) throws Exception {
        ObjectBinary.encode(out, this.type);
        ObjectBinary.encode(out, this.column);
        ObjectBinary.encode(out, this.value);
        ObjectBinary.encode(out, this.columnNo);
        ObjectBinary.encode(out, this.preparedType);
    }

    public void toObject(int[] p, byte[] b, int len) throws Exception {
        this.type = (Integer)ObjectBinary.decodeBinary(p, b, len);
        this.column = (String)ObjectBinary.decodeBinary(p, b, len);
        this.value = ObjectBinary.decodeBinary(p, b, len);
        this.columnNo = (Integer)ObjectBinary.decodeBinary(p, b, len);
        this.preparedType = (Boolean)ObjectBinary.decodeBinary(p, b, len);
    }
}

