/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ByteArrayIO
extends OutputStream {
    private static final int MIN_LENGTH = 512;
    private static final int DEF_LENGTH = 1024;
    private int maxBuffer;
    private BByteLinked last;
    private BByteLinked first;
    private int useLength;
    private int limit;
    private int position;
    private boolean closeFlag;

    public ByteArrayIO() {
        this(1024);
    }

    public ByteArrayIO(int size) {
        this.maxBuffer = size <= 512 ? 512 : size;
        this.last = new BByteLinked();
        this.last.value = new byte[this.maxBuffer];
        this.last.next = null;
        this.first = this.last;
        this.useLength = 0;
        this.limit = 0;
        this.position = 0;
        this.closeFlag = false;
    }

    public void clear() {
        this.first = this.last;
        this.useLength = 0;
        this.limit = 0;
        this.position = 0;
        this.closeFlag = false;
    }

    public void close() throws IOException {
        this.closeFlag = true;
    }

    public void flush() throws IOException {
    }

    public void write(int b) throws IOException {
        if (this.closeFlag) {
            throw new IOException("\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (this.limit >= this.maxBuffer) {
            this.last = this.last.next = new BByteLinked();
            this.last.value = new byte[this.maxBuffer];
            this.last.next = null;
            this.limit = 0;
        }
        this.last.value[this.limit++] = (byte)b;
        ++this.useLength;
    }

    public void write(byte[] bin) throws IOException {
        this.write(bin, 0, bin.length);
    }

    public void write(byte[] bin, int off, int len) throws IOException {
        if (this.closeFlag) {
            throw new IOException("\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (len <= 0) {
            return;
        }
        if (len + this.limit > this.maxBuffer) {
            int bLen = len;
            while (true) {
                if (this.maxBuffer > this.limit + len) {
                    System.arraycopy(bin, off, this.last.value, this.limit, len);
                    this.useLength += bLen;
                    this.limit += len;
                    return;
                }
                int n = this.maxBuffer - this.limit;
                System.arraycopy(bin, off, this.last.value, this.limit, n);
                off += n;
                len -= n;
                this.last = this.last.next = new BByteLinked();
                this.last.value = new byte[this.maxBuffer];
                this.last.next = null;
                this.limit = 0;
            }
        }
        if (len > 0) {
            System.arraycopy(bin, off, this.last.value, this.limit, len);
            this.useLength += len;
            this.limit += len;
        }
    }

    public void write(ByteBuffer buf) throws IOException {
        if (this.closeFlag) {
            throw new IOException("\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        int len = buf.remaining();
        if (len <= 0) {
            return;
        }
        if (len + this.limit > this.maxBuffer) {
            int bLen = len;
            while (true) {
                if (this.maxBuffer > this.limit + len) {
                    buf.get(this.last.value, this.limit, len);
                    this.useLength += bLen;
                    this.limit += len;
                    return;
                }
                int n = this.maxBuffer - this.limit;
                buf.get(this.last.value, this.limit, n);
                len -= n;
                this.last = this.last.next = new BByteLinked();
                this.last.value = new byte[this.maxBuffer];
                this.last.next = null;
                this.limit = 0;
            }
        }
        if (len > 0) {
            buf.get(this.last.value, this.limit, len);
            this.useLength += len;
            this.limit += len;
        }
    }

    public byte[] toByteArray() {
        int tLen;
        int len = this.useLength;
        int off = 0;
        BByteLinked n = this.first;
        byte[] ret = new byte[len];
        if (this.position > 0) {
            tLen = len > this.maxBuffer - this.position ? this.maxBuffer - this.position : len;
            System.arraycopy(n.value, this.position, ret, off, tLen);
            len -= tLen;
            off += tLen;
            n = n.next;
        }
        while (len > 0) {
            tLen = len > this.maxBuffer ? this.maxBuffer : len;
            System.arraycopy(n.value, 0, ret, off, tLen);
            len -= tLen;
            off += tLen;
            n = n.next;
        }
        return ret;
    }

    public int writeLength() {
        return this.useLength;
    }

    public boolean isClose() {
        return this.closeFlag;
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int read(byte[] buf, int off, int len) throws IOException {
        if (this.useLength == 0) {
            if (this.closeFlag) {
                return -1;
            }
            return 0;
        }
        if (len <= 0) {
            return 0;
        }
        if (len > this.useLength) {
            len = this.useLength;
        }
        int ret = len;
        BByteLinked n = this.first;
        if (this.position > 0) {
            int tLen = this.maxBuffer - this.position;
            if (len <= tLen) {
                System.arraycopy(n.value, this.position, buf, off, len);
                this.first = n;
                this.useLength -= ret;
                this.position += len;
                return ret;
            }
            System.arraycopy(n.value, this.position, buf, off, tLen);
            len -= tLen;
            off += tLen;
            n = n.next;
        }
        while (len > 0) {
            if (len <= this.maxBuffer) {
                System.arraycopy(n.value, 0, buf, off, len);
                this.first = n;
                this.useLength -= ret;
                this.position = len;
                return ret;
            }
            System.arraycopy(n.value, 0, buf, off, this.maxBuffer);
            len -= this.maxBuffer;
            off += this.maxBuffer;
            n = n.next;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int read(ByteBuffer buf) throws Exception {
        if (this.useLength == 0) {
            if (this.closeFlag) {
                return -1;
            }
            return 0;
        }
        int len = buf.remaining();
        if (len <= 0) {
            return 0;
        }
        if (len > this.useLength) {
            len = this.useLength;
        }
        int ret = len;
        BByteLinked n = this.first;
        if (this.position > 0) {
            int tLen = this.maxBuffer - this.position;
            if (len <= tLen) {
                buf.put(n.value, this.position, len);
                this.first = n;
                this.useLength -= ret;
                this.position += len;
                return ret;
            }
            buf.put(n.value, this.position, tLen);
            len -= tLen;
            n = n.next;
        }
        while (len > 0) {
            if (len <= this.maxBuffer) {
                buf.put(n.value, 0, len);
                this.first = n;
                this.useLength -= ret;
                this.position = len;
                return ret;
            }
            buf.put(n.value, 0, this.maxBuffer);
            len -= this.maxBuffer;
            n = n.next;
        }
        return 0;
    }

    public int peek(byte[] buf) throws IOException {
        return this.peek(buf, 0, buf.length);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int peek(byte[] buf, int off, int len) throws IOException {
        if (this.useLength == 0) {
            if (this.closeFlag) {
                return -1;
            }
            return 0;
        }
        if (len <= 0) {
            return 0;
        }
        if (len > this.useLength) {
            len = this.useLength;
        }
        int ret = len;
        BByteLinked n = this.first;
        if (this.position > 0) {
            int tLen = this.maxBuffer - this.position;
            if (len <= tLen) {
                System.arraycopy(n.value, this.position, buf, off, len);
                return ret;
            }
            System.arraycopy(n.value, this.position, buf, off, tLen);
            len -= tLen;
            off += tLen;
            n = n.next;
        }
        while (len > 0) {
            if (len <= this.maxBuffer) {
                System.arraycopy(n.value, 0, buf, off, len);
                return ret;
            }
            System.arraycopy(n.value, 0, buf, off, this.maxBuffer);
            len -= this.maxBuffer;
            off += this.maxBuffer;
            n = n.next;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int skip(int len) {
        if (this.useLength == 0) {
            if (this.closeFlag) {
                return -1;
            }
            return 0;
        }
        if (len <= 0) {
            return 0;
        }
        if (len > this.useLength) {
            len = this.useLength;
        }
        int ret = len;
        BByteLinked n = this.first;
        if (this.position > 0) {
            int tLen = this.maxBuffer - this.position;
            if (len <= tLen) {
                this.first = n;
                this.useLength -= ret;
                this.position += len;
                return ret;
            }
            len -= tLen;
            n = n.next;
        }
        while (len > 0) {
            if (len <= this.maxBuffer) {
                this.first = n;
                this.useLength -= ret;
                this.position = len;
                return ret;
            }
            len -= this.maxBuffer;
            n = n.next;
        }
        return 0;
    }

    public final int indexOf(byte[] chk) {
        BByteLinked src = this.first;
        byte[] bin = src.value;
        int bLen = bin.length;
        int p = this.position;
        int len = this.useLength;
        int cLen = chk.length;
        if (cLen == 1) {
            byte f = chk[0];
            int i = 0;
            while (i < len) {
                if (p >= bLen) {
                    src = src.next;
                    bin = src.value;
                    p = 0;
                }
                if (f == bin[p]) {
                    return i;
                }
                ++i;
                ++p;
            }
        } else {
            byte f = chk[0];
            int i = 0;
            while (i < len) {
                if (p >= bLen) {
                    src = src.next;
                    bin = src.value;
                    p = 0;
                }
                if (f == bin[p]) {
                    int j = i;
                    int n = 1;
                    BByteLinked nsrc = src;
                    byte[] nbin = bin;
                    int pp = p + 1;
                    while (j < len) {
                        if (pp >= bLen) {
                            nsrc = nsrc.next;
                            nbin = nsrc.value;
                            pp = 0;
                        }
                        if (chk[n++] != nbin[pp]) break;
                        if (n == cLen) {
                            return i;
                        }
                        ++j;
                        ++pp;
                    }
                }
                ++i;
                ++p;
            }
        }
        return -1;
    }

    public final int search(byte[] buf, int off, byte[] chk) throws Exception {
        BByteLinked src = this.first;
        byte[] bin = src.value;
        int bLen = bin.length;
        int p = this.position;
        int len = this.useLength;
        int cLen = chk.length;
        if (cLen == 1) {
            byte f = chk[0];
            int i = 0;
            while (i < len) {
                if (p >= bLen) {
                    src = src.next;
                    bin = src.value;
                    p = 0;
                }
                if (f == bin[p]) {
                    if (buf.length > i + 1 + off) {
                        return this.read(buf, off, i + 1);
                    }
                    return -2;
                }
                ++i;
                ++p;
            }
        } else {
            byte f = chk[0];
            int i = 0;
            while (i < len) {
                if (p >= bLen) {
                    src = src.next;
                    bin = src.value;
                    p = 0;
                }
                if (f == bin[p]) {
                    int j = i;
                    int n = 1;
                    BByteLinked nsrc = src;
                    byte[] nbin = bin;
                    int pp = p + 1;
                    while (j < len) {
                        if (pp >= bLen) {
                            nsrc = nsrc.next;
                            nbin = nsrc.value;
                            pp = 0;
                        }
                        if (chk[n++] != nbin[pp]) break;
                        if (n == cLen) {
                            if (buf.length > i + cLen + off) {
                                return this.read(buf, off, i + cLen);
                            }
                            return -2;
                        }
                        ++j;
                        ++pp;
                    }
                }
                ++i;
                ++p;
            }
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.useLength == 0;
    }

    private final class BByteLinked {
        byte[] value;
        BByteLinked next;

        BByteLinked() {
        }
    }
}

