/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.util;

import org.maachang.mimdb.core.util.NumberList;

public final class NumberKeySet {
    private static final int DEF_LENGTH = 32;
    private NumberKeyChild[] list;
    private int mask;
    private int length;
    private int limit;
    private int base;
    private int pos = 0;
    private NumberKeyChild cPos = null;

    public NumberKeySet() {
        this(32);
    }

    public NumberKeySet(int size) {
        size = size <= 32 ? 32 : NumberKeySet.bitMask(size);
        this.list = new NumberKeyChild[size];
        this.length = 0;
        this.mask = size - 1;
        this.limit = size;
        this.base = size;
    }

    public NumberKeySet(boolean mode, NumberList lst) {
        int[] ary = lst.list;
        int len = lst.length;
        int bufLen = NumberKeySet.bitMask(len) << 1;
        this.list = new NumberKeyChild[bufLen];
        this.length = len;
        this.mask = bufLen - 1;
        this.limit = bufLen;
        this.base = bufLen;
        if (mode) {
            int i = 0;
            while (i < len) {
                int b = ary[i];
                int h = b & this.mask;
                this.list[h] = this.list[h] == null ? new NumberKeyChild(b) : new NumberKeyChild(b, this.list[h]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                int b = ary[i];
                int h = b & this.mask;
                if (this.list[h] == null) {
                    this.list[h] = new NumberKeyChild(b);
                } else {
                    NumberKeyChild ch = this.list[h];
                    while (ch.n != null) {
                        if (ch.b == b) break;
                        ch = ch.n;
                    }
                    if (ch.b != b) {
                        ch.n = new NumberKeyChild(b);
                    }
                }
                ++i;
            }
        }
    }

    public void clear() {
        this.list = new NumberKeyChild[this.base];
        this.length = 0;
        this.mask = this.base - 1;
        this.limit = this.base;
    }

    public void add(int b) {
        int h;
        if (this.length + 1 >= this.limit) {
            int nLen = this.limit << 1;
            int msk = nLen - 1;
            NumberKeyChild[] nList = new NumberKeyChild[nLen];
            int i = 0;
            while (i < this.limit) {
                NumberKeyChild n = this.list[i];
                while (n != null) {
                    NumberKeyChild t;
                    h = n.b & msk;
                    if (nList[h] == null) {
                        t = n.n;
                        n.n = null;
                    } else {
                        t = n.n;
                        n.n = nList[h];
                    }
                    nList[h] = n;
                    n = t;
                }
                ++i;
            }
            this.list = nList;
            this.limit = nLen;
            this.mask = msk;
        }
        if (this.list[h = b & this.mask] == null) {
            this.list[h] = new NumberKeyChild(b);
            ++this.length;
        } else {
            NumberKeyChild nn = this.list[h];
            while (nn.n != null) {
                if (nn.b == b) {
                    return;
                }
                nn = nn.n;
            }
            if (nn.b != b) {
                nn.n = new NumberKeyChild(b);
                ++this.length;
            }
        }
    }

    public boolean contains(int b) {
        if (this.list[b & this.mask] != null) {
            NumberKeyChild n = this.list[b & this.mask];
            while (n != null) {
                if (n.b == b) {
                    return true;
                }
                n = n.n;
            }
        }
        return false;
    }

    public void remove(int b) {
        if (this.list[b & this.mask] != null) {
            NumberKeyChild bf = null;
            NumberKeyChild n = this.list[b & this.mask];
            while (n != null) {
                if (n.b == b) {
                    if (bf == null) {
                        this.list[b & this.mask] = n.n == null ? null : n.n;
                    } else {
                        bf.n = n.n == null ? null : n.n;
                    }
                    --this.length;
                    break;
                }
                bf = n;
                n = n.n;
            }
        }
    }

    public int size() {
        return this.length;
    }

    public int[] array() {
        if (this.length <= 0) {
            return null;
        }
        int cnt = 0;
        int[] ret = new int[this.length];
        int i = 0;
        while (i < this.limit) {
            if (this.list[i] != null) {
                NumberKeyChild n = this.list[i];
                while (n != null) {
                    ret[cnt++] = n.b;
                    n = n.n;
                }
            }
            ++i;
        }
        return ret;
    }

    public NumberKeySet reset() {
        this.pos = 0;
        this.cPos = null;
        return this;
    }

    /*
     * Unable to fully structure code
     */
    public boolean hasNext() {
        if (this.cPos == null || (this.cPos = this.cPos.n) == null) ** GOTO lbl5
        return true;
lbl-1000:
        // 1 sources

        {
            if ((this.cPos = this.list[this.pos++]) == null) continue;
            return true;
lbl5:
            // 2 sources

            ** while (this.pos < this.limit)
        }
lbl6:
        // 1 sources

        return false;
    }

    public int next() {
        if (this.cPos == null) {
            return -1;
        }
        return this.cPos.b;
    }

    protected static final int bitMask(int x) {
        if (x < 64) {
            return 64;
        }
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        x = (x & 0x55555555) + (x >> 1 & 0x55555555);
        x = (x & 0x33333333) + (x >> 2 & 0x33333333);
        x = (x & 0xF0F0F0F) + (x >> 4 & 0xF0F0F0F);
        x = (x & 0xFF00FF) + (x >> 8 & 0xFF00FF);
        x = (x & 0xFFFF) + (x >> 16 & 0xFFFF);
        return 1 << (x & 0xFFFF) + (x >> 16 & 0xFFFF) - 1;
    }

    private static final class NumberKeyChild {
        int b;
        NumberKeyChild n;

        NumberKeyChild(int v) {
            this.b = v;
        }

        NumberKeyChild(int v, NumberKeyChild nn) {
            this.b = v;
            this.n = nn;
        }
    }
}

