/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.maachang.mimdb.core.MimdbMetaData;
import org.maachang.mimdb.core.MimdbResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MimdbJdbcResultSetMetaData
implements ResultSetMetaData {
    protected MimdbMetaData meta;

    protected MimdbJdbcResultSetMetaData(MimdbResult result) {
        this.meta = result.getMetaData();
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return MimdbJdbcResultSetMetaData._getColumnClassName(this.meta.getColumnType(column - 1));
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.meta.getColumnSize();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.getPrecision(column);
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.meta.getColumnName(column - 1);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.meta.getColumnName(column - 1);
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return MimdbJdbcResultSetMetaData._getColumnType(this.meta.getColumnType(column - 1));
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.getColumnClassName(column);
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return MimdbJdbcResultSetMetaData._getPrecision(this.meta.getColumnType(column - 1));
    }

    @Override
    public int getScale(int column) throws SQLException {
        return MimdbJdbcResultSetMetaData._getScale(this.meta.getColumnType(column - 1));
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.meta.getName();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return -1;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return this.meta.getTable().isIndex(column);
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return MimdbJdbcResultSetMetaData._isSigned(this.meta.getColumnType(column - 1));
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    protected static final String _getColumnClassName(int type) throws SQLException {
        switch (type) {
            case 1: {
                return "java.lang.Boolean";
            }
            case 2: {
                return "java.lang.Integer";
            }
            case 3: {
                return "java.lang.Long";
            }
            case 4: {
                return "java.lang.Double";
            }
            case 5: {
                return "java.lang.String";
            }
            case 7: {
                return "java.sql.Date";
            }
            case 8: {
                return "java.sql.Time";
            }
            case 6: {
                return "java.sql.Timestamp";
            }
        }
        throw new SQLException("\u30d1\u30e9\u30e1\u30fc\u30bf\u7bc4\u56f2\u5916\u304b\u4e0d\u660e\u306a\u578b:" + type);
    }

    protected static final int _getColumnType(int type) throws SQLException {
        switch (type) {
            case 1: {
                return 16;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return -5;
            }
            case 4: {
                return 6;
            }
            case 5: {
                return 12;
            }
            case 7: {
                return 91;
            }
            case 8: {
                return 92;
            }
            case 6: {
                return 93;
            }
        }
        throw new SQLException("\u30d1\u30e9\u30e1\u30fc\u30bf\u7bc4\u56f2\u5916\u304b\u4e0d\u660e\u306a\u578b:" + type);
    }

    protected static final int _getPrecision(int type) throws SQLException {
        switch (type) {
            case 1: {
                return 1;
            }
            case 2: {
                return 10;
            }
            case 3: {
                return 19;
            }
            case 4: {
                return 21;
            }
            case 5: {
                return 0xFFFFFF;
            }
            case 7: {
                return 255;
            }
            case 8: {
                return 255;
            }
            case 6: {
                return 255;
            }
        }
        return -1;
    }

    protected static final int _getScale(int type) throws SQLException {
        switch (type) {
            case 4: {
                return 20;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return 0;
            }
        }
        return -1;
    }

    protected static final boolean _isSigned(int type) throws SQLException {
        switch (type) {
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return false;
            }
        }
        return false;
    }
}

