/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.server;

import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import org.maachang.mimdb.core.util.AtomicNumber32;
import org.maachang.mimdb.core.util.AtomicObject;
import org.maachang.mimdb.server.MimdbConnectElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioSelector {
    private final AtomicObject<Selector> selector = new AtomicObject<Object>(null);
    private final AtomicNumber32 wakeupCounter = new AtomicNumber32(0);

    public NioSelector() throws Exception {
        this.selector.set(Selector.open());
    }

    public final void close() {
        Selector s = this.selector.setToBeforeReturn(null);
        if (s != null) {
            try {
                Iterator<SelectionKey> it = s.keys().iterator();
                while (it.hasNext()) {
                    NioSelector.destroyKey(it.next());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                s.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        s = null;
    }

    public final int select() throws Exception {
        int ret = 0;
        Selector s = this.selector.get();
        if (s == null) {
            return -1;
        }
        Thread.yield();
        if (this.wakeupCounter.get() > 0) {
            ret = s.selectNow();
        } else {
            this.wakeupCounter.set(-1);
            ret = s.select();
        }
        this.wakeupCounter.set(0);
        return ret;
    }

    public final int select(int timeout) throws Exception {
        int ret = 0;
        Selector s = this.selector.get();
        if (s == null) {
            return -1;
        }
        Thread.yield();
        if (this.wakeupCounter.get() > 0) {
            ret = s.selectNow();
        } else {
            this.wakeupCounter.set(-1);
            ret = s.select(timeout);
        }
        this.wakeupCounter.set(0);
        return ret;
    }

    public final void wakeup() {
        Selector s = this.selector.get();
        if (s != null && this.wakeupCounter.inc() == 0) {
            s.wakeup();
        }
    }

    public final Iterator<SelectionKey> iterator() {
        Selector s = this.selector.get();
        if (s != null) {
            return s.selectedKeys().iterator();
        }
        return null;
    }

    public final SelectionKey register(SelectableChannel channel, int op) throws Exception {
        return this.register(channel, op, null);
    }

    public final SelectionKey register(SelectableChannel channel, int op, Object obj) throws Exception {
        Selector s = this.selector.get();
        if (s != null) {
            return channel.register(s, op, obj);
        }
        return null;
    }

    public static final void destroyKey(SelectionKey key) {
        if (key != null) {
            MimdbConnectElement em = (MimdbConnectElement)key.attachment();
            if (em != null) {
                key.attach(null);
                em.destroy();
            }
            key.cancel();
            if (key.channel() instanceof SocketChannel) {
                try {
                    ((SocketChannel)key.channel()).socket().close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            try {
                key.channel().close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

