package org.maachang.mimdb ;

import org.maachang.mimdb.core.impl.MimdbUtils;
import org.maachang.mimdb.core.util.AtomicNumber32;
import org.maachang.mimdb.core.util.Config;

/**
 * Mimdb組み込み起動オブジェクト.
 * 
 * @version 2014/01/22
 * @author masahito suzuki
 * @since MasterInMemDB 1.02
 */
public final class Embedded {
    private Embedded() {}
    
    /** コンフィグファイル名. **/
    private static final String CONF = "mimdb.conf" ;
    
    /** 生成チェック. **/
    private static final AtomicNumber32 createFlag = new AtomicNumber32( 0 ) ;
    
    /**
     * 組み込みMimdb生成処理.
     * @param folder 対象のフォルダを設定します.
     * @exception Exception 例外.
     */
    public static final void create( String folder ) throws Exception {
        if( folder == null || folder.length() == 0 ) {
            throw new IllegalArgumentException( "環境定義フォルダー名が設定されていません" ) ;
        }
        
        folder = MimdbUtils.getFullPath( folder ) ;
        if( !folder.endsWith( "/" ) ) {
            folder += "/" ;
        }
        String file = folder + CONF ;
        Config conf = Config.read( file ) ;
        
        /** mimdbの初期化. **/
        Mimdb mimdb = Mimdb.getInstance() ;
        mimdb.init( conf ) ;
        
        /** mimdbロード. **/
        mimdb.loadAll() ;
        
        /** 生成. **/
        createFlag.set( 1 ) ;
    }
    
    /**
     * 組み込みMimdbが生成されたかチェック.
     * @return boolean [true]の場合、生成処理が行われています.
     */
    public static final boolean isCreate() {
        return createFlag.get() == 1 ;
    }
    
}
