package org.maachang.mimdb ;

import org.maachang.mimdb.core.impl.MimdbUtils;
import org.maachang.mimdb.server.shutdown.ShutdownClient;

/**
 * Mimdbサーバーシャットダウン処理.
 * 
 * @version 2014/01/20
 * @author masahito suzuki
 * @since MasterInMemDB 1.02
 */
public final class Shutdown {
    private Shutdown() {}
    
    /** サーバー起動処理. **/
    public static final void main( String[] args ) throws Exception {
        if( args == null || args.length == 0 ) {
            ShutdownClient.send() ;
        }
        else {
            int port = MimdbUtils.convertInt( args[ 0 ] ) ;
            ShutdownClient.send( port ) ;
        }
        
    }
}

