package org.maachang.mimdb.core ;

/**
 * Mimdbプリコンパイル済みステートメント.
 * 
 * @version 2014/01/16
 * @author masahito suzuki
 * @since MasterInMemDB 1.02
 */
public interface MimdbPreparedStatement {
    
    /**
     * オブジェクトクローズ.
     */
    public void close() ;
    
    /**
     * オブジェクトがクローズしているか取得.
     * @return boolean [true]の場合、クローズしています.
     */
    public boolean isClose() ;
    
    /**
     * DB更新IDを取得.
     * この情報が、結果データと一致しない場合は、その結果データは古くなっています.
     * @return int DB更新IDが返却されます.
     */
    public long getDbId() ;
    
    /**
     * テーブル名を取得.
     * @return String テーブル名が返却されます.
     */
    public String getName() ;
    
    /**
     * preparedパラメータ数を取得.
     * @return int パラメータ数が返却されます.
     */
    public int length() ;
    
    /**
     * preparedパラメータをクリア.
     * @return MimdbPreparedStatement このオブジェクトが返却されます.
     */
    public MimdbPreparedStatement clearParams() ;
    
    /**
     * preparedパラメータを設定.
     * @param index 対象のパラメータ項番を設定します.
     * @param value 対象の設定情報を設定します.
     * @return MimdbPreparedStatement このオブジェクトが返却されます.
     */
    public MimdbPreparedStatement setParams( int index,Object value ) ;
    
    /**
     * 指定パラメータ項番のカラム名を取得.
     * @param index 対象のパラメータ項番を設定します.
     * @return String カラム名が返却されます.
     */
    public String getColumnName( int index ) ;
    
    /**
     * 指定パラメータ項番の型タイプを取得.
     * @param index 対象のパラメータ項番を設定します.
     * @return int 型タイプが返却されます.
     */
    public int getType( int index ) ;
    
    /**
     * 表示オフセット値を設定.
     * この条件により、表示位置を確定できます.
     * @param off 表示オフセット値を設定します.
     *            [-1]が設定された場合、表示幅は確定されません.
     * @return MimdbPreparedStatement このオブジェクトが返却されます.
     */
    public MimdbPreparedStatement setOffset( int off ) ;
    
    /**
     * 表示リミット値を設定.
     * この条件により、表示位置を確定できます.
     * @param limit 表示リミット値を設定します.
     *            [-1]が設定された場合、表示幅は確定されません.
     * @return MimdbPreparedStatement このオブジェクトが返却されます.
     */
    public MimdbPreparedStatement setLimit( int limit ) ;
    
    /**
     * フェッチサイズを設定.
     * ※この値は、サーバーモードでの接続のみ有効となります.
     * @param size フェッチサイズを設定します.
     * @return MimdbPreparedStatement このオブジェクトが返却されます.
     */
    public MimdbPreparedStatement setFetchSize( int size ) ;
    
    /**
     * フェッチサイズを取得.
     * ※この値は、サーバーモードでの接続のみ有効となります.
     * @return int フェッチサイズが返却されます.
     */
    public int getFetchSize() ;
    
    /**
     * クエリー実行.
     * @return MimdbResult 実行結果が返却されます.
     * @exception Exception 例外.
     */
    public MimdbResult executeQuery() throws Exception ;
    
}
