package org.maachang.mimdb.core ;

import java.util.Map;

import org.maachang.mimdb.core.impl.MimdbUtils;

/**
 * 結果行要素.
 * 
 * @version 2013/10/10
 * @author masahito suzuki
 * @since MasterInMemDB 1.00
 */
public abstract class MimdbResultRow implements Map<Object,Object>,MimdbBase {
    
    /**
     * テーブル名の取得.
     * @return String テーブル名が返却されます.
     */
    public abstract String getName() ;
    
    /**
     * 対象の行番号を取得.
     * @return int 行番号が返却されます.
     */
    public abstract int getLineNo() ;
    
    /**
     * カラム項番で情報を取得.
     * @param n 対象の項番を設定します.
     * @return Object 情報が返却されます.
     */
    public abstract Object getValue( int n ) ;
    
    /**
     * boolean情報を取得.
     * @param no 対象の項番を設定します.
     * @return Boolean 情報が返却されます.
     * @exception Exception 例外.
     */
    public Boolean getBoolean( int no ) throws Exception {
        return MimdbUtils.convertBool( getValue( no ) ) ;
    }
    
    /**
     * int情報を取得.
     * @param no 対象の項番を設定します.
     * @return Integer 情報が返却されます.
     * @exception Exception 例外.
     */
    public Integer getInt( int no ) throws Exception {
        return MimdbUtils.convertInt( getValue( no ) ) ;
    }
    
    /**
     * long情報を取得.
     * @param no 対象の項番を設定します.
     * @return Long 情報が返却されます.
     * @exception Exception 例外.
     */
    public Long getLong( int no ) throws Exception {
        return MimdbUtils.convertLong( getValue( no ) ) ;
    }
    
    /**
     * float情報を取得.
     * @param no 対象の項番を設定します.
     * @return Float 情報が返却されます.
     * @exception Exception 例外.
     */
    public Float getFloat( int no ) throws Exception {
        Double d = MimdbUtils.convertDouble( getValue( no ) ) ;
        if( d == null ) {
            return null ;
        }
        return d.floatValue() ;
    }
    
    /**
     * double情報を取得.
     * @param no 対象の項番を設定します.
     * @return Double 情報が返却されます.
     * @exception Exception 例外.
     */
    public Double getDouble( int no ) throws Exception {
        return MimdbUtils.convertDouble( getValue( no ) ) ;
    }
    
    /**
     * String情報を取得.
     * @param no 対象の項番を設定します.
     * @return String 情報が返却されます.
     * @exception Exception 例外.
     */
    public String getString( int no ) throws Exception {
        return MimdbUtils.convertString( getValue( no ) ) ;
    }
    
    /**
     * Date情報を取得.
     * @param no 対象の項番を設定します.
     * @return Date 情報が返却されます.
     * @exception Exception 例外.
     */
    public java.sql.Date getDate( int no ) throws Exception {
        return MimdbUtils.convertSqlDate( getValue( no ) ) ;
    }
    
    /**
     * Time情報を取得.
     * @param no 対象の項番を設定します.
     * @return Time 情報が返却されます.
     * @exception Exception 例外.
     */
    public java.sql.Time getTime( int no ) throws Exception {
        return MimdbUtils.convertSqlTime( getValue( no ) ) ;
    }
    
    /**
     * Timestamp情報を取得.
     * @param no 対象の項番を設定します.
     * @return Timestamp 情報が返却されます.
     * @exception Exception 例外.
     */
    public java.sql.Timestamp getTimestamp( int no ) throws Exception {
        return MimdbUtils.convertSqlTimestamp( getValue( no ) ) ;
    }
    
    /**
     * boolean情報を取得.
     * @param key 対象のカラム名を設定します.
     * @return Boolean 情報が返却されます.
     * @exception Exception 例外.
     */
    public Boolean getBoolean( String key ) throws Exception {
        return MimdbUtils.convertBool( get( key ) ) ;
    }
    
    /**
     * int情報を取得.
     * @param key 対象のカラム名を設定します.
     * @return Integer 情報が返却されます.
     * @exception Exception 例外.
     */
    public Integer getInt( String key ) throws Exception {
        return MimdbUtils.convertInt( get( key ) ) ;
    }
    
    /**
     * long情報を取得.
     * @param key 対象のカラム名を設定します.
     * @return Long 情報が返却されます.
     * @exception Exception 例外.
     */
    public Long getLong( String key ) throws Exception {
        return MimdbUtils.convertLong( get( key ) ) ;
    }
    
    /**
     * float情報を取得.
     * @param key 対象のカラム名を設定します.
     * @return Float 情報が返却されます.
     * @exception Exception 例外.
     */
    public Float getFloat( String key ) throws Exception {
        Double d = MimdbUtils.convertDouble( get( key ) ) ;
        if( d == null ) {
            return null ;
        }
        return d.floatValue() ;
    }
    
    /**
     * double情報を取得.
     * @param key 対象のカラム名を設定します.
     * @return Double 情報が返却されます.
     * @exception Exception 例外.
     */
    public Double getDouble( String key ) throws Exception {
        return MimdbUtils.convertDouble( get( key ) ) ;
    }
    
    /**
     * String情報を取得.
     * @param key 対象のカラム名を設定します.
     * @return String 情報が返却されます.
     * @exception Exception 例外.
     */
    public String getString( String key ) throws Exception {
        return MimdbUtils.convertString( get( key ) ) ;
    }
    
    /**
     * Date情報を取得.
     * @param key 対象のカラム名を設定します.
     * @return Date 情報が返却されます.
     * @exception Exception 例外.
     */
    public java.sql.Date getDate( String key ) throws Exception {
        return MimdbUtils.convertSqlDate( get( key ) ) ;
    }
    
    /**
     * Time情報を取得.
     * @param key 対象のカラム名を設定します.
     * @return Time 情報が返却されます.
     * @exception Exception 例外.
     */
    public java.sql.Time getTime( String key ) throws Exception {
        return MimdbUtils.convertSqlTime( get( key ) ) ;
    }
    
    /**
     * Timestamp情報を取得.
     * @param key 対象のカラム名を設定します.
     * @return Timestamp 情報が返却されます.
     * @exception Exception 例外.
     */
    public java.sql.Timestamp getTimestamp( String key ) throws Exception {
        return MimdbUtils.convertSqlTimestamp( get( key ) ) ;
    }
}
