package org.maachang.mimdb.jdbc ;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;

import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.MimdbConnection;
import org.maachang.mimdb.core.MimdbResult;
import org.maachang.mimdb.core.MimdbStatement;

/**
 * Mimdb-JDBC Statement.
 * 
 * @version 2013/11/19
 * @author masahito suzuki
 * @since MasterInMemDB 1.00
 */
public class MimdbJdbcStatement implements java.sql.Statement {
    protected MimdbJdbcConnection base ;
    protected MimdbConnection conn ;
    protected MimdbJdbcResultSet nowResult ;
    
    protected int fetchSize = 10 ;
    protected int maxRows = -1 ;
    
    protected MimdbJdbcStatement() {}
    
    protected MimdbJdbcStatement( MimdbJdbcConnection c,MimdbConnection cc ) {
        base = c ;
        conn = cc ;
    }
    
    protected void finalize() throws Exception {
        close() ;
    }
    
    public void close() throws SQLException {
        nowResult = null ;
        base = null ;
        conn = null ;
    }
    
    public boolean isClosed() throws SQLException {
        return ( base == null || base.isClosed() ) ;
    }
    
    /** チェック. **/
    protected final void check() {
        base.check() ;
        if( base == null ) {
            throw new MimdbException( "オブジェクトはクローズされています" ) ;
        }
    }
    
    
    public void addBatch(String sql) throws SQLException {
        throw new SQLException( "エラー: サポートされていません" ) ;
    }
    public void cancel() throws SQLException {
        throw new SQLException( "エラー: サポートされていません" ) ;
    }
    public void clearBatch() throws SQLException {
        throw new SQLException( "エラー: サポートされていません" ) ;
    }
    public void clearWarnings() throws SQLException {
        check() ;
    }
    public boolean execute(String sql) throws SQLException {
        throw new SQLException( "エラー: サポートされていません" ) ;
    }
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException( "エラー: サポートされていません" ) ;
    }
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException( "エラー: サポートされていません" ) ;
    }
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLException( "エラー: サポートされていません" ) ;
    }
    public int[] executeBatch() throws SQLException {
        throw new SQLException( "エラー: サポートされていません" ) ;
    }
    public int executeUpdate(String sql) throws SQLException {
        throw new SQLException( "エラー: サポートされていません" ) ;
    }
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException( "エラー: サポートされていません" ) ;
    }
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException( "エラー: サポートされていません" ) ;
    }
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLException( "エラー: サポートされていません" ) ;
    }
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLException( "エラー: サポートされていません" ) ;
    }
    
    public ResultSet executeQuery(String sql) throws SQLException {
        check() ;
        try {
            MimdbStatement stmt = conn.getStatement() ;
            stmt.setFetchSize( fetchSize ) ;
            if( maxRows >= 0 ) {
                stmt.setLimit( maxRows ) ;
                maxRows = -1 ;
            }
            MimdbResult res = stmt.executeQuery( sql ) ;
            nowResult = new MimdbJdbcResultSet( this,res ) ;
            return nowResult ;
        } catch( Exception e ) {
            throw new SQLException( e ) ;
        }
    }
    public Connection getConnection() throws SQLException {
        check() ;
        return base ;
    }
    public int getFetchDirection() throws SQLException {
        check() ;
        return ResultSet.FETCH_FORWARD ;
    }
    public int getFetchSize() throws SQLException {
        check() ;
        return fetchSize ;
    }
    public int getMaxFieldSize() throws SQLException {
        check() ;
        return 0 ;
    }
    public int getMaxRows() throws SQLException {
        check() ;
        if( maxRows <= 0 ) {
            return Integer.MAX_VALUE ;
        }
        return maxRows ;
    }
    public boolean getMoreResults() throws SQLException {
        check() ;
        return false ;
    }
    public boolean getMoreResults(int current) throws SQLException {
        check() ;
        return false ;
    }
    public int getQueryTimeout() throws SQLException {
        check() ;
        return 0 ;
    }
    public ResultSet getResultSet() throws SQLException {
        check() ;
        return nowResult ;
    }
    public int getResultSetConcurrency() throws SQLException {
        check() ;
        return ResultSet.CONCUR_READ_ONLY ;
    }
    public int getResultSetHoldability() throws SQLException {
        check() ;
        return ResultSet.HOLD_CURSORS_OVER_COMMIT ;
    }
    public int getResultSetType() throws SQLException {
        check() ;
        return ResultSet.TYPE_SCROLL_INSENSITIVE  ;
    }
    public int getUpdateCount() throws SQLException {
        check() ;
        return -1 ;
    }
    public SQLWarning getWarnings() throws SQLException {
        check() ;
        return null ;
    }
    public boolean isPoolable() throws SQLException {
        check() ;
        return false ;
    }
    public void setCursorName(String name) throws SQLException {
        check() ;
    }
    public void setEscapeProcessing(boolean enable) throws SQLException {
        check() ;
    }
    public void setFetchDirection(int direction) throws SQLException {
        check() ;
    }
    public void setFetchSize(int rows) throws SQLException {
        check() ;
        if( rows <= 0 ) {
            rows = 1 ;
        }
        fetchSize = rows ;
    }
    public void setMaxFieldSize(int max) throws SQLException {
        check() ;
    }
    public void setMaxRows(int max) throws SQLException {
        check() ;
        maxRows = max ;
    }
    public void setPoolable(boolean poolable) throws SQLException {
        check() ;
    }
    public void setQueryTimeout(int seconds) throws SQLException {
        check() ;
    }
    public boolean isWrapperFor(Class<?> iface) {
        check() ;
        return false ;
    }
    public <T> T unwrap(Class<T> iface) throws SQLException {
        check() ;
        return null ;
    }
    
    public void closeOnCompletion() throws SQLException {
        check() ;
    }
    
    public boolean isCloseOnCompletion() throws SQLException {
        check() ;
        return false;
    }
}
