/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core;

import org.maachang.mimdb.core.BaseTable;
import org.maachang.mimdb.core.EmbeddedConnection;
import org.maachang.mimdb.core.MimdbPreparedStatement;
import org.maachang.mimdb.core.MimdbStatement;
import org.maachang.mimdb.core.RemoteConnection;

public abstract class MimdbConnection {
    public static final MimdbConnection create() {
        return new EmbeddedConnection();
    }

    public static final MimdbConnection create(String addr) throws Exception {
        return MimdbConnection.create(-1, addr, 3210);
    }

    public static final MimdbConnection create(int timeout, String addr) throws Exception {
        return MimdbConnection.create(timeout, addr, 3210);
    }

    public static final MimdbConnection create(String addr, int port) throws Exception {
        return MimdbConnection.create(-1, addr, port);
    }

    public static final MimdbConnection create(int timeout, String addr, int port) throws Exception {
        return new RemoteConnection(addr, port, timeout);
    }

    public abstract void close();

    public abstract boolean isClose();

    public abstract BaseTable getTable(String var1) throws Exception;

    public abstract MimdbStatement getStatement() throws Exception;

    public abstract MimdbPreparedStatement getPreparedStatement(String var1) throws Exception;

    public void setTimeout(int timeout) {
    }

    public int getTimeout() {
        return 0;
    }
}

