/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core;

import java.lang.ref.SoftReference;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;
import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.MimdbRow;
import org.maachang.mimdb.core.MimdbTable;
import org.maachang.mimdb.core.util.jsnappy.JSnappy;
import org.maachang.mimdb.core.util.jsnappy.JSnappyBuffer;

public class MimdbSnappyRow
extends MimdbRow
implements Comparable<MimdbSnappyRow> {
    private static final byte NULL_CODE = -128;
    private static final int JSNAPPY_SHIFT = 3;
    protected AtomicReference<SoftReference<Object[]>> decompressCache = null;
    protected byte[] compressInfo = null;
    protected Object primaryKey = null;
    protected boolean compressFlag = true;
    protected MimdbSnappyRow parentRow = null;
    protected int parentLength = 1;
    protected int childNo = 0;

    private MimdbSnappyRow() {
    }

    protected MimdbSnappyRow(MimdbTable table, int no, Object[] val, boolean compressFlag, int binLen) throws Exception {
        this.init(table, no, val, compressFlag, binLen);
    }

    protected MimdbSnappyRow(MimdbTable table, int no, Object[] list, int binLen) throws Exception {
        this.init(table, no, list, binLen);
    }

    protected MimdbSnappyRow(MimdbSnappyRow parent, MimdbTable table, int no, Object[] val) throws Exception {
        this.init(parent, table, no, val);
    }

    protected final void init(MimdbTable table, int no, Object[] val, boolean compressFlag, int binLen) throws Exception {
        this.dbId = table.dbId;
        this.baseTable = table;
        this.lineNo = no;
        this.primaryKey = table.primaryIndexKeyNo == -1 ? null : val[table.primaryIndexKeyNo];
        this.compressInfo = MimdbSnappyRow.compressByOneLine(table, binLen, compressFlag, val);
        this.compressFlag = compressFlag;
        this.decompressCache = new AtomicReference<SoftReference<Object>>(new SoftReference<Object>(null));
        this.parentRow = null;
        this.parentLength = 1;
        this.childNo = 0;
    }

    protected final void init(MimdbTable table, int no, Object[] list, int binLen) throws Exception {
        if (list.length == 1) {
            this.init(table, no, (Object[])list[0], true, binLen);
        } else {
            this.dbId = table.dbId;
            this.baseTable = table;
            this.lineNo = no;
            this.primaryKey = table.primaryIndexKeyNo == -1 ? null : ((Object[])list[0])[table.primaryIndexKeyNo];
            int len = list.length;
            byte[] bin = new byte[binLen];
            int off = 0;
            for (int i = 0; i < len; ++i) {
                off = MimdbSnappyRow.lineByBinary(table, (Object[])list[i], bin, off);
            }
            JSnappyBuffer buf = JSnappy.compress(bin, 0, bin.length, null, 3);
            this.compressInfo = buf.toByteArray();
            this.compressFlag = true;
            this.decompressCache = new AtomicReference<SoftReference<Object>>(new SoftReference<Object>(null));
            this.parentRow = null;
            this.parentLength = len;
            this.childNo = 0;
        }
    }

    protected final void init(MimdbSnappyRow parent, MimdbTable table, int no, Object[] val) throws Exception {
        this.dbId = table.dbId;
        this.baseTable = table;
        this.lineNo = no;
        this.primaryKey = table.primaryIndexKeyNo == -1 ? null : val[table.primaryIndexKeyNo];
        this.compressFlag = true;
        this.parentRow = parent;
        this.parentLength = 0;
        this.childNo = no - parent.lineNo;
        this.decompressCache = null;
        this.compressInfo = null;
    }

    @Override
    public Object getValue(int n) {
        return this._get()[n];
    }

    @Override
    public Object getValue(String name) {
        Integer n = this.baseTable.columnsMap.get(name.trim().toLowerCase());
        if (n == null) {
            return null;
        }
        return this._get()[n];
    }

    @Override
    public Object[] getValues() {
        return this._get();
    }

    @Override
    public Object getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public int compressLength() {
        return this.compressInfo.length;
    }

    @Override
    public int compareTo(MimdbSnappyRow n) {
        if (this.primaryKey == null) {
            return 0;
        }
        return ((Comparable)this.primaryKey).compareTo(n.primaryKey);
    }

    protected final Object[] _get() {
        if (this.parentLength == 1) {
            Object[] ret = this.decompressCache.get().get();
            if (ret == null) {
                SoftReference<Object[]> cache = new SoftReference<Object[]>(MimdbSnappyRow.decompressByOneLine(this.baseTable, this.compressFlag, this.compressInfo));
                while (!this.decompressCache.compareAndSet(this.decompressCache.get(), cache)) {
                }
                ret = cache.get();
            }
            return ret;
        }
        if (this.parentLength != 0) {
            return (Object[])this._getParent()[0];
        }
        return (Object[])this.parentRow._getParent()[this.childNo];
    }

    protected final Object[] _getParent() {
        if (this.parentLength != 0) {
            Object[] ret = this.decompressCache.get().get();
            if (ret == null) {
                SoftReference<Object[]> cache = new SoftReference<Object[]>(MimdbSnappyRow.decompressParent(this.baseTable, this.compressInfo, this.parentLength));
                while (!this.decompressCache.compareAndSet(this.decompressCache.get(), cache)) {
                }
                ret = cache.get();
            }
            return ret;
        }
        return null;
    }

    protected static final int byteLength(int[] columnTypes, Object[] values) {
        int ret = 0;
        int len = columnTypes.length;
        block6: for (int i = 0; i < len; ++i) {
            switch (columnTypes[i]) {
                case 1: {
                    ++ret;
                    continue block6;
                }
                case 2: {
                    ret += 5;
                    continue block6;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: {
                    ret += 9;
                    continue block6;
                }
                case 5: {
                    if (values[i] == null) {
                        ++ret;
                        continue block6;
                    }
                    ret += ((String)values[i]).length() * 2 + 4;
                }
            }
        }
        return ret;
    }

    protected static final byte[] compressByOneLine(MimdbTable table, int binLen, boolean compressFlag, Object[] values) throws Exception {
        byte[] src = new byte[binLen];
        MimdbSnappyRow.lineByBinary(table, values, src, 0);
        if (compressFlag) {
            JSnappyBuffer buf = JSnappy.compress(src, 0, src.length, null, 3);
            return buf.toByteArray();
        }
        return src;
    }

    protected static final Object[] decompressByOneLine(MimdbTable table, boolean compressFlag, byte[] binary) {
        if (compressFlag) {
            try {
                binary = JSnappy.decompress(binary).getData();
            }
            catch (Exception e) {
                throw new MimdbException(e);
            }
        }
        int lineLen = table.columnTypes.length;
        Object[] ret = new Object[lineLen];
        MimdbSnappyRow.binaryByLine(ret, table, binary, 0, lineLen);
        return ret;
    }

    protected static final Object[] decompressParent(MimdbTable table, byte[] binary, int parentLength) {
        try {
            binary = JSnappy.decompress(binary).getData();
        }
        catch (Exception e) {
            throw new MimdbException(e);
        }
        int lineLen = table.columnTypes.length;
        Object[] ret = new Object[parentLength];
        int off = 0;
        for (int i = 0; i < parentLength; ++i) {
            Object[] n = new Object[lineLen];
            off = MimdbSnappyRow.binaryByLine(n, table, binary, off, lineLen);
            ret[i] = n;
        }
        return ret;
    }

    protected static final int lineByBinary(MimdbTable table, Object[] values, byte[] out, int offset) {
        int off = offset;
        int len = values.length;
        block6: for (int i = 0; i < len; ++i) {
            int n = table.columnTypes[i];
            switch (n) {
                case 1: {
                    if (values[i] == null) {
                        out[off++] = -128;
                        continue block6;
                    }
                    out[off++] = (Boolean)values[i] == true ? (byte)1 : 0;
                    continue block6;
                }
                case 2: {
                    if (values[i] == null) {
                        out[off] = -128;
                        off += 5;
                        continue block6;
                    }
                    int t = (Integer)values[i];
                    out[off++] = 0;
                    out[off++] = (byte)((t & 0xFF000000) >> 24);
                    out[off++] = (byte)((t & 0xFF0000) >> 16);
                    out[off++] = (byte)((t & 0xFF00) >> 8);
                    out[off++] = (byte)(t & 0xFF);
                    continue block6;
                }
                case 5: {
                    String s = (String)values[i];
                    if (s == null) {
                        out[off++] = -128;
                        continue block6;
                    }
                    int t = s.length();
                    int p = 0;
                    out[off + p] = (byte)((t & 0xFF000000) >> 24);
                    out[off + p + 1] = (byte)((t & 0xFF0000) >> 16);
                    out[off + p + 2] = (byte)((t & 0xFF00) >> 8);
                    out[off + p + 3] = (byte)(t & 0xFF);
                    p += 4;
                    for (int j = 0; j < t; ++j) {
                        char c = s.charAt(j);
                        out[off + p] = (byte)((c & 0xFF00) >> 8);
                        out[off + p + 1] = (byte)(c & 0xFF);
                        p += 2;
                    }
                    off += t * 2 + 4;
                    continue block6;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: {
                    if (values[i] == null) {
                        out[off] = -128;
                        off += 9;
                        continue block6;
                    }
                    long tt = 3 == n ? (Long)values[i] : (4 == n ? Double.doubleToRawLongBits((Double)values[i]) : ((Date)values[i]).getTime());
                    out[off++] = 0;
                    out[off++] = (byte)((tt & 0xFF00000000000000L) >> 56);
                    out[off++] = (byte)((tt & 0xFF000000000000L) >> 48);
                    out[off++] = (byte)((tt & 0xFF0000000000L) >> 40);
                    out[off++] = (byte)((tt & 0xFF00000000L) >> 32);
                    out[off++] = (byte)((tt & 0xFF000000L) >> 24);
                    out[off++] = (byte)((tt & 0xFF0000L) >> 16);
                    out[off++] = (byte)((tt & 0xFF00L) >> 8);
                    out[off++] = (byte)(tt & 0xFFL);
                }
            }
        }
        return off;
    }

    protected static final int binaryByLine(Object[] out, MimdbTable table, byte[] binary, int offset, int lineLen) {
        int off = offset;
        block6: for (int i = 0; i < lineLen; ++i) {
            int n = table.columnTypes[i];
            switch (n) {
                case 1: {
                    if (binary[off] == -128) {
                        ++off;
                        continue block6;
                    }
                    out[i] = new Boolean(binary[off++] == 1);
                    continue block6;
                }
                case 2: {
                    if (binary[off++] == -128) {
                        off += 4;
                        continue block6;
                    }
                    out[i] = new Integer((binary[off++] & 0xFF) << 24 | (binary[off++] & 0xFF) << 16 | (binary[off++] & 0xFF) << 8 | binary[off++] & 0xFF);
                    continue block6;
                }
                case 5: {
                    if (binary[off] == -128) {
                        ++off;
                        continue block6;
                    }
                    int p = 0;
                    int t = (binary[off + p] & 0xFF) << 24 | (binary[off + p + 1] & 0xFF) << 16 | (binary[off + p + 2] & 0xFF) << 8 | binary[off + p + 3] & 0xFF;
                    p += 4;
                    char[] cc = new char[t];
                    for (int j = 0; j < t; ++j) {
                        cc[j] = (char)((binary[off + p] & 0xFF) << 8 | binary[off + p + 1] & 0xFF);
                        p += 2;
                    }
                    out[i] = new String(cc);
                    off += t * 2 + 4;
                    continue block6;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: {
                    if (binary[off++] == -128) {
                        off += 8;
                        continue block6;
                    }
                    long tt = ((long)binary[off++] & 0xFFL) << 56 | ((long)binary[off++] & 0xFFL) << 48 | ((long)binary[off++] & 0xFFL) << 40 | ((long)binary[off++] & 0xFFL) << 32 | ((long)binary[off++] & 0xFFL) << 24 | ((long)binary[off++] & 0xFFL) << 16 | ((long)binary[off++] & 0xFFL) << 8 | (long)binary[off++] & 0xFFL;
                    out[i] = 3 == n ? new Long(tt) : (4 == n ? Double.valueOf(Double.longBitsToDouble(tt)) : (7 == n ? new java.sql.Date(tt) : (8 == n ? new Time(tt) : new Timestamp(tt))));
                }
            }
        }
        return off;
    }
}

