/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core;

import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.BaseTable;
import org.maachang.mimdb.core.MimdbMetaData;
import org.maachang.mimdb.core.QueryCompileInfo;
import org.maachang.mimdb.core.RemoteConnection;
import org.maachang.mimdb.core.impl.EqualsNoList;

final class RemoteMetaDataImpl
implements MimdbMetaData {
    protected RemoteConnection connection = null;
    protected QueryCompileInfo compile = null;
    protected EqualsNoList viewColumnList;
    protected boolean isClearFlag;

    public RemoteMetaDataImpl() {
    }

    public RemoteMetaDataImpl(RemoteConnection conn, QueryCompileInfo cmp, boolean clearFlg) {
        this.create(conn, cmp, clearFlg);
    }

    protected void finalize() throws Exception {
        this.clear();
    }

    public void create(RemoteConnection conn, QueryCompileInfo cmp, boolean clearFlg) {
        this.connection = conn;
        this.compile = cmp;
        this.viewColumnList = cmp.columns;
        this.isClearFlag = clearFlg;
    }

    @Override
    public void clear() {
        this.connection = null;
        this.compile = null;
        this.viewColumnList = null;
        this.isClearFlag = true;
    }

    protected final boolean isClearData() {
        return this.connection == null;
    }

    public boolean isClear() {
        return this.connection == null || this.connection.isClose();
    }

    protected void check() {
        if (this.isClear()) {
            throw new MimdbException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
    }

    @Override
    public long getDbId() {
        this.check();
        return this.compile.dbId;
    }

    @Override
    public String getName() {
        this.check();
        return this.compile.name;
    }

    @Override
    public BaseTable getTable() {
        this.check();
        try {
            return this.connection.client.getTable(this.compile.name);
        }
        catch (RuntimeException r) {
            throw r;
        }
        catch (Exception e) {
            throw new MimdbException(e);
        }
    }

    @Override
    public int getColumnSize() {
        this.check();
        if (this.compile.countFlag) {
            return 1;
        }
        if (this.viewColumnList != null) {
            return this.viewColumnList.size();
        }
        return this.getTable().getColumnSize();
    }

    @Override
    public String getColumnName(int no) {
        this.check();
        if (this.compile.countFlag) {
            if (no != 0) {
                return null;
            }
            return "count";
        }
        if (this.viewColumnList != null) {
            no = this.viewColumnList.src(no);
        }
        return this.getTable().getColumnName(no);
    }

    @Override
    public int getColumnNameByNo(String name) {
        this.check();
        if (this.compile.countFlag) {
            if ("count".equals(name)) {
                return 0;
            }
            return -1;
        }
        BaseTable table = this.getTable();
        if (this.viewColumnList != null) {
            int ret = table.getColumnNameByNo(name);
            if (!this.viewColumnList.equals(ret)) {
                return -1;
            }
            return ret;
        }
        return table.getColumnNameByNo(name);
    }

    @Override
    public int getColumnType(int no) {
        this.check();
        if (this.compile.countFlag) {
            if (no != 0) {
                return -1;
            }
            return 2;
        }
        if (this.viewColumnList != null) {
            no = this.viewColumnList.src(no);
        }
        return this.getTable().getColumnType(no);
    }

    @Override
    public int getColumnType(String name) {
        this.check();
        if (this.compile.countFlag) {
            if ("count".equals(name)) {
                return 2;
            }
            return -1;
        }
        BaseTable table = this.getTable();
        if (this.viewColumnList != null) {
            int no = table.getColumnNameByNo(name);
            if (!this.viewColumnList.equals(no)) {
                return -1;
            }
            return table.getColumnType(no);
        }
        return table.getColumnType(name);
    }
}

