/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core;

import java.lang.ref.SoftReference;
import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.BaseTable;
import org.maachang.mimdb.core.MimdbPreparedStatement;
import org.maachang.mimdb.core.MimdbResult;
import org.maachang.mimdb.core.QueryCompileInfo;
import org.maachang.mimdb.core.RemoteConnection;
import org.maachang.mimdb.core.RemoteMetaDataImpl;
import org.maachang.mimdb.core.RemoteResultImpl;
import org.maachang.mimdb.core.RemoteTableManager;

final class RemotePreparedStatement
implements MimdbPreparedStatement {
    protected String sql = null;
    protected RemoteConnection connection = null;
    protected QueryCompileInfo compile = null;
    protected Object[] executionParams = null;
    protected int viewOffset = -1;
    protected int viewLimit = -1;
    protected int fetchSize = 10;
    protected int[] out = new int[3];
    protected RemoteResultImpl result = null;
    protected final RemoteMetaDataImpl meta = new RemoteMetaDataImpl();

    private RemotePreparedStatement() {
    }

    protected RemotePreparedStatement(RemoteConnection conn, String sql) {
        this.open(conn, sql);
    }

    protected void finalize() throws Exception {
        this.close();
    }

    protected void open(RemoteConnection conn, String sql) {
        QueryCompileInfo cmp;
        this.sql = sql;
        this.connection = conn;
        SoftReference<QueryCompileInfo> s = conn.preparedList.get(sql);
        if (s == null || (cmp = s.get()) == null) {
            try {
                cmp = RemoteConnection.compile(conn, sql);
            }
            catch (RuntimeException r) {
                throw r;
            }
            catch (Exception e) {
                throw new MimdbException(e);
            }
            conn.preparedList.put(sql, new SoftReference<QueryCompileInfo>(cmp));
        }
        this.compile = cmp;
        this.meta.create(conn, cmp, false);
    }

    @Override
    public void close() {
        this.compile = null;
        this.sql = null;
        this.connection = null;
        this.meta.clear();
    }

    @Override
    public boolean isClose() {
        return this.connection == null || this.connection.isClose();
    }

    protected final void check() {
        if (this.isClose()) {
            throw new MimdbException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
    }

    @Override
    public long getDbId() {
        this.check();
        return this.compile.dbId;
    }

    @Override
    public String getName() {
        this.check();
        return this.compile.name;
    }

    public BaseTable getTable() {
        this.check();
        try {
            return this.connection.client.getTable(this.compile.name);
        }
        catch (RuntimeException r) {
            throw r;
        }
        catch (Exception e) {
            throw new MimdbException(e);
        }
    }

    @Override
    public int length() {
        this.check();
        return this.compile.preparedParamsSize;
    }

    @Override
    public MimdbPreparedStatement clearParams() {
        this.check();
        this.executionParams = null;
        return this;
    }

    @Override
    public MimdbPreparedStatement setParams(int index, Object value) {
        this.check();
        if (index < 0 || index >= this.compile.preparedParamsSize) {
            return this;
        }
        if (this.executionParams == null) {
            this.executionParams = new Object[this.compile.preparedParamsSize];
        }
        this.executionParams[index] = value;
        return this;
    }

    @Override
    public String getColumnName(int index) {
        this.check();
        if (this.compile.preparedParams == null || index < 0 || index >= this.compile.preparedParamsSize) {
            return null;
        }
        return this.compile.preparedParams[index].getColumn();
    }

    @Override
    public int getType(int index) {
        this.check();
        if (this.compile.preparedParams == null || index < 0 || index >= this.compile.preparedParamsSize) {
            return -1;
        }
        try {
            RemoteConnection.checkTable(this.connection, this.compile.name);
        }
        catch (RuntimeException r) {
            throw r;
        }
        catch (Exception e) {
            throw new MimdbException(e);
        }
        return RemoteTableManager.getInstance().get(this.compile.name).getColumnType(this.compile.preparedParams[index].getColumn());
    }

    @Override
    public boolean isListParam(int index) {
        this.check();
        if (this.compile.preparedParams == null || index < 0 || index >= this.compile.preparedParamsSize) {
            return false;
        }
        int type = this.compile.preparedParams[index].getType();
        return type == 7 || type == 9;
    }

    @Override
    public MimdbPreparedStatement setOffset(int off) {
        this.check();
        this.viewOffset = off;
        return this;
    }

    @Override
    public MimdbPreparedStatement setLimit(int limit) {
        this.check();
        this.viewLimit = limit;
        return this;
    }

    protected void clearOffLimit() {
        this.viewOffset = -1;
        this.viewLimit = -1;
    }

    @Override
    public MimdbPreparedStatement setFetchSize(int size) {
        this.check();
        this.fetchSize = size;
        return this;
    }

    @Override
    public int getFetchSize() {
        this.check();
        return this.fetchSize;
    }

    @Override
    public MimdbResult executeQuery() throws Exception {
        this.check();
        int off = this.compile.defOffset;
        int lmt = this.compile.defLimit;
        if (this.viewOffset >= 0) {
            off = this.viewOffset;
            this.viewOffset = -1;
        }
        if (this.viewLimit >= 0) {
            lmt = this.viewLimit;
            this.viewLimit = -1;
        }
        this.out[0] = -1;
        this.out[1] = -1;
        this.out[2] = -1;
        if (this.compile.preparedParamsSize > 0 && this.executionParams == null) {
            throw new MimdbException("\u5b9f\u884c\u30d1\u30e9\u30e1\u30fc\u30bf\u304c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        this.connection.client.prepared(this.out, this.compile.getPreparedId(), this.compile, off, lmt, this.executionParams);
        return this.getResult(this.connection, this.compile, this.meta, this.fetchSize, this.out[0], this.out[1], this.out[2]);
    }

    private final RemoteResultImpl getResult(RemoteConnection conn, QueryCompileInfo cmp, RemoteMetaDataImpl mt, int fetch, int resId, int len, int max) {
        if (this.connection.result.isClearData()) {
            this.connection.result.create(conn, cmp, mt, fetch, resId, len, max);
            return this.connection.result;
        }
        if (this.result == null) {
            this.result = new RemoteResultImpl(conn, cmp, mt, fetch, resId, len, max);
            return this.result;
        }
        if (this.result.isClearData()) {
            this.result.create(conn, cmp, mt, fetch, resId, len, max);
            return this.result;
        }
        return new RemoteResultImpl(conn, cmp, mt, fetch, resId, len, max);
    }
}

