/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.impl;

import java.util.List;
import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.MimdbIndex;
import org.maachang.mimdb.core.MimdbMiddleSearch;
import org.maachang.mimdb.core.MimdbSearchElement;
import org.maachang.mimdb.core.impl.FlagsMiddleSearch;
import org.maachang.mimdb.core.impl.HashIndex;
import org.maachang.mimdb.core.util.ObjectKeySet;

public abstract class AbstractNumberIndex<T>
implements MimdbIndex {
    protected static final int DEF_SIZE = 64;
    protected static final int[] NOT = new int[]{-1};
    protected String name = null;
    protected long dbId = -1L;
    protected int[][] lineList = null;
    protected HashIndex<T> hashIndex = null;
    protected int[] nullLineList = null;
    protected int[] sortNoList = null;
    protected int allLength = -1;
    protected boolean indexFlag = false;

    @Override
    public void clear() {
        this.lineList = null;
        this.hashIndex = null;
        this.nullLineList = null;
        this.sortNoList = null;
        this.allLength = -1;
        this.indexFlag = false;
    }

    @Override
    public long getDbId() {
        return this.dbId;
    }

    protected final int _calcUseLineSize(int[] posList) {
        if (posList == null) {
            return 0;
        }
        int ret = 0;
        int len = posList.length;
        for (int i = 0; i < len; ++i) {
            if (posList[i] == -1) continue;
            int[] n = posList[i] == -9 ? this.nullLineList : this.lineList[posList[i]];
            ret += n.length;
        }
        return ret;
    }

    protected final MimdbMiddleSearch _createMiddleSearch(MimdbMiddleSearch and, MimdbMiddleSearch or) {
        if (and != null) {
            FlagsMiddleSearch ret = (FlagsMiddleSearch)and;
            ret.create(ret.dbId, ret.noList);
            if (or != null) {
                ret.or(or);
            }
            return ret;
        }
        if (or != null) {
            if (or.isAnd()) {
                or.or(or);
            }
            return or;
        }
        return new FlagsMiddleSearch(this.dbId, this.allLength);
    }

    protected final void _addSearchLineNo(MimdbMiddleSearch ret, int pos) {
        if (pos == -1) {
            return;
        }
        if (pos == -9) {
            ret.addArray(this.nullLineList);
        } else {
            ret.addArray(this.lineList[pos]);
        }
    }

    protected final void _addSearchLineOffNo(MimdbMiddleSearch ret, int pos) {
        if (pos == -1) {
            return;
        }
        if (pos == -9) {
            ret.offArray(this.nullLineList);
        } else {
            ret.offArray(this.lineList[pos]);
        }
    }

    protected final int _searchNormal(MimdbSearchElement target) throws Exception {
        if (!this.indexFlag) {
            throw new MimdbException("\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u5316\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (this.lineList == null) {
            return -1;
        }
        switch (target.getType()) {
            case 1: 
            case 2: {
                return this._numberBinarySearch(target.getValue());
            }
            case 3: {
                return this._numberBinarySearchBM(true, false, target.getValue());
            }
            case 4: {
                return this._numberBinarySearchBM(true, true, target.getValue());
            }
            case 5: {
                return this._numberBinarySearchBM(false, false, target.getValue());
            }
            case 6: {
                return this._numberBinarySearchBM(false, true, target.getValue());
            }
        }
        throw new MimdbException("\u6570\u5b57\u691c\u7d22\u306b\u5bfe\u3057\u3066\u3001\u4e0d\u5f53\u306a\u691c\u7d22\u6761\u4ef6[" + target.getType() + "]\u3067\u3059");
    }

    protected final int[] _searchIn(MimdbSearchElement target) throws Exception {
        List searchInfo = (List)target.getValue();
        int len = searchInfo.size();
        if (len <= 0) {
            return NOT;
        }
        int[] ret = new int[len];
        ObjectKeySet dblChk = new ObjectKeySet(len << 1);
        for (int i = 0; i < len; ++i) {
            Object o = searchInfo.get(i);
            if (dblChk.contains(o)) {
                ret[i] = -1;
                continue;
            }
            dblChk.add(o);
            ret[i] = o == null ? -9 : this._numberBinarySearch(o);
        }
        return ret;
    }

    protected final int[] _searchBitween(MimdbSearchElement target) throws Exception {
        List searchInfo = (List)target.getValue();
        int len = searchInfo.size();
        if (len <= 0) {
            return NOT;
        }
        int[] ret = new int[len];
        for (int i = 0; i < len; ++i) {
            Object o = searchInfo.get(i);
            if (o == null) {
                ret[i] = -1;
                continue;
            }
            if ((i & 1) == 0) {
                if (i + 1 < len && searchInfo.get(i + 1) != null && ((Comparable)o).compareTo(searchInfo.get(i + 1)) > 0) {
                    ret[i] = this._numberBinarySearchBM(true, true, searchInfo.get(i + 1));
                    ret[i + 1] = this._numberBinarySearchBM(false, true, o);
                    ++i;
                    continue;
                }
                ret[i] = this._numberBinarySearchBM(true, true, o);
                continue;
            }
            ret[i] = this._numberBinarySearchBM(false, true, o);
        }
        return ret;
    }

    protected final int[] _searchNull(MimdbSearchElement target) throws Exception {
        switch (target.getType()) {
            case 1: 
            case 2: {
                if (this.nullLineList == null) {
                    return null;
                }
                return this.nullLineList;
            }
        }
        throw new MimdbException("\u6570\u5b57NULL\u691c\u7d22\u306b\u5bfe\u3057\u3066\u3001\u4e0d\u5f53\u306a\u691c\u7d22\u6761\u4ef6[" + target.getType() + "]\u3067\u3059");
    }

    protected final MimdbMiddleSearch _coreSearch(MimdbSearchElement info, MimdbMiddleSearch and, MimdbMiddleSearch or) throws Exception {
        if (info == null) {
            throw new MimdbException("\u691c\u7d22\u6761\u4ef6\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (!this.indexFlag) {
            throw new MimdbException("\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u5316\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        int type = info.getType();
        if (info.getValue() == null) {
            int[] nullPos = this._searchNull(info);
            if (type == 1) {
                if (nullPos == null) {
                    return null;
                }
                MimdbMiddleSearch ret = this._createMiddleSearch(and, or);
                ret.addArray(nullPos);
                return ret;
            }
            return this.neqSearch(-1, and, or);
        }
        if (type == 7) {
            int[] inPos = this._searchIn(info);
            if (this._calcUseLineSize(inPos) <= 0) {
                return null;
            }
            MimdbMiddleSearch ret = this._createMiddleSearch(and, or);
            int len = inPos.length;
            for (int i = 0; i < len; ++i) {
                this._addSearchLineNo(ret, inPos[i]);
            }
            return ret;
        }
        if (type == 9) {
            return this.betweenSearch(this._searchBitween(info), and, or);
        }
        int pos = this._searchNormal(info);
        if (type != 2 && pos == -1) {
            return null;
        }
        switch (type) {
            case 1: {
                return this.eqSearch(pos, and, or);
            }
            case 2: {
                return this.neqSearch(pos, and, or);
            }
            case 3: 
            case 4: {
                return this.lBigSearch(pos, and, or);
            }
            case 5: 
            case 6: {
                return this.rBigSearch(pos, and, or);
            }
        }
        return null;
    }

    protected final MimdbMiddleSearch eqSearch(int pos, MimdbMiddleSearch and, MimdbMiddleSearch or) throws Exception {
        MimdbMiddleSearch ret = this._createMiddleSearch(and, or);
        this._addSearchLineNo(ret, pos);
        return ret;
    }

    protected final MimdbMiddleSearch neqSearch(int pos, MimdbMiddleSearch and, MimdbMiddleSearch or) throws Exception {
        MimdbMiddleSearch ret = this._createMiddleSearch(and, or);
        if (pos == -1) {
            ret.all();
        } else {
            ret.all();
            this._addSearchLineOffNo(ret, pos);
        }
        return ret;
    }

    protected final MimdbMiddleSearch lBigSearch(int pos, MimdbMiddleSearch and, MimdbMiddleSearch or) throws Exception {
        MimdbMiddleSearch ret = this._createMiddleSearch(and, or);
        int len = this.lineList.length;
        for (int i = pos; i < len; ++i) {
            this._addSearchLineNo(ret, i);
        }
        return ret;
    }

    protected final MimdbMiddleSearch rBigSearch(int pos, MimdbMiddleSearch and, MimdbMiddleSearch or) throws Exception {
        MimdbMiddleSearch ret = this._createMiddleSearch(and, or);
        for (int i = pos; i >= 0; --i) {
            this._addSearchLineNo(ret, i);
        }
        return ret;
    }

    protected final MimdbMiddleSearch betweenSearch(int[] list, MimdbMiddleSearch and, MimdbMiddleSearch or) throws Exception {
        MimdbMiddleSearch ret = this._createMiddleSearch(and, or);
        int len = list.length;
        if (len == 1 && list[0] == -1) {
            ret.all();
            return ret;
        }
        int lineLen = this.lineList.length;
        int s = -1;
        int e = -1;
        for (int i = 0; i < len; ++i) {
            int j;
            if ((i & 1) == 0) {
                s = list[i];
                if (len != i + 1) continue;
                if (s == -1) {
                    s = 0;
                }
                e = lineLen;
                for (j = s; j <= e; ++j) {
                    this._addSearchLineNo(ret, j);
                }
                continue;
            }
            e = list[i];
            if (s == -1) {
                s = 0;
            }
            if (e == -1) {
                e = lineLen;
            }
            for (j = s; j <= e; ++j) {
                this._addSearchLineNo(ret, j);
            }
        }
        return ret;
    }

    @Override
    public boolean isIndex() {
        return this.indexFlag;
    }

    @Override
    public MimdbMiddleSearch search(MimdbSearchElement info) throws Exception {
        return this._coreSearch(this._checkSearchInfo(info), null, null);
    }

    @Override
    public MimdbMiddleSearch and(MimdbSearchElement info, MimdbMiddleSearch and) throws Exception {
        return this._coreSearch(this._checkSearchInfo(info), and, null);
    }

    @Override
    public MimdbMiddleSearch or(MimdbSearchElement info, MimdbMiddleSearch or) throws Exception {
        return this._coreSearch(this._checkSearchInfo(info), null, or);
    }

    @Override
    public int[] getSortNoList() {
        return this.sortNoList;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public abstract void createIndex() throws Exception;

    @Override
    public abstract int getIndexSize();

    @Override
    public abstract int getType();

    @Override
    public abstract int getDBType();

    protected abstract int _numberBinarySearch(Object var1);

    protected abstract int _numberBinarySearchBM(boolean var1, boolean var2, Object var3);

    protected abstract MimdbSearchElement _checkSearchInfo(MimdbSearchElement var1) throws Exception;
}

