/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.impl;

import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.impl.AbstractLargeFlags;
import org.maachang.mimdb.core.impl.Flags;
import org.maachang.mimdb.core.util.NumberKeyValue;

public final class LargeFlagsAnd
extends AbstractLargeFlags {
    private NumberKeyValue<int[]> src;

    public LargeFlagsAnd() {
    }

    public LargeFlagsAnd(Flags f) {
        this.create(f);
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public final void create(Flags f) {
        AbstractLargeFlags lf = (AbstractLargeFlags)f;
        NumberKeyValue<int[]> s = lf.list;
        int b = lf.blockLength;
        int m = lf.max;
        f.destroy();
        this.src = s;
        this.max = m;
        this.blockLength = b;
        this.list = new NumberKeyValue(4);
    }

    @Override
    public final void destroy() {
        super.destroy();
        this.src = null;
    }

    @Override
    public final boolean isAnd() {
        return true;
    }

    @Override
    public final void add(int no) {
        int n = no >> 9;
        int nn = no & 0x1FF;
        int[] ff = this.src.get(n);
        if (ff != null && (ff[nn >> 5] & 1 << (nn & 0x1F)) != 0) {
            ff = (int[])this.list.get(n);
            if (ff == null) {
                ff = new int[16];
                this.list.put(n, ff);
            }
            int n2 = nn >> 5;
            ff[n2] = ff[n2] | 1 << (nn & 0x1F);
        }
    }

    @Override
    public final void addArray(int[] array) {
        int b = -1;
        int[] ff = null;
        for (int a : array) {
            int n = a >> 9;
            int nn = a & 0x1FF;
            int[] sf = this.src.get(n);
            if (sf == null || (sf[nn >> 5] & 1 << (nn & 0x1F)) == 0) continue;
            if (b != n) {
                ff = (int[])this.list.get(n);
                if (ff == null) {
                    ff = new int[16];
                    this.list.put(n, ff);
                }
                b = n;
            }
            int n2 = nn >> 5;
            ff[n2] = ff[n2] | 1 << (nn & 0x1F);
        }
    }

    @Override
    public final void set(int no, int f) {
        int n = no >> 9;
        int nn = no & 0x1FF;
        int[] ff = this.src.get(n);
        if (ff != null && (ff[nn >> 5] & 1 << (nn & 0x1F)) != 0) {
            ff = (int[])this.list.get(n);
            if (ff == null) {
                ff = new int[16];
                this.list.put(n, ff);
            }
            ff[nn >> 5] = ff[nn >> 5] & ~(1 << (nn & 0x1F)) | (f & 1) << (nn & 0x1F);
        }
    }

    @Override
    public final void setArray(int[] array, int f) {
        int b = -1;
        int[] ff = null;
        for (int a : array) {
            int n = a >> 9;
            int nn = a & 0x1FF;
            int[] sf = this.src.get(n);
            if (sf == null || (sf[nn >> 5] & 1 << (nn & 0x1F)) == 0) continue;
            if (b != n) {
                ff = (int[])this.list.get(n);
                if (ff == null) {
                    ff = new int[16];
                    this.list.put(n, ff);
                }
                b = n;
            }
            ff[nn >> 5] = ff[nn >> 5] & ~(1 << (nn & 0x1F)) | (f & 1) << (nn & 0x1F);
        }
    }

    @Override
    public final void all() {
        int len = this.blockLength;
        for (int i = 0; i < len; ++i) {
            int[] sf = this.src.get(i);
            if (sf == null) continue;
            int[] ff = (int[])this.list.get(i);
            if (ff == null) {
                ff = new int[16];
                this.list.put(i, ff);
            }
            System.arraycopy(sf, 0, ff, 0, 16);
        }
    }

    @Override
    public final void marge(Flags f) {
        if (f.max() != this.max) {
            throw new MimdbException("\u9577\u3055\u304c\u4e0d\u4e00\u81f4:" + f.max() + " " + this.max);
        }
        AbstractLargeFlags lf = (AbstractLargeFlags)f;
        if (lf.list.size() == 0) {
            return;
        }
        NumberKeyValue<int[]> flist = lf.list;
        flist.reset();
        while (flist.hasNext()) {
            int n = flist.next();
            int[] sf = this.src.get(n);
            if (sf == null) continue;
            int[] ff = (int[])this.list.get(n);
            if (ff == null) {
                ff = new int[16];
                this.list.put(n, ff);
            }
            int[] bf = flist.nextValue();
            for (int i = 0; i < 16; ++i) {
                int n2 = i;
                ff[n2] = ff[n2] | bf[i] & sf[i];
            }
        }
    }
}

