/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.impl;

import java.util.Arrays;
import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.MimdbIndex;
import org.maachang.mimdb.core.MimdbMiddleSearch;
import org.maachang.mimdb.core.MimdbSearchElement;
import org.maachang.mimdb.core.impl.FlagsMiddleSearch;
import org.maachang.mimdb.core.impl.MimdbUtils;
import org.maachang.mimdb.core.util.NumberList;

public class MBoolIndex
implements MimdbIndex {
    private NumberList trueWork = null;
    private NumberList falseWork = null;
    private NumberList nullWork = null;
    private int workLength = -1;
    private int[] trueIndex = null;
    private int[] falseIndex = null;
    private int[] nullIndex = null;
    private int[] sortNoList = null;
    protected String name = null;
    protected long dbId = -1L;
    protected int allLength = -1;
    protected boolean indexFlag = false;

    private MBoolIndex() {
    }

    public MBoolIndex(int id, String n) {
        this(id, n, 0);
    }

    public MBoolIndex(long id, String n, int size) {
        if (n == null || (n = n.trim().toLowerCase()).length() <= 0) {
            throw new MimdbException("\u30ab\u30e9\u30e0\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (size <= 0) {
            size = 64;
        }
        this.dbId = id;
        this.workLength = size;
        this.name = n;
    }

    @Override
    public void clear() {
        this.trueWork = null;
        this.falseWork = null;
        this.nullWork = null;
        this.trueIndex = null;
        this.falseIndex = null;
        this.nullIndex = null;
        this.sortNoList = null;
        this.allLength = -1;
        this.indexFlag = false;
    }

    @Override
    public long getDbId() {
        return this.dbId;
    }

    public void add(Boolean value, int lineNo) {
        if (value == null) {
            if (this.nullWork == null) {
                this.nullWork = new NumberList(this.workLength);
            }
            this.nullWork.add(lineNo);
        }
        if (value.booleanValue()) {
            if (this.trueWork == null) {
                this.trueWork = new NumberList(this.workLength);
            }
            this.trueWork.add(lineNo);
        } else {
            if (this.falseWork == null) {
                this.falseWork = new NumberList(this.workLength);
            }
            this.falseWork.add(lineNo);
        }
        if (this.allLength == -1) {
            this.allLength = 0;
        }
        ++this.allLength;
    }

    public void add(Object value, int lineNo) throws Exception {
        this.add(MimdbUtils.convertBool(value), lineNo);
    }

    @Override
    public void createIndex() throws Exception {
        if (this.allLength == -1) {
            this.clear();
            return;
        }
        this.trueIndex = null;
        this.falseIndex = null;
        this.nullIndex = null;
        this.sortNoList = null;
        this.indexFlag = false;
        int[] _sortNoList = new int[this.allLength];
        Arrays.fill(_sortNoList, -1);
        int[] nullIx = null;
        if (this.nullWork != null) {
            int len = this.nullWork.size();
            nullIx = new int[len];
            for (int i = 0; i < len; ++i) {
                nullIx[i] = this.nullWork.get(i);
            }
        }
        int[] trueIx = null;
        if (this.trueWork != null) {
            int len = this.trueWork.size();
            trueIx = new int[len];
            for (int i = 0; i < len; ++i) {
                trueIx[i] = this.trueWork.get(i);
                _sortNoList[trueIx[i]] = 1;
            }
        }
        int[] falseIx = null;
        if (this.falseWork != null) {
            int len = this.falseWork.size();
            falseIx = new int[len];
            for (int i = 0; i < len; ++i) {
                falseIx[i] = this.falseWork.get(i);
                _sortNoList[falseIx[i]] = 0;
            }
        }
        this.trueIndex = trueIx;
        this.falseIndex = falseIx;
        this.nullIndex = nullIx;
        this.sortNoList = _sortNoList;
        this.indexFlag = true;
    }

    protected MimdbSearchElement _checkSearchInfo(MimdbSearchElement info) throws Exception {
        info.setValue(MimdbUtils.convertBool(info.getValue()));
        return info;
    }

    protected final MimdbMiddleSearch _createMiddleSearch(MimdbMiddleSearch and, MimdbMiddleSearch or) {
        if (and != null) {
            FlagsMiddleSearch ret = (FlagsMiddleSearch)and;
            ret.create(ret.dbId, ret.noList);
            if (or != null) {
                ret.or(or);
            }
            return ret;
        }
        if (or != null) {
            if (or.isAnd()) {
                or.or(or);
            }
            return or;
        }
        return new FlagsMiddleSearch(this.dbId, this.allLength);
    }

    protected final MimdbMiddleSearch _addResultOnSearch(MimdbMiddleSearch and, MimdbMiddleSearch or, int[] list) throws Exception {
        MimdbMiddleSearch ret = this._createMiddleSearch(and, or);
        ret.addArray(list);
        return ret;
    }

    protected final MimdbMiddleSearch _addResultOffSearch(MimdbMiddleSearch and, MimdbMiddleSearch or, int[] list) throws Exception {
        MimdbMiddleSearch ret = this._createMiddleSearch(and, or);
        ret.all();
        ret.offArray(list);
        return ret;
    }

    protected final MimdbMiddleSearch _coreSearch(MimdbSearchElement info, MimdbMiddleSearch and, MimdbMiddleSearch or) throws Exception {
        if (info == null) {
            throw new MimdbException("\u691c\u7d22\u6761\u4ef6\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (!this.indexFlag) {
            throw new MimdbException("\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u5316\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (info.getValue() == null) {
            if (info.getType() == 1) {
                if (this.nullIndex == null) {
                    return null;
                }
                return this._addResultOnSearch(and, or, this.nullIndex);
            }
            if (this.trueIndex == null && this.falseIndex == null) {
                return null;
            }
            return this._addResultOffSearch(and, or, this.nullIndex);
        }
        boolean value = MimdbUtils.convertBool(info.getValue());
        switch (info.getType()) {
            case 1: {
                if (value) {
                    if (this.trueIndex != null) {
                        return this._addResultOnSearch(and, or, this.trueIndex);
                    }
                } else if (this.falseIndex != null) {
                    return this._addResultOnSearch(and, or, this.falseIndex);
                }
                return null;
            }
            case 2: {
                if (value) {
                    if (this.trueIndex != null) {
                        return this._addResultOffSearch(and, or, this.trueIndex);
                    }
                } else if (this.falseIndex != null) {
                    return this._addResultOffSearch(and, or, this.falseIndex);
                }
                MimdbMiddleSearch ret = this._createMiddleSearch(and, or);
                ret.all();
                return ret;
            }
        }
        throw new MimdbException("\u6570\u5b57\u691c\u7d22\u306b\u5bfe\u3057\u3066\u3001\u4e0d\u5f53\u306a\u691c\u7d22\u6761\u4ef6[" + info.getType() + "]\u3067\u3059");
    }

    @Override
    public boolean isIndex() {
        return this.indexFlag;
    }

    @Override
    public MimdbMiddleSearch search(MimdbSearchElement info) throws Exception {
        return this._coreSearch(this._checkSearchInfo(info), null, null);
    }

    @Override
    public MimdbMiddleSearch and(MimdbSearchElement info, MimdbMiddleSearch and) throws Exception {
        return this._coreSearch(this._checkSearchInfo(info), and, null);
    }

    @Override
    public MimdbMiddleSearch or(MimdbSearchElement info, MimdbMiddleSearch or) throws Exception {
        return this._coreSearch(this._checkSearchInfo(info), null, or);
    }

    @Override
    public int[] getSortNoList() {
        return this.sortNoList;
    }

    @Override
    public int getIndexSize() {
        return 2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public int getDBType() {
        return 16;
    }

    @Override
    public boolean isNGram() {
        return false;
    }
}

