/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.MimdbSearchElement;
import org.maachang.mimdb.core.impl.MLongIndex;
import org.maachang.mimdb.core.impl.MimdbUtils;

public class MDateIndex
extends MLongIndex {
    public MDateIndex(long id, String n, boolean h) {
        this(id, n, 0, h);
    }

    public MDateIndex(long id, String n, int size, boolean h) {
        if (n == null || (n = n.trim().toLowerCase()).length() <= 0) {
            throw new MimdbException("\u30ab\u30e9\u30e0\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (size <= 0) {
            size = 64;
        }
        this.dbId = id;
        this.workLength = size;
        this.name = n;
        this.useHashFlag = h;
    }

    public void add(Date value, int lineNo) throws Exception {
        if (value == null) {
            super.add(null, lineNo);
        } else {
            super.add(MimdbUtils.convertSqlDate(value).getTime(), lineNo);
        }
    }

    @Override
    public void add(Object value, int lineNo) throws Exception {
        if (value == null) {
            super.add(null, lineNo);
        } else {
            super.add(MimdbUtils.convertSqlDate(value).getTime(), lineNo);
        }
    }

    @Override
    public int getType() {
        return 7;
    }

    @Override
    public int getDBType() {
        return 91;
    }

    @Override
    protected final MimdbSearchElement _checkSearchInfo(MimdbSearchElement info) throws Exception {
        if (info.getType() == 7 || info.getType() == 9) {
            Object o = info.getValue();
            if (!(o instanceof List)) {
                ArrayList<Long> lst = new ArrayList<Long>(1);
                lst.add(MimdbUtils.convertSqlDate(o).getTime());
                info.setValue(lst);
            } else {
                List n = (List)o;
                int len = n.size();
                ArrayList<Long> lst = new ArrayList<Long>(len);
                for (int i = 0; i < len; ++i) {
                    lst.add(MimdbUtils.convertSqlDate(n.get(i)).getTime());
                }
                info.setValue(lst);
            }
            return info;
        }
        info.setValue(MimdbUtils.convertSqlDate(info.getValue()).getTime());
        return info;
    }
}

