/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.MimdbSearchElement;
import org.maachang.mimdb.core.impl.AbstractNumberIndex;
import org.maachang.mimdb.core.impl.HashIndex;
import org.maachang.mimdb.core.impl.MimdbUtils;
import org.maachang.mimdb.core.util.NumberKeyValue;
import org.maachang.mimdb.core.util.NumberList;
import org.maachang.mimdb.core.util.ObjectList;

public class MIntIndex
extends AbstractNumberIndex<Integer> {
    private ObjectList<MIntColumnWorkChild> work = null;
    private int workLength = -1;
    private int[] indexList = null;
    private boolean useHashFlag = false;

    private MIntIndex() {
    }

    public MIntIndex(int id, String n, boolean h) {
        this(id, n, 0, h);
    }

    public MIntIndex(long id, String n, int size, boolean h) {
        if (n == null || (n = n.trim().toLowerCase()).length() <= 0) {
            throw new MimdbException("\u30ab\u30e9\u30e0\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (size <= 0) {
            size = 64;
        }
        this.dbId = id;
        this.workLength = size;
        this.name = n;
        this.useHashFlag = h;
    }

    @Override
    public void clear() {
        super.clear();
        this.work = null;
        this.indexList = null;
    }

    public void add(Integer value, int lineNo) {
        if (this.work == null) {
            this.work = new ObjectList(this.workLength);
        }
        if (value == null) {
            this.work.add(new MIntColumnWorkChild(value, -1, true));
        } else {
            this.work.add(new MIntColumnWorkChild(value, lineNo, false));
        }
    }

    public void add(Object value, int lineNo) throws Exception {
        this.add(MimdbUtils.convertInt(value), lineNo);
    }

    @Override
    public void createIndex() throws Exception {
        Object n;
        MIntColumnWorkChild k;
        int len;
        if (this.work == null) {
            this.clear();
            return;
        }
        this.indexList = null;
        this.lineList = null;
        this.nullLineList = null;
        this.sortNoList = null;
        this.allLength = -1;
        this.indexFlag = false;
        NumberList nullList = new NumberList(32);
        int _allLength = len = this.work.size();
        NumberKeyValue<MIntColumnIndexChild> map = new NumberKeyValue<MIntColumnIndexChild>(len * 2);
        for (int i = 0; i < len; ++i) {
            k = this.work.get(i);
            if (k.nullFlag) {
                nullList.add(k.lineNo);
                continue;
            }
            n = (MIntColumnIndexChild)map.get(k.value);
            if (n != null) {
                ((MIntColumnIndexChild)n).lineNo.add(k.lineNo);
                continue;
            }
            map.put(k.value, new MIntColumnIndexChild(k.value, k.lineNo));
        }
        k = null;
        n = null;
        this.work = null;
        len = map.size();
        if (len > 0) {
            Object[] lst = new MIntColumnIndexChild[len];
            NumberKeyValue it = map.reset();
            int cnt = 0;
            while (it.hasNext()) {
                lst[cnt++] = (MIntColumnIndexChild)it.nextValue();
            }
            it = null;
            map = null;
            Arrays.sort(lst);
            int[] _indexList = new int[len];
            int[][] _lineList = new int[len][];
            HashIndex _hashIndex = null;
            int[] _sortNoList = new int[_allLength];
            Arrays.fill(_sortNoList, -1);
            for (int i = 0; i < len; ++i) {
                n = lst[i];
                _indexList[i] = ((MIntColumnIndexChild)n).value;
                int[] nlst = ((MIntColumnIndexChild)n).getLineNo();
                _lineList[i] = nlst;
                int lenJ = nlst.length;
                for (int j = 0; j < lenJ; ++j) {
                    _sortNoList[nlst[j]] = i;
                }
            }
            lst = null;
            if (this.useHashFlag) {
                _hashIndex = new HashIndex(_indexList);
            }
            this.indexList = _indexList;
            this.lineList = _lineList;
            this.hashIndex = _hashIndex;
            this.sortNoList = _sortNoList;
        }
        if ((len = nullList.size()) > 0) {
            int[] _nullLineList = new int[len];
            for (int i = 0; i < len; ++i) {
                _nullLineList[i] = nullList.get(i);
            }
            nullList = null;
            this.nullLineList = _nullLineList;
        }
        this.allLength = _allLength;
        this.indexFlag = true;
    }

    @Override
    public int getIndexSize() {
        return this.indexList.length;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public int getDBType() {
        return 4;
    }

    @Override
    public boolean isNGram() {
        return false;
    }

    @Override
    protected MimdbSearchElement _checkSearchInfo(MimdbSearchElement info) throws Exception {
        if (info.getType() == 7 || info.getType() == 9) {
            Object o = info.getValue();
            if (!(o instanceof List)) {
                ArrayList<Integer> lst = new ArrayList<Integer>(1);
                lst.add(MimdbUtils.convertInt(o));
                info.setValue(lst);
            } else {
                List n = (List)o;
                int len = n.size();
                ArrayList<Integer> lst = new ArrayList<Integer>(len);
                for (int i = 0; i < len; ++i) {
                    lst.add(MimdbUtils.convertInt(n.get(i)));
                }
                info.setValue(lst);
            }
            return info;
        }
        info.setValue(MimdbUtils.convertInt(info.getValue()));
        return info;
    }

    @Override
    protected final int _numberBinarySearch(Object target) {
        if (this.indexList == null) {
            return -1;
        }
        if (this.useHashFlag) {
            return this.hashIndex.eq((Integer)target);
        }
        return MimdbUtils.searchInt(this.indexList, (Integer)target);
    }

    @Override
    protected int _numberBinarySearchBM(boolean big, boolean eq, Object target) {
        int p;
        if (this.indexList == null) {
            return -1;
        }
        int t = (Integer)target;
        if (t == this.indexList[p = MimdbUtils.searchIntBS(big, this.indexList, t)]) {
            if (eq) {
                return p;
            }
            if (big) {
                if (this.indexList.length <= p + 1) {
                    return -1;
                }
                return p + 1;
            }
            if (p <= 0) {
                return -1;
            }
            return p - 1;
        }
        return p;
    }

    private static final class MIntColumnIndexChild
    implements Comparable<MIntColumnIndexChild> {
        int value;
        NumberList lineNo = new NumberList();

        public MIntColumnIndexChild(int v, int n) {
            this.value = v;
            this.lineNo.add(n);
        }

        @Override
        public int compareTo(MIntColumnIndexChild n) {
            return this.value - n.value;
        }

        public int[] getLineNo() {
            int len = this.lineNo.size();
            int[] ret = new int[len];
            for (int i = 0; i < len; ++i) {
                ret[i] = this.lineNo.get(i);
            }
            return ret;
        }
    }

    private static final class MIntColumnWorkChild {
        int value;
        int lineNo;
        boolean nullFlag;

        public MIntColumnWorkChild(int v, int n, boolean nf) {
            this.value = v;
            this.lineNo = n;
            this.nullFlag = nf;
        }
    }
}

