/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.MimdbSearchElement;
import org.maachang.mimdb.core.impl.AbstractNumberIndex;
import org.maachang.mimdb.core.impl.HashIndex;
import org.maachang.mimdb.core.impl.MimdbUtils;
import org.maachang.mimdb.core.util.NNObjectKeyValue;
import org.maachang.mimdb.core.util.NumberList;
import org.maachang.mimdb.core.util.ObjectList;

public class MLongIndex
extends AbstractNumberIndex<Long> {
    protected ObjectList<MLongColumnWorkChild> work = null;
    protected int workLength = -1;
    protected long[] indexList = null;
    protected boolean useHashFlag = false;

    protected MLongIndex() {
    }

    public MLongIndex(long id, String n, boolean h) {
        this(id, n, 0, h);
    }

    public MLongIndex(long id, String n, int size, boolean h) {
        if (n == null || (n = n.trim().toLowerCase()).length() <= 0) {
            throw new MimdbException("\u30ab\u30e9\u30e0\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (size <= 0) {
            size = 64;
        }
        this.dbId = id;
        this.workLength = size;
        this.name = n;
        this.useHashFlag = h;
    }

    @Override
    public void clear() {
        super.clear();
        this.work = null;
        this.indexList = null;
    }

    public void add(Long value, int lineNo) {
        if (this.work == null) {
            this.work = new ObjectList(this.workLength);
        }
        if (value == null) {
            this.work.add(new MLongColumnWorkChild(value, -1, true));
        } else {
            this.work.add(new MLongColumnWorkChild(value, lineNo, false));
        }
    }

    public void add(Object value, int lineNo) throws Exception {
        this.add(MimdbUtils.convertLong(value), lineNo);
    }

    @Override
    public void createIndex() throws Exception {
        Object n;
        MLongColumnWorkChild k;
        int len;
        if (this.work == null) {
            this.clear();
            return;
        }
        this.indexList = null;
        this.lineList = null;
        this.nullLineList = null;
        this.sortNoList = null;
        this.allLength = -1;
        this.indexFlag = false;
        NumberList nullList = new NumberList(32);
        int _allLength = len = this.work.size();
        NNObjectKeyValue<Long, MLongColumnIndexChild> map = new NNObjectKeyValue<Long, MLongColumnIndexChild>(len * 2);
        for (int i = 0; i < len; ++i) {
            k = this.work.get(i);
            if (k.nullFlag) {
                nullList.add(k.lineNo);
                continue;
            }
            n = (MLongColumnIndexChild)map.get(k.value);
            if (n != null) {
                ((MLongColumnIndexChild)n).lineNo.add(k.lineNo);
                continue;
            }
            map.put(k.value, new MLongColumnIndexChild(k.value, k.lineNo));
        }
        k = null;
        n = null;
        this.work = null;
        len = map.size();
        if (len > 0) {
            Object[] lst = new MLongColumnIndexChild[len];
            NNObjectKeyValue it = map.reset();
            int cnt = 0;
            while (it.hasNext()) {
                lst[cnt++] = (MLongColumnIndexChild)map.get((Long)it.next());
            }
            it = null;
            map = null;
            Arrays.sort(lst);
            long[] _indexList = new long[len];
            int[][] _lineList = new int[len][];
            HashIndex _hashIndex = null;
            int[] _sortNoList = new int[_allLength];
            Arrays.fill(_sortNoList, -1);
            for (int i = 0; i < len; ++i) {
                n = lst[i];
                _indexList[i] = ((MLongColumnIndexChild)n).value;
                int[] nlst = ((MLongColumnIndexChild)n).getLineNo();
                _lineList[i] = nlst;
                int lenJ = nlst.length;
                for (int j = 0; j < lenJ; ++j) {
                    _sortNoList[nlst[j]] = i;
                }
            }
            lst = null;
            if (this.useHashFlag) {
                _hashIndex = new HashIndex(_indexList);
            }
            this.indexList = _indexList;
            this.lineList = _lineList;
            this.hashIndex = _hashIndex;
            this.sortNoList = _sortNoList;
        }
        if ((len = nullList.size()) > 0) {
            int[] _nullLineList = new int[len];
            for (int i = 0; i < len; ++i) {
                _nullLineList[i] = nullList.get(i);
            }
            nullList = null;
            this.nullLineList = _nullLineList;
        }
        this.allLength = _allLength;
        this.indexFlag = true;
    }

    @Override
    public int getIndexSize() {
        return this.indexList.length;
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public int getDBType() {
        return -5;
    }

    @Override
    public boolean isNGram() {
        return false;
    }

    @Override
    protected MimdbSearchElement _checkSearchInfo(MimdbSearchElement info) throws Exception {
        if (info.getType() == 7 || info.getType() == 9) {
            Object o = info.getValue();
            if (!(o instanceof List)) {
                ArrayList<Long> lst = new ArrayList<Long>(1);
                lst.add(MimdbUtils.convertLong(o));
                info.setValue(lst);
            } else {
                List n = (List)o;
                int len = n.size();
                ArrayList<Long> lst = new ArrayList<Long>(len);
                for (int i = 0; i < len; ++i) {
                    lst.add(MimdbUtils.convertLong(n.get(i)));
                }
                info.setValue(lst);
            }
            return info;
        }
        info.setValue(MimdbUtils.convertLong(info.getValue()));
        return info;
    }

    @Override
    protected final int _numberBinarySearch(Object target) {
        if (this.indexList == null) {
            return -1;
        }
        if (this.useHashFlag) {
            return this.hashIndex.eq((Long)target);
        }
        return MimdbUtils.searchLong(this.indexList, (Long)target);
    }

    @Override
    protected int _numberBinarySearchBM(boolean big, boolean eq, Object target) {
        int p;
        if (this.indexList == null) {
            return -1;
        }
        long t = (Long)target;
        if (t == this.indexList[p = MimdbUtils.searchLongBS(big, this.indexList, t)]) {
            if (eq) {
                return p;
            }
            if (big) {
                if (this.indexList.length <= p + 1) {
                    return -1;
                }
                return p + 1;
            }
            if (p <= 0) {
                return -1;
            }
            return p - 1;
        }
        return p;
    }

    private static final class MLongColumnIndexChild
    implements Comparable<MLongColumnIndexChild> {
        long value;
        NumberList lineNo = new NumberList();

        public MLongColumnIndexChild(long v, int n) {
            this.value = v;
            this.lineNo.add(n);
        }

        @Override
        public int compareTo(MLongColumnIndexChild n) {
            return (int)(this.value - n.value);
        }

        public int[] getLineNo() {
            int len = this.lineNo.size();
            int[] ret = new int[len];
            for (int i = 0; i < len; ++i) {
                ret[i] = this.lineNo.get(i);
            }
            return ret;
        }
    }

    private static final class MLongColumnWorkChild {
        long value;
        int lineNo;
        boolean nullFlag;

        public MLongColumnWorkChild(long v, int n, boolean nf) {
            this.value = v;
            this.lineNo = n;
            this.nullFlag = nf;
        }
    }
}

