/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.impl;

public final class MStringIndexKey
implements Comparable<MStringIndexKey> {
    protected final char[] value;
    protected final int hash;
    protected final int length;

    public MStringIndexKey() {
        this.value = null;
        this.hash = -1;
        this.length = -1;
    }

    public MStringIndexKey(char[] v, int h, int l) {
        this.value = v;
        this.hash = h;
        this.length = l;
    }

    public MStringIndexKey(String v) {
        if (v == null) {
            this.value = null;
            this.hash = -1;
            this.length = -1;
        } else {
            int len = v.length();
            char[] vv = new char[len];
            for (int i = 0; i < len; ++i) {
                vv[i] = v.charAt(i);
            }
            this.value = vv;
            if (len == 0) {
                this.hash = 0;
                this.length = 0;
            } else {
                this.hash = MStringIndexKey.fnv32a(vv, len);
                this.length = len;
            }
        }
    }

    public MStringIndexKey(char[] v) {
        if (v == null) {
            this.value = null;
            this.hash = -1;
            this.length = -1;
        } else {
            this.value = v;
            this.length = v.length;
            this.hash = this.length == 0 ? 0 : MStringIndexKey.fnv32a(v, this.length);
        }
    }

    protected static final int fnv32a(char[] key, int len) {
        int ret = -2128831035;
        for (int i = 0; i < len; ++i) {
            ret ^= key[i];
            ret = ret + (ret << 1) + (ret << 4) + (ret << 7) + (ret << 8) + (ret << 24);
        }
        return (ret & 0x7FFFFFFE) + 1;
    }

    public final boolean isNull() {
        return this.length == -1;
    }

    public final boolean isEmpty() {
        return this.length == 0;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MStringIndexKey) {
            MStringIndexKey oo = (MStringIndexKey)o;
            if (oo.length == this.length && oo.hash == this.hash && oo.value[0] == this.value[0]) {
                int i = 0;
                int len = this.length;
                char[] ooo = oo.value;
                char[] v = this.value;
                while (++i < len && ooo[i] == v[i]) {
                }
                return i == len;
            }
        }
        return false;
    }

    public final boolean equals(int off, MStringIndexKey o, int oOff, int len) {
        if (o.value[oOff] == this.value[off]) {
            int i = 0;
            char[] oval = o.value;
            char[] v = this.value;
            while (++i < len && oval[oOff + i] == v[off + i]) {
            }
            return i == len;
        }
        return false;
    }

    @Override
    public final int compareTo(MStringIndexKey n) {
        int len;
        if (n == this) {
            return 0;
        }
        int n2 = len = this.length < n.length ? this.length : n.length;
        if (n.value[0] == this.value[0]) {
            int i = 0;
            char[] ooo = n.value;
            char[] v = this.value;
            while (++i < len && ooo[i] == v[i]) {
            }
            return i == len ? this.length - n.length : v[i] - ooo[i];
        }
        return this.value[0] - n.value[0];
    }

    public final int toBig(MStringIndexKey n) {
        int len;
        if (n == this) {
            return 0;
        }
        int n2 = len = this.length < n.length ? this.length : n.length;
        if (n.value[0] == this.value[0]) {
            int i = 0;
            char[] ooo = n.value;
            char[] v = this.value;
            while (++i < len && ooo[i] == v[i]) {
            }
            return i == len ? 0 : v[i] - ooo[i];
        }
        return this.value[0] - n.value[0];
    }

    public final int indexOf(String n, int off) {
        int len = n.length();
        if (len == 0 || off + len > this.length) {
            return -1;
        }
        if (len == 1) {
            char[] v = this.value;
            char nn = n.charAt(0);
            int vLen = this.length;
            for (int i = off; i < vLen; ++i) {
                if (nn != v[i]) {
                    while (++i < vLen && nn != v[i]) {
                    }
                    if (vLen == i) continue;
                    return i;
                }
                return i;
            }
        } else {
            char[] v = this.value;
            int vLen = this.length - (len - 1);
            char first = n.charAt(0);
            for (int i = off; i < vLen; ++i) {
                if (v[i] != first) {
                    while (++i < vLen && v[i] != first) {
                    }
                }
                if (i >= vLen) continue;
                int next = i + len;
                int j = i + 1;
                int k = 1;
                while (j < next && v[j] == n.charAt(k)) {
                    ++j;
                    ++k;
                }
                if (j != next) continue;
                return i;
            }
        }
        return -1;
    }

    public final int indexOf(char[] n, int off) {
        int len = n.length;
        if (len == 0 || off + len > this.length) {
            return -1;
        }
        if (len == 1) {
            char[] v = this.value;
            char nn = n[0];
            int vLen = this.length;
            for (int i = off; i < vLen; ++i) {
                if (nn != v[i]) {
                    while (++i < vLen && nn != v[i]) {
                    }
                    if (vLen == i) continue;
                    return i;
                }
                return i;
            }
        } else {
            char[] v = this.value;
            int vLen = this.length - (len - 1);
            char first = n[0];
            for (int i = off; i < vLen; ++i) {
                if (first != v[i]) {
                    while (++i < vLen && v[i] != first) {
                    }
                }
                if (i >= vLen) continue;
                int next = i + len;
                int j = i + 1;
                int k = 1;
                while (j < next && v[j] == n[k]) {
                    ++j;
                    ++k;
                }
                if (j != next) continue;
                return i;
            }
        }
        return -1;
    }

    public final int indexOf(MStringIndexKey n, int off) {
        if (n.isNull() || n.isEmpty()) {
            return -1;
        }
        return this.indexOf(n.value, off);
    }

    public final boolean startsWith(String n) {
        if (n.length() > this.length) {
            return false;
        }
        if (n.charAt(0) == this.value[0]) {
            int i = 0;
            int len = n.length();
            char[] v = this.value;
            while (++i < len && n.charAt(i) == v[i]) {
            }
            return i == len;
        }
        return false;
    }

    public final boolean startsWith(char[] n) {
        if (n.length > this.length) {
            return false;
        }
        if (n[0] == this.value[0]) {
            int i = 0;
            int len = n.length;
            char[] v = this.value;
            while (++i < len && n[i] == v[i]) {
            }
            return i == len;
        }
        return false;
    }

    public final boolean startsWith(MStringIndexKey n) {
        if (n.isNull() || n.isEmpty()) {
            return false;
        }
        return this.startsWith(n.value);
    }

    public final boolean endsWith(String n) {
        if (n.length() > this.length) {
            return false;
        }
        int off = this.length - n.length();
        if (n.charAt(0) == this.value[off]) {
            int i = 0;
            int len = this.length - off;
            char[] v = this.value;
            while (++i < len && n.charAt(i) == v[off + i]) {
            }
            return i == len;
        }
        return false;
    }

    public final boolean endsWith(char[] n) {
        if (n.length > this.length) {
            return false;
        }
        int off = this.length - n.length;
        if (n[0] == this.value[off]) {
            int i = 0;
            int len = this.length - off;
            char[] v = this.value;
            while (++i < len && n[i] == v[off + i]) {
            }
            return i == len;
        }
        return false;
    }

    public final boolean endsWith(MStringIndexKey n) {
        if (n.isNull() || n.isEmpty()) {
            return false;
        }
        return this.endsWith(n.value);
    }

    public final int hashCode() {
        return this.hash;
    }

    public final int length() {
        return this.length;
    }

    public final char[] getChars() {
        return this.value;
    }

    public final String substring(int s, int e) {
        return String.copyValueOf(this.value, s, e - s);
    }

    public final String substring(int s) {
        return String.copyValueOf(this.value, s, this.value.length - s);
    }

    public final MStringIndexKey subMString(int s, int e) {
        int ln = e - s;
        char[] c = new char[ln];
        System.arraycopy(this.value, s, c, 0, ln);
        return new MStringIndexKey(c);
    }

    public final MStringIndexKey subMString(int s) {
        int ln = this.value.length - s;
        char[] c = new char[ln];
        System.arraycopy(this.value, s, c, 0, ln);
        return new MStringIndexKey(c);
    }

    public final String toString() {
        return String.copyValueOf(this.value);
    }

    protected static final int searchMStringIndexKey(MStringIndexKey[] a, MStringIndexKey key) {
        int low = 0;
        int high = a.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int cmp = a[mid].compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    protected static final int searchMStringIndexKeyBS(boolean big, MStringIndexKey[] a, MStringIndexKey key) {
        int low = 0;
        int high = a.length - 1;
        int mid = 0;
        while (low <= high) {
            mid = low + high >>> 1;
            int cmp = a[mid].compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        if (big) {
            if (a[mid].compareTo(key) > 0) {
                return mid;
            }
            if (a.length <= mid + 1) {
                return a.length - 1;
            }
            return mid + 1;
        }
        if (a[mid].compareTo(key) > 0) {
            if (mid <= 0) {
                return 0;
            }
            return mid - 1;
        }
        return mid;
    }
}

