/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.util;

import java.io.IOException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.maachang.mimdb.core.util.ObjectList;
import org.maachang.mimdb.core.util.StringUtils;

public final class DateFormatUtils {
    protected static final TimeZone GMT_TIMEZONE = TimeZone.getTimeZone("Europe/London");

    private DateFormatUtils() {
    }

    private static final int getYear(String v) throws Exception {
        String h = String.valueOf(new Date().getYear() + 1900);
        switch (v.length()) {
            case 0: {
                return StringUtils.parseInt(h) - 1900;
            }
            case 1: {
                return StringUtils.parseInt(h.substring(0, h.length() - 1) + v) - 1900;
            }
            case 2: {
                return StringUtils.parseInt(h.substring(0, h.length() - 2) + v) - 1900;
            }
            case 3: {
                return StringUtils.parseInt(h.substring(0, h.length() - 3) + v) - 1900;
            }
            case 4: {
                return StringUtils.parseInt(v) - 1900;
            }
        }
        throw new IOException("\u65e5\u4ed8\u306e\u6841\u6570\u304c[" + v.length() + "]\u3068\u4e0d\u6b63\u3067\u3059");
    }

    private static final int getMilliByNano(String v) throws Exception {
        if (v.length() > 3) {
            v = v.substring(0, 3);
        }
        return StringUtils.parseInt(v) * 1000000;
    }

    private static final Date cutDate(int type, String value) throws Exception {
        int len = value.length();
        ObjectList<String> list = new ObjectList<String>();
        StringBuilder buf = null;
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c >= '0' && c <= '9') {
                if (buf == null) {
                    buf = new StringBuilder();
                }
                buf.append(c);
                continue;
            }
            if (buf == null) continue;
            list.add(buf.toString());
            buf = null;
        }
        if (buf != null) {
            list.add(buf.toString());
            buf = null;
        }
        len = list.size();
        if (type == 0) {
            switch (len) {
                case 0: {
                    Date d = new Date();
                    return new java.sql.Date(d.getYear(), d.getMonth(), d.getDate());
                }
                case 1: {
                    return new java.sql.Date(DateFormatUtils.getYear((String)list.get(0)), 0, 1);
                }
                case 2: {
                    return new java.sql.Date(DateFormatUtils.getYear((String)list.get(0)), StringUtils.parseInt((String)list.get(1)) - 1, 1);
                }
            }
            return new java.sql.Date(DateFormatUtils.getYear((String)list.get(0)), StringUtils.parseInt((String)list.get(1)) - 1, StringUtils.parseInt((String)list.get(2)));
        }
        if (type == 1) {
            switch (len) {
                case 0: {
                    Date d = new Date();
                    return new Time(d.getHours(), d.getMinutes(), d.getSeconds());
                }
                case 1: {
                    return new Time(StringUtils.parseInt((String)list.get(0)), 0, 0);
                }
                case 2: {
                    return new Time(StringUtils.parseInt((String)list.get(0)), StringUtils.parseInt((String)list.get(1)), 0);
                }
            }
            return new Time(StringUtils.parseInt((String)list.get(0)), StringUtils.parseInt((String)list.get(1)), StringUtils.parseInt((String)list.get(2)));
        }
        switch (len) {
            case 0: {
                return new Timestamp(System.currentTimeMillis());
            }
            case 1: {
                return new Timestamp(DateFormatUtils.getYear((String)list.get(0)), 0, 1, 0, 0, 0, 0);
            }
            case 2: {
                return new Timestamp(DateFormatUtils.getYear((String)list.get(0)), StringUtils.parseInt((String)list.get(1)) - 1, 1, 0, 0, 0, 0);
            }
            case 3: {
                return new Timestamp(DateFormatUtils.getYear((String)list.get(0)), StringUtils.parseInt((String)list.get(1)) - 1, StringUtils.parseInt((String)list.get(2)), 0, 0, 0, 0);
            }
            case 4: {
                return new Timestamp(DateFormatUtils.getYear((String)list.get(0)), StringUtils.parseInt((String)list.get(1)) - 1, StringUtils.parseInt((String)list.get(2)), StringUtils.parseInt((String)list.get(3)), 0, 0, 0);
            }
            case 5: {
                return new Timestamp(DateFormatUtils.getYear((String)list.get(0)), StringUtils.parseInt((String)list.get(1)) - 1, StringUtils.parseInt((String)list.get(2)), StringUtils.parseInt((String)list.get(3)), StringUtils.parseInt((String)list.get(4)), 0, 0);
            }
            case 6: {
                return new Timestamp(DateFormatUtils.getYear((String)list.get(0)), StringUtils.parseInt((String)list.get(1)) - 1, StringUtils.parseInt((String)list.get(2)), StringUtils.parseInt((String)list.get(3)), StringUtils.parseInt((String)list.get(4)), StringUtils.parseInt((String)list.get(5)), 0);
            }
        }
        return new Timestamp(DateFormatUtils.getYear((String)list.get(0)), StringUtils.parseInt((String)list.get(1)) - 1, StringUtils.parseInt((String)list.get(2)), StringUtils.parseInt((String)list.get(3)), StringUtils.parseInt((String)list.get(4)), StringUtils.parseInt((String)list.get(5)), DateFormatUtils.getMilliByNano((String)list.get(6)));
    }

    private static final Date stringDate(int type, String value) throws Exception {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return null;
        }
        if (type == 0) {
            if (len < 4) {
                if (len == 0) {
                    Date d = new Date();
                    return new java.sql.Date(d.getYear(), d.getMonth(), d.getDate());
                }
                return new java.sql.Date(DateFormatUtils.getYear(value), 0, 1);
            }
            if (len < 6) {
                return new java.sql.Date(DateFormatUtils.getYear(value), 0, 1);
            }
            if (len < 8) {
                return new java.sql.Date(DateFormatUtils.getYear(value.substring(0, 4)), StringUtils.parseInt(value.substring(4, 6)) - 1, 1);
            }
            return new java.sql.Date(DateFormatUtils.getYear(value.substring(0, 4)), StringUtils.parseInt(value.substring(4, 6)) - 1, StringUtils.parseInt(value.substring(6, 8)));
        }
        if (type == 1) {
            if (len < 2) {
                if (len == 0) {
                    Date d = new Date();
                    return new Time(d.getHours(), d.getMinutes(), d.getSeconds());
                }
                return new Time(StringUtils.parseInt(value), 0, 0);
            }
            if (len < 4) {
                return new Time(StringUtils.parseInt(value.substring(0, 2)), 0, 0);
            }
            if (len < 6) {
                return new Time(StringUtils.parseInt(value.substring(0, 2)), StringUtils.parseInt(value.substring(2, 4)), 0);
            }
            return new Time(StringUtils.parseInt(value.substring(0, 2)), StringUtils.parseInt(value.substring(2, 4)), StringUtils.parseInt(value.substring(4, 6)));
        }
        if (len < 4) {
            if (len == 0) {
                return new Timestamp(System.currentTimeMillis());
            }
            return new Timestamp(DateFormatUtils.getYear(value), 0, 1, 0, 0, 0, 0);
        }
        if (len < 6) {
            return new Timestamp(DateFormatUtils.getYear(value), 0, 1, 0, 0, 0, 0);
        }
        if (len < 8) {
            return new Timestamp(DateFormatUtils.getYear(value.substring(0, 4)), StringUtils.parseInt(value.substring(4, 6)) - 1, 1, 0, 0, 0, 0);
        }
        if (len < 10) {
            return new Timestamp(DateFormatUtils.getYear(value.substring(0, 4)), StringUtils.parseInt(value.substring(4, 6)) - 1, StringUtils.parseInt(value.substring(6, 8)), 0, 0, 0, 0);
        }
        if (len < 12) {
            return new Timestamp(DateFormatUtils.getYear(value.substring(0, 4)), StringUtils.parseInt(value.substring(4, 6)) - 1, StringUtils.parseInt(value.substring(6, 8)), StringUtils.parseInt(value.substring(8, 10)), 0, 0, 0);
        }
        if (len < 14) {
            return new Timestamp(DateFormatUtils.getYear(value.substring(0, 4)), StringUtils.parseInt(value.substring(4, 6)) - 1, StringUtils.parseInt(value.substring(6, 8)), StringUtils.parseInt(value.substring(8, 10)), StringUtils.parseInt(value.substring(10, 12)), 0, 0);
        }
        if (len < 17) {
            if (len == 14) {
                return new Timestamp(DateFormatUtils.getYear(value.substring(0, 4)), StringUtils.parseInt(value.substring(4, 6)) - 1, StringUtils.parseInt(value.substring(6, 8)), StringUtils.parseInt(value.substring(8, 10)), StringUtils.parseInt(value.substring(10, 12)), StringUtils.parseInt(value.substring(12, 14)), 0);
            }
            return new Timestamp(DateFormatUtils.getYear(value.substring(0, 4)), StringUtils.parseInt(value.substring(4, 6)) - 1, StringUtils.parseInt(value.substring(6, 8)), StringUtils.parseInt(value.substring(8, 10)), StringUtils.parseInt(value.substring(10, 12)), StringUtils.parseInt(value.substring(12, 14)), DateFormatUtils.getMilliByNano(value.substring(14)));
        }
        return new Timestamp(DateFormatUtils.getYear(value.substring(0, 4)), StringUtils.parseInt(value.substring(4, 6)) - 1, StringUtils.parseInt(value.substring(6, 8)), StringUtils.parseInt(value.substring(8, 10)), StringUtils.parseInt(value.substring(10, 12)), StringUtils.parseInt(value.substring(12, 14)), DateFormatUtils.getMilliByNano(value.substring(14)));
    }

    public static final java.sql.Date getDate(String value) throws Exception {
        if (value == null || (value = value.trim()).length() <= 0) {
            return null;
        }
        java.sql.Date ret = (java.sql.Date)DateFormatUtils.stringDate(0, value);
        if (ret == null) {
            ret = (java.sql.Date)DateFormatUtils.cutDate(0, value);
        }
        return ret;
    }

    public static final Time getTime(String value) throws Exception {
        if (value == null || (value = value.trim()).length() <= 0) {
            return null;
        }
        Time ret = (Time)DateFormatUtils.stringDate(1, value);
        if (ret == null) {
            ret = (Time)DateFormatUtils.cutDate(1, value);
        }
        return ret;
    }

    public static final Timestamp getTimestamp(String value) throws Exception {
        if (value == null || (value = value.trim()).length() <= 0) {
            return null;
        }
        Timestamp ret = (Timestamp)DateFormatUtils.stringDate(2, value);
        if (ret == null) {
            ret = (Timestamp)DateFormatUtils.cutDate(2, value);
        }
        return ret;
    }

    public static final Timestamp getWebTimestamp(String value) throws Exception {
        if (value == null || (value = value.trim()).length() <= 0) {
            return null;
        }
        int len = value.length();
        ObjectList<String> list = new ObjectList<String>();
        StringBuilder buf = null;
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c != ' ' && c != '\t' && c != ',' && c != ':' && c != '-') {
                if (buf == null) {
                    buf = new StringBuilder();
                }
                buf.append(c);
                continue;
            }
            if (buf == null) continue;
            list.add(buf.toString());
            buf = null;
        }
        if (buf != null) {
            list.add(buf.toString());
            buf = null;
        }
        if ((len = list.size()) == 8) {
            GregorianCalendar cal = new GregorianCalendar(GMT_TIMEZONE);
            cal.clear();
            cal.set(5, StringUtils.parseInt((String)list.get(1)));
            String month = ((String)list.get(2)).toLowerCase();
            if ("jan".equals(month)) {
                cal.set(2, 0);
            } else if ("feb".equals(month)) {
                cal.set(2, 1);
            } else if ("mar".equals(month)) {
                cal.set(2, 2);
            } else if ("apr".equals(month)) {
                cal.set(2, 3);
            } else if ("may".equals(month)) {
                cal.set(2, 4);
            } else if ("jun".equals(month)) {
                cal.set(2, 5);
            } else if ("jul".equals(month)) {
                cal.set(2, 6);
            } else if ("aug".equals(month)) {
                cal.set(2, 7);
            } else if ("sep".equals(month)) {
                cal.set(2, 8);
            } else if ("oct".equals(month)) {
                cal.set(2, 9);
            } else if ("nov".equals(month)) {
                cal.set(2, 10);
            } else if ("dec".equals(month)) {
                cal.set(2, 11);
            }
            cal.set(1, StringUtils.parseInt((String)list.get(3)));
            cal.set(11, StringUtils.parseInt((String)list.get(4)));
            cal.set(12, StringUtils.parseInt((String)list.get(5)));
            cal.set(13, StringUtils.parseInt((String)list.get(6)));
            return new Timestamp(cal.getTime().getTime());
        }
        throw new IOException("\u4e0d\u6b63\u306awebTime\u30d5\u30a9\u30fc\u30de\u30c3\u30c8:" + value);
    }
}

