/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.util;

import org.maachang.mimdb.core.util.NumberKeySet;

public final class NumberKeyValue<V> {
    private static final int DEF_LENGTH = 8;
    private static final int MIN_LENGTH = 4;
    private NumberKeyValueChild[] list;
    private int mask;
    private int length;
    private int limit;
    private int base;
    private int pos = 0;
    private NumberKeyValueChild cPos = null;

    public NumberKeyValue() {
        this(8);
    }

    public NumberKeyValue(int size) {
        if (size <= 0) {
            size = 4;
        }
        size = NumberKeySet.bitMask(size);
        this.list = new NumberKeyValueChild[size];
        this.length = 0;
        this.mask = size - 1;
        this.limit = size;
        this.base = size;
    }

    public final void clear() {
        this.list = new NumberKeyValueChild[this.base];
        this.length = 0;
        this.mask = this.base - 1;
        this.limit = this.base;
    }

    public final void put(int b, V o) {
        NumberKeyValueChild nn;
        int h;
        if (this.length + 1 == this.limit) {
            int nLen = this.limit << 1;
            int msk = nLen - 1;
            NumberKeyValueChild[] nList = new NumberKeyValueChild[nLen];
            for (int i = 0; i < this.limit; ++i) {
                NumberKeyValueChild n = this.list[i];
                while (n != null) {
                    NumberKeyValueChild t;
                    h = n.b & msk;
                    if (nList[h] == null) {
                        t = n.n;
                        n.n = null;
                    } else {
                        t = n.n;
                        n.n = nList[h];
                    }
                    nList[h] = n;
                    n = t;
                }
            }
            this.list = nList;
            this.limit = nLen;
            this.mask = msk;
        }
        if ((nn = this.list[h = b & this.mask]) == null) {
            this.list[h] = new NumberKeyValueChild(b, o);
            ++this.length;
            return;
        }
        while (nn.n != null) {
            if (nn.b == b) {
                nn.o = o;
                return;
            }
            nn = nn.n;
        }
        if (nn.b == b) {
            nn.o = o;
        } else {
            nn.n = new NumberKeyValueChild(b, o);
            ++this.length;
        }
    }

    public final boolean containsKey(int b) {
        NumberKeyValueChild n = this.list[b & this.mask];
        while (n != null) {
            if (n.b == b) {
                return true;
            }
            n = n.n;
        }
        return false;
    }

    public final V get(int b) {
        NumberKeyValueChild n = this.list[b & this.mask];
        while (n != null) {
            if (n.b == b) {
                return (V)n.o;
            }
            n = n.n;
        }
        return null;
    }

    public final void remove(int b) {
        NumberKeyValueChild n = this.list[b & this.mask];
        NumberKeyValueChild bf = null;
        while (n != null) {
            if (n.b == b) {
                if (bf == null) {
                    this.list[b & this.mask] = n.n == null ? null : n.n;
                } else {
                    bf.n = n.n == null ? null : n.n;
                }
                --this.length;
                break;
            }
            bf = n;
            n = n.n;
        }
    }

    public final int size() {
        return this.length;
    }

    public final int[] keyArray() {
        if (this.length <= 0) {
            return null;
        }
        int cnt = 0;
        int[] ret = new int[this.length];
        for (int i = 0; i < this.limit; ++i) {
            if (this.list[i] == null) continue;
            NumberKeyValueChild n = this.list[i];
            while (n != null) {
                ret[cnt++] = n.b;
                n = n.n;
            }
        }
        return ret;
    }

    public final NumberKeyValue<V> reset() {
        this.pos = 0;
        this.cPos = null;
        return this;
    }

    public final boolean hasNext() {
        if (this.cPos != null && (this.cPos = this.cPos.n) != null) {
            return true;
        }
        while (this.pos < this.limit) {
            if ((this.cPos = this.list[this.pos++]) == null) continue;
            return true;
        }
        return false;
    }

    public final int next() {
        if (this.cPos == null) {
            return -1;
        }
        return this.cPos.b;
    }

    public final V nextValue() {
        if (this.cPos == null) {
            return null;
        }
        return (V)this.cPos.o;
    }

    private static final class NumberKeyValueChild {
        int b;
        Object o;
        NumberKeyValueChild n;

        NumberKeyValueChild(int k, Object v) {
            this.b = k;
            this.o = v;
        }
    }
}

