/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.util;

public final class NumberList {
    protected int[] list;
    protected int length;
    private int max;

    public NumberList() {
        this(16);
    }

    public NumberList(int buf) {
        if (buf < 16) {
            buf = 16;
        }
        this.max = buf;
        this.list = new int[buf];
        this.length = 0;
    }

    public void clear() {
        this.list = new int[this.max];
        this.length = 0;
    }

    public void add(int n) {
        if (this.length + 1 >= this.list.length) {
            int[] tmp = new int[this.length << 1];
            System.arraycopy(this.list, 0, tmp, 0, this.length);
            this.list = tmp;
        }
        this.list[this.length++] = n;
    }

    public void set(int no, int n) {
        this.list[no] = n;
    }

    public int get(int no) {
        return this.list[no];
    }

    public void remove(int no) {
        if (this.length > 1) {
            --this.length;
            while (no < this.length) {
                this.list[no++] = this.list[no];
            }
        } else {
            this.length = 0;
        }
    }

    public int size() {
        return this.length;
    }

    public int[] getArray() {
        int[] ret = new int[this.length];
        System.arraycopy(this.list, 0, ret, 0, this.length);
        return ret;
    }
}

